/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.model;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.internal.resource.OCLASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.xtext.base.ui.BaseUiPluginHelper;
import org.eclipse.ocl.xtext.base.ui.model.BaseDocument;
import org.eclipse.ocl.xtext.base.ui.model.BaseDocumentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.xtext.parsetree.reconstr.XtextSerializationException;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.validation.IConcreteSyntaxValidator;

public abstract class BaseCSorASDocumentProvider
extends BaseDocumentProvider {
    private static final Logger log = Logger.getLogger(BaseCSorASDocumentProvider.class);
    public static final String PERSIST_AS_PIVOT = "pivot";
    public static final String PERSIST_AS_TEXT = "text";
    protected Map<IDocument, String> loadedAsMap = new HashMap<IDocument, String>();
    protected Map<IDocument, String> exportDelegateURIMap = new HashMap<IDocument, String>();
    protected Map<IDocument, String> saveAsMap = new HashMap<IDocument, String>();
    protected Map<IDocument, URI> uriMap = new HashMap<IDocument, URI>();

    public static @NonNull InputStream createResettableInputStream(@NonNull InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int len;
            byte[] buffer = new byte[16384];
            while ((len = inputStream.read(buffer, 0, buffer.length)) > 0) {
                outputStream.write(buffer, 0, len);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    protected void diagnoseErrors(XtextResource xtextResource, Exception e) throws CoreException {
        List diagnostics = xtextResource.validateConcreteSyntax();
        if (diagnostics.size() > 0) {
            StringBuilder s = new StringBuilder();
            s.append("Concrete Syntax validation failed");
            for (Diagnostic diagnostic : diagnostics) {
                s.append("\n");
                s.append(diagnostic.toString());
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.xtext.base.ui", s.toString(), (Throwable)e));
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.xtext.base.ui", "Failed to load", (Throwable)e));
    }

    protected abstract @NonNull String createTestDocument(@NonNull URI var1, @NonNull String var2);

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        String saveAs = this.saveAsMap.get(document);
        if (element instanceof IFileEditorInput && document instanceof BaseDocument && !PERSIST_AS_TEXT.equals(saveAs)) {
            StringWriter xmlWriter = new StringWriter();
            try {
                URI uri = EditUIUtil.getURI((IEditorInput)((IFileEditorInput)element));
                if (uri == null) {
                    log.warn((Object)"No URI");
                } else if (PERSIST_AS_PIVOT.equals(saveAs)) {
                    ((BaseDocument)document).saveAsPivot(xmlWriter);
                } else {
                    log.warn((Object)("Unknown saveAs '" + saveAs + "'"));
                }
                Document saveDocument = new Document();
                saveDocument.set(xmlWriter.toString());
                super.doSaveDocument(monitor, element, (IDocument)saveDocument, overwrite);
                this.loadedAsMap.put(document, saveAs);
            }
            catch (Exception e) {
                BaseUiPluginHelper helper = BaseUiPluginHelper.INSTANCE;
                String title = helper.getString("_UI_SaveFailure_title", true);
                String message = helper.getString("_UI_SaveFailure_message", true);
                ErrorDialog.openError(null, (String)title, (String)message, (IStatus)helper.createErrorStatus(e));
                monitor.setCanceled(true);
            }
        } else {
            super.doSaveDocument(monitor, element, document, overwrite);
        }
    }

    protected abstract String getCScontentType();

    protected abstract @NonNull String getFileExtension();

    protected void handleElementContentChanged(IFileEditorInput fileEditorInput) {
        FileDocumentProvider.FileInfo info = (FileDocumentProvider.FileInfo)this.getElementInfo(fileEditorInput);
        if (info == null) {
            return;
        }
        if (info.fDocument == null) {
            super.handleElementContentChanged(fileEditorInput);
        }
        IDocument document = info.fDocument;
        String oldContent = document.get();
        IStatus status = null;
        try {
            try {
                this.refreshFile(fileEditorInput.getFile());
            }
            catch (CoreException x) {
                this.handleCoreException(x, "FileDocumentProvider.handleElementContentChanged");
            }
            this.cacheEncodingState(fileEditorInput);
            this.setDocumentContent(document, (IEditorInput)fileEditorInput, info.fEncoding);
        }
        catch (CoreException x) {
            status = x.getStatus();
        }
        String newContent = document.get();
        if (!newContent.equals(oldContent)) {
            this.fireElementContentAboutToBeReplaced(fileEditorInput);
            this.removeUnchangedElementListeners(fileEditorInput, (AbstractDocumentProvider.ElementInfo)info);
            info.fDocument.removeDocumentListener((IDocumentListener)info);
            info.fDocument.set(newContent);
            info.fCanBeSaved = false;
            info.fModificationStamp = this.computeModificationStamp((IResource)fileEditorInput.getFile());
            info.fStatus = status;
            this.addUnchangedElementListeners(fileEditorInput, (AbstractDocumentProvider.ElementInfo)info);
            this.fireElementContentReplaced(fileEditorInput);
        } else {
            this.removeUnchangedElementListeners(fileEditorInput, (AbstractDocumentProvider.ElementInfo)info);
            info.fCanBeSaved = false;
            info.fModificationStamp = this.computeModificationStamp((IResource)fileEditorInput.getFile());
            info.fStatus = status;
            this.addUnchangedElementListeners(fileEditorInput, (AbstractDocumentProvider.ElementInfo)info);
            this.fireElementDirtyStateChanged(fileEditorInput, false);
        }
    }

    public boolean isDeleted(Object element) {
        IDocument document = this.getDocument(element);
        String loadIsEcore = this.loadedAsMap.get(document);
        String saveIsEcore = this.saveAsMap.get(document);
        if (loadIsEcore != null && !loadIsEcore.equals(saveIsEcore)) {
            return true;
        }
        return super.isDeleted(element);
    }

    @Deprecated
    protected boolean isXML(@NonNull InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line = reader.readLine();
            inputStream.reset();
            boolean bl = line != null && line.startsWith("<?xml");
            return bl;
        }
    }

    protected boolean isXML(@NonNull InputStream inputStream, String encoding) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, encoding));){
            String line = reader.readLine();
            inputStream.reset();
            boolean bl = line != null && line.startsWith("<?xml");
            return bl;
        }
    }

    @Override
    protected void loadResource(XtextResource resource, String document, String encoding) throws CoreException {
        assert (resource != null);
        this.getOCL().getEnvironmentFactory().adapt((Notifier)resource);
        super.loadResource(resource, document, encoding);
    }

    @Override
    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        URI uri = EditUIUtil.getURI((IEditorInput)editorInput);
        this.uriMap.put(document, uri);
        return super.setDocumentContent(document, editorInput, encoding);
    }

    protected void setDocumentContent(IDocument document, InputStream inputStream, String encoding) throws CoreException {
        try {
            if (!inputStream.markSupported()) {
                inputStream = BaseCSorASDocumentProvider.createResettableInputStream(inputStream);
            }
            boolean isXML = this.isXML(inputStream, encoding);
            String persistAs = PERSIST_AS_TEXT;
            if (isXML) {
                EObject xmiRoot;
                URI uri;
                XMLResource xmiResource;
                ResourceSet asResourceSet = this.getOCL().getMetamodelManager().getASResourceSet();
                StandaloneProjectMap projectMap = StandaloneProjectMap.getAdapter((ResourceSet)asResourceSet);
                ProjectManager.IConflictHandler conflictHandler = StandaloneProjectMap.MapToFirstConflictHandlerWithLog.INSTANCE;
                projectMap.configure(asResourceSet, StandaloneProjectMap.LoadFirstStrategy.INSTANCE, conflictHandler);
                ProjectManager.IProjectDescriptor pivotPackageDescriptor = projectMap.getProjectDescriptor("org.eclipse.ocl.pivot");
                if (pivotPackageDescriptor != null) {
                    pivotPackageDescriptor.configure(asResourceSet, StandaloneProjectMap.LoadBothStrategy.INSTANCE, conflictHandler);
                }
                if ((xmiResource = (XMLResource)asResourceSet.getResource(uri = this.uriMap.get(document), false)) == null || xmiResource.getResourceSet() == null) {
                    xmiResource = (XMLResource)asResourceSet.createResource(uri, null);
                } else {
                    xmiResource.unload();
                }
                xmiResource.load(inputStream, null);
                EcoreUtil.resolveAll((ResourceSet)asResourceSet);
                ArrayList allErrors = null;
                for (Resource resource : asResourceSet.getResources()) {
                    EList errors = resource.getErrors();
                    if (errors.size() <= 0) continue;
                    if (allErrors == null) {
                        allErrors = new ArrayList();
                    }
                    allErrors.addAll(errors);
                }
                if (allErrors != null) {
                    StringBuilder s = new StringBuilder();
                    for (Resource.Diagnostic diagnostic : allErrors) {
                        s.append("\n");
                        s.append(diagnostic.toString());
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.xtext.base.ui", s.toString()));
                }
                ASResource asResource = null;
                EList contents = xmiResource.getContents();
                if (contents.size() > 0 && (xmiRoot = (EObject)contents.get(0)) instanceof Model) {
                    asResource = (ASResource)xmiResource;
                    persistAs = PERSIST_AS_PIVOT;
                }
                if (asResource == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.xtext.base.ui", "Failed to load"));
                }
                ResourceSetImpl csResourceSet = (ResourceSetImpl)this.getOCL().getResourceSet();
                csResourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ocl/2015/Pivot", (Object)PivotPackage.eINSTANCE);
                URI textURI = xmiResource.getURI().appendFileExtension(this.getFileExtension());
                CSResource csResource = (CSResource)csResourceSet.getResource(textURI, false);
                if (csResource == null) {
                    csResource = (CSResource)csResourceSet.createResource(textURI, this.getCScontentType());
                    Map map = csResourceSet.getURIResourceMap();
                    map.put(textURI, csResource);
                    csResource.setURI(xmiResource.getURI());
                }
                csResource.updateFrom(asResource, (EnvironmentFactory)this.getOCL().getEnvironmentFactory());
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                try {
                    try {
                        csResource.save((OutputStream)outputStream, null);
                    }
                    catch (RuntimeException e) {
                        Resource csResource2 = new XMIResourceFactoryImpl().createResource(csResource.getURI().appendFileExtension("xmi"));
                        csResource2.getContents().addAll((Collection)csResource.getContents());
                        csResource2.save((OutputStream)outputStream, null);
                        csResource.getContents().addAll((Collection)csResource2.getContents());
                        BaseUiPluginHelper helper = BaseUiPluginHelper.INSTANCE;
                        String title = helper.getString("_UI_SerializationFailure_title", true);
                        String message = helper.getString("_UI_SerializationFailure_message", true);
                        Status errorStatus = helper.createErrorStatus(e);
                        ErrorDialog.openError(null, (String)title, (String)message, (IStatus)errorStatus);
                    }
                    inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                }
                catch (IConcreteSyntaxValidator.InvalidConcreteSyntaxException e) {
                    this.diagnoseErrors((XtextResource)csResource, (Exception)((Object)e));
                }
                catch (XtextSerializationException e) {
                    this.diagnoseErrors((XtextResource)csResource, (Exception)((Object)e));
                }
                csResource.unload();
                csResourceSet.getResources().remove((Object)csResource);
            } else if (inputStream.available() == 0) {
                String lastSegment;
                URI uri = (URI)ClassUtil.nonNullState((Object)this.uriMap.get(document));
                Resource.Factory factory = Resource.Factory.Registry.INSTANCE.getFactory(uri);
                if (factory instanceof OCLASResourceFactory) {
                    persistAs = PERSIST_AS_PIVOT;
                }
                if ((lastSegment = uri.trimFileExtension().lastSegment()) == null) {
                    lastSegment = "Default";
                }
                String testDocument = this.createTestDocument(uri, lastSegment);
                inputStream = new ByteArrayInputStream(testDocument.getBytes());
            }
            this.loadedAsMap.put(document, persistAs);
            this.saveAsMap.put(document, persistAs);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.xtext.base.ui", "Failed to load", (Throwable)e));
        }
        super.setDocumentContent(document, inputStream, encoding);
    }

    public void setExportDelegateURI(Object element, String uri) {
        this.exportDelegateURIMap.put(this.getDocument(element), uri);
    }

    public void setPersistAs(Object element, String persistAs) {
        this.saveAsMap.put(this.getDocument(element), persistAs);
        this.setCanSaveDocument(element);
    }

    protected void superDoSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        super.doSaveDocument(monitor, element, document, overwrite);
    }

    @Deprecated
    protected void superSetDocumentText(@NonNull XtextDocument document, @NonNull String displayText) throws CoreException {
    }

    protected void superSetDocumentContent(IDocument document, InputStream inputStream, String encoding) throws CoreException {
        super.setDocumentContent(document, inputStream, encoding);
    }
}

