/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.util.uml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.GQAM.GaLatencyObs;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.GQAM.GaResourcesPlatform;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.GQAM.GaWorkloadEvent;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.SAM.SaAnalysisContext;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.SAM.SaEndtoEndFlow;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.SAM.SaExecHost;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.SAM.SaStep;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.ClientServerKind;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.ClientServerPort;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.Alloc.Assign;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.GRM.ResourceUsage;
import org.eclipse.papyrus.infra.emf.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.internal.impl.DependencyImpl;
import org.polarsys.chess.chessmlprofile.ComponentModel.ComponentImplementation;
import org.polarsys.chess.chessmlprofile.ComponentModel.FunctionalPartition;
import org.polarsys.chess.chessmlprofile.Core.CHGaResourcePlatform;
import org.polarsys.chess.chessmlprofile.Core.PSMPackage;
import org.polarsys.chess.chessmlprofile.Predictability.ARINCComponentModel.ARINCFunction;
import org.polarsys.chess.chessmlprofile.Predictability.ARINCComponentModel.ARINCProcess;
import org.polarsys.chess.chessmlprofile.Predictability.DeploymentConfiguration.HardwareBaseline.CH_HwProcessor;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtPortSlot;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtSpecification;
import org.polarsys.chess.core.profiles.CHESSProfileManager;
import org.polarsys.chess.core.util.AnalysisResultData;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.util.EndToEndResultData;
import org.polarsys.chess.core.util.HWAnalysisResultData;
import org.polarsys.chess.core.util.uml.ModelError;
import org.polarsys.chess.core.util.uml.ValueNFP;
import org.polarsys.chess.core.views.ViewUtils;

public class UMLUtils {
    public static String getElementID(Element el) {
        Resource resource = el.eResource();
        if (resource != null) {
            return resource.getURIFragment((EObject)el);
        }
        return null;
    }

    public static boolean hasPublicVisibility(Operation operation) {
        return operation.getVisibility().getValue() == 0;
    }

    public static boolean areParametersEqual(Parameter param, Parameter aux) {
        if (!param.getName().equals(aux.getName())) {
            return false;
        }
        if (param.getDirection().getValue() != aux.getDirection().getValue()) {
            return false;
        }
        if (param.getVisibility().getValue() != aux.getVisibility().getValue()) {
            return false;
        }
        if (param.isException() != aux.isException()) {
            return false;
        }
        if (param.isMultivalued() != aux.isMultivalued()) {
            return false;
        }
        if (param.isOrdered() != aux.isOrdered()) {
            return false;
        }
        if (param.isSetDefault() != aux.isSetDefault()) {
            return false;
        }
        if (param.isUnique() != aux.isUnique()) {
            return false;
        }
        if (param.isStream() != aux.isStream()) {
            return false;
        }
        if (param.getEffect().getValue() != aux.getEffect().getValue()) {
            return false;
        }
        if (param.lowerBound() != aux.lowerBound()) {
            return false;
        }
        return param.upperBound() == aux.upperBound();
    }

    public static void copyOperation(Operation source, Operation target) {
        for (Parameter param : source.getOwnedParameters()) {
            Parameter p = target.createOwnedParameter(param.getName(), param.getType());
            p.setDirection(param.getDirection());
            p.setEffect(param.getEffect());
            p.setDefaultValue(param.getDefaultValue());
            p.setDefault(param.getDefault());
            p.setIsException(param.isException());
            p.setIsOrdered(param.isOrdered());
            p.setIsStream(param.isStream());
            p.setIsUnique(param.isUnique());
            p.setLower(param.getLower());
            p.setLowerValue(param.getLowerValue());
            p.setTemplateParameter(param.getTemplateParameter());
            p.setUpper(param.getUpper());
            p.setUpperValue(param.getUpperValue());
            p.setVisibility(param.getVisibility());
        }
        target.setVisibility(source.getVisibility());
        target.setConcurrency(source.getConcurrency());
        target.setIsQuery(source.isQuery());
        target.setIsLeaf(source.isLeaf());
        target.setIsStatic(source.isStatic());
    }

    public static boolean areOperationsEqual(Operation source, Operation target, Parameter p) {
        if (!source.getName().equalsIgnoreCase(target.getName())) {
            return false;
        }
        EList targetList = target.getOwnedParameters();
        EList sourceList = source.getOwnedParameters();
        if (p == null ? targetList.size() != sourceList.size() : targetList.size() + 1 != sourceList.size()) {
            return false;
        }
        if (source.getVisibility().getValue() != target.getVisibility().getValue()) {
            return false;
        }
        if (source.isQuery() != target.isQuery()) {
            return false;
        }
        if (source.isLeaf() != target.isLeaf()) {
            return false;
        }
        if (source.isStatic() != target.isStatic()) {
            return false;
        }
        if (source.getConcurrency().getValue() != target.getConcurrency().getValue()) {
            return false;
        }
        int i = 0;
        while (i < targetList.size()) {
            Parameter param = (Parameter)targetList.get(i);
            Parameter aux = source.getOwnedParameter(param.getName(), param.getType());
            if (aux == null) {
                return false;
            }
            if (param != null && aux != null && !UMLUtils.areParametersEqual(param, aux)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean areParametersEquals(Operation source, Operation target, Parameter p) {
        EList targetList = target.getOwnedParameters();
        if (targetList.size() != source.getOwnedParameters().size()) {
            return false;
        }
        for (Parameter param : targetList) {
            if (p != null && p.getName().equalsIgnoreCase(param.getName())) continue;
            Parameter aux = source.getOwnedParameter(param.getName(), param.getType());
            if (aux == null) {
                return false;
            }
            if (UMLUtils.areParametersEqual(param, aux)) continue;
            return false;
        }
        return true;
    }

    public static boolean areParametersEquals(Operation source, Operation target) {
        return UMLUtils.areParametersEquals(source, target, null);
    }

    public static boolean isOperationEquals(Operation source, Operation target) {
        return UMLUtils.areOperationsEqual(source, target, null);
    }

    public static boolean isOperationContained(Classifier component, Operation operation) {
        for (Operation op : component.getOperations()) {
            if (!op.getName().equals(operation.getName()) || !UMLUtils.isOperationEquals(op, operation)) continue;
            return true;
        }
        return false;
    }

    public static EList<NamedElement> getInterfaceClients(Interface interfce) {
        BasicEList relationships = new BasicEList();
        for (Relationship rel : interfce.getRelationships()) {
            if (!(rel instanceof InterfaceRealization)) continue;
            InterfaceRealization intRel = (InterfaceRealization)rel;
            relationships.addAll((Collection)intRel.getClients());
        }
        return relationships;
    }

    public static EList<Component> getComponentImplementations(Component comp) {
        BasicEList list = new BasicEList();
        EList<Component> compImpls = UMLUtils.retrieveComponentImplementations(ViewUtils.getView((EObject)comp));
        for (Component el : compImpls) {
            for (Dependency dep : el.getClientDependencies()) {
                if (!(dep instanceof Realization) || dep.getSupplier(comp.getName()) == null) continue;
                list.add((Object)el);
            }
        }
        return list;
    }

    private static EList<Component> retrieveComponentImplementations(Package pkg) {
        BasicEList comps = new BasicEList();
        for (Element el : pkg.getOwnedElements()) {
            EList<Component> list;
            if (el instanceof Component && UMLUtils.isComponentImplementation(el)) {
                comps.add((Object)((Component)el));
            }
            if (!(el instanceof Package) || (list = UMLUtils.retrieveComponentImplementations((Package)el)).isEmpty()) continue;
            comps.addAll(list);
        }
        return comps;
    }

    public static boolean isComponentType(Object el) {
        return el instanceof Component && ((Element)el).getAppliedStereotype("CHESS::ComponentModel::ComponentType") != null;
    }

    public static boolean isComponentImplementation(Object el) {
        return el instanceof Component && ((Element)el).getAppliedStereotype("CHESS::ComponentModel::ComponentImplementation") != null;
    }

    public static EList<ClientServerPort> getComponentClientServerPorts(Component component) {
        BasicEList ports = new BasicEList();
        for (Element e : component.getOwnedElements()) {
            if (!(e instanceof Port)) continue;
            Port p = (Port)e;
            for (EObject st : p.getStereotypeApplications()) {
                if (!(st instanceof ClientServerPort)) continue;
                ClientServerPort csp = (ClientServerPort)st;
                ports.add((Object)csp);
            }
        }
        return ports;
    }

    public static EList<Dependency> computeDependenciesToRemove(Component comp) {
        EList cDependencies = comp.getClientDependencies();
        BasicEList cDependentInterfaces = new BasicEList();
        HashMap<Interface, Dependency> cDependenciesToRemoveMap = new HashMap<Interface, Dependency>();
        for (Dependency dependency : cDependencies) {
            if (!dependency.getClass().equals(DependencyImpl.class)) continue;
            for (NamedElement el : dependency.getSuppliers()) {
                if (!(el instanceof Interface)) continue;
                cDependentInterfaces.add((Object)((Interface)el));
                cDependenciesToRemoveMap.put((Interface)el, dependency);
            }
        }
        EList<ClientServerPort> ports = UMLUtils.getComponentClientServerPorts(comp);
        BasicEList portInts = new BasicEList();
        for (ClientServerPort csp : ports) {
            if (csp.getKind() != ClientServerKind.REQUIRED && csp.getKind() != ClientServerKind.PROREQ) continue;
            portInts.addAll((Collection)csp.getReqInterface());
        }
        if (portInts != null) {
            cDependentInterfaces.removeAll((Collection)portInts);
        }
        BasicEList cDependenciesToRemove = new BasicEList();
        for (Interface el : cDependentInterfaces) {
            Dependency dep = (Dependency)cDependenciesToRemoveMap.get(el);
            if (dep == null) continue;
            cDependenciesToRemove.add((Object)dep);
        }
        return cDependenciesToRemove;
    }

    public static EList<InterfaceRealization> computeRealizationsToRemove(Component comp) {
        EList cRealizations = comp.getInterfaceRealizations();
        BasicEList cRealizedInterfaces = new BasicEList();
        HashMap<Interface, InterfaceRealization> cRealizationsToRemoveMap = new HashMap<Interface, InterfaceRealization>();
        for (InterfaceRealization ir : cRealizations) {
            cRealizedInterfaces.add((Object)ir.getContract());
            cRealizationsToRemoveMap.put(ir.getContract(), ir);
        }
        EList<ClientServerPort> ports = UMLUtils.getComponentClientServerPorts(comp);
        BasicEList portInts = new BasicEList();
        for (ClientServerPort csp : ports) {
            if (csp.getKind() != ClientServerKind.PROVIDED && csp.getKind() != ClientServerKind.PROREQ) continue;
            portInts.addAll((Collection)csp.getProvInterface());
        }
        if (portInts != null) {
            cRealizedInterfaces.removeAll((Collection)portInts);
        }
        BasicEList cRealizationsToRemove = new BasicEList();
        for (Interface el : cRealizedInterfaces) {
            InterfaceRealization dep = (InterfaceRealization)cRealizationsToRemoveMap.get(el);
            if (dep == null) continue;
            cRealizationsToRemove.add((Object)dep);
        }
        return cRealizationsToRemove;
    }

    public static boolean isClientServerPort(Object el) {
        return el instanceof Port && ((Element)el).getAppliedStereotype("MARTE::MARTE_DesignModel::GCM::ClientServerPort") != null;
    }

    public static Stereotype getCHRtSpecification(Object el) {
        if (el instanceof Comment) {
            return ((Element)el).getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtSpecification");
        }
        return null;
    }

    public static EList<Comment> getCHRtSpecificationComments(Package pkg, Port portFilter) {
        BasicEList chrtspecs = new BasicEList();
        for (Element el : pkg.getOwnedElements()) {
            if (!(el instanceof Component)) continue;
            for (Comment comm : el.getOwnedComments()) {
                Stereotype chrtspecification = UMLUtils.getCHRtSpecification(comm);
                if (chrtspecification == null) continue;
                if (portFilter != null) {
                    if (comm.getValue(chrtspecification, "partWithPort") == null || !comm.getValue(chrtspecification, "partWithPort").equals(portFilter)) continue;
                    chrtspecs.add((Object)comm);
                    continue;
                }
                chrtspecs.add((Object)comm);
            }
        }
        return chrtspecs;
    }

    public static <T extends EObject> T getStereotypeApplication(Element element, java.lang.Class<T> stereotypeClass) {
        for (EObject stereoApplication : element.getStereotypeApplications()) {
            if (!stereotypeClass.isInstance(stereoApplication)) continue;
            return (T)stereoApplication;
        }
        return null;
    }

    public static EList<Component> getAllInterfaceComponents(Interface interfce) {
        BasicEList list = new BasicEList();
        for (NamedElement el : UMLUtils.getInterfaceClients(interfce)) {
            if (!(el instanceof Component) || !UMLUtils.isComponentType(el)) continue;
            list.add((Object)((Component)el));
            EList<Component> compList = UMLUtils.getComponentImplementations((Component)el);
            if (compList.isEmpty()) continue;
            list.addAll(compList);
        }
        return list;
    }

    public static Stereotype getStereotype(Element element, String qualifiedName) {
        Stereotype str = element.getApplicableStereotype(qualifiedName);
        return str;
    }

    public static Stereotype applyStereotype(Element element, String qualifiedName) {
        Stereotype str = UMLUtils.getStereotype(element, qualifiedName);
        if (str != null) {
            element.applyStereotype(str);
        }
        return str;
    }

    public static EList<Assign> getAll2CoreAssignments(Model umlModel, String viewName) throws ModelError {
        Package parent = CHESSProfileManager.getViewByStereotype(umlModel, viewName);
        EList all = parent.allOwnedElements();
        BasicEList assignments = new BasicEList();
        Stereotype stereo = null;
        for (Element element : all) {
            if (element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign") == null) continue;
            stereo = element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign");
            EObject eobj = element.getStereotypeApplication(stereo);
            Assign a = (Assign)eobj;
            assignments.add((Object)a);
        }
        return assignments;
    }

    public static EList<Assign> getComponent2CoreAssignments(Model umlModel, String viewName) throws ModelError {
        Package parent = CHESSProfileManager.getViewByStereotype(umlModel, viewName);
        EList all = parent.allOwnedElements();
        BasicEList assignments = new BasicEList();
        Stereotype stereo = null;
        for (Element element : all) {
            if (element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign") == null) continue;
            stereo = element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign");
            EObject eobj = element.getStereotypeApplication(stereo);
            Assign a = (Assign)eobj;
            try {
                InstanceSpecification componentInst;
                Element assignmentSource = (Element)a.getFrom().get(0);
                Element assignmentTarget = (Element)a.getTo().get(0);
                if (!UMLUtils.elementIsProcessorInstance(assignmentTarget) || !UMLUtils.elementIsComponentInstance(assignmentSource) || !UMLUtils.isComponentInstance(componentInst = (InstanceSpecification)assignmentSource)) continue;
                assignments.add((Object)a);
            }
            catch (Exception exception) {}
        }
        return assignments;
    }

    public static EList<Assign> getAllPartitionAssignments(Model umlModel, String viewName) throws ModelError {
        Package parent = CHESSProfileManager.getViewByStereotype(umlModel, viewName);
        EList all = parent.allOwnedElements();
        BasicEList assignments = new BasicEList();
        Stereotype stereo = null;
        for (Element element : all) {
            if (element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign") == null) continue;
            stereo = element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign");
            EObject eobj = element.getStereotypeApplication(stereo);
            Assign a = (Assign)eobj;
            try {
                InstanceSpecification componentInst;
                Element assignmentSource = (Element)a.getFrom().get(0);
                Element assignmentTarget = (Element)a.getTo().get(0);
                if (UMLUtils.elementIsPartitionInstance(assignmentSource) && UMLUtils.elementIsProcessorInstance(assignmentTarget)) {
                    assignments.add((Object)a);
                }
                if (!UMLUtils.elementIsPartitionInstance(assignmentTarget) || !UMLUtils.elementIsComponentInstance(assignmentSource) || !UMLUtils.isComponentInstance(componentInst = (InstanceSpecification)assignmentSource)) continue;
                assignments.add((Object)a);
            }
            catch (Exception exception) {}
        }
        return assignments;
    }

    public static EList<Assign> getPartitionAssignments(Model umlModel, FunctionalPartition functPart) throws ModelError {
        Package parent = CHESSProfileManager.getViewByStereotype(umlModel, "DeploymentView");
        EList allDeplViewElems = parent.allOwnedElements();
        BasicEList assignments = new BasicEList();
        Stereotype stereo = null;
        for (Element element : allDeplViewElems) {
            if (element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign") == null) continue;
            stereo = element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign");
            EObject eobj = element.getStereotypeApplication(stereo);
            Assign a = (Assign)eobj;
            try {
                InstanceSpecification instSpecSource;
                Element assignmentSource = (Element)a.getFrom().get(0);
                Element assignmentTarget = (Element)a.getTo().get(0);
                if (!UMLUtils.elementIsPartitionInstance(assignmentSource) || !UMLUtils.elementIsProcessorInstance(assignmentTarget) || !((Classifier)(instSpecSource = (InstanceSpecification)assignmentSource).getClassifiers().get(0)).equals(functPart.getBase_Component())) continue;
                assignments.add((Object)a);
            }
            catch (Exception exception) {}
        }
        parent = CHESSProfileManager.getViewByStereotype(umlModel, "ComponentView");
        EList allCompViewElems = parent.allOwnedElements();
        for (Element element : allCompViewElems) {
            if (element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign") == null) continue;
            stereo = element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign");
            EObject eobj = element.getStereotypeApplication(stereo);
            Assign a = (Assign)eobj;
            try {
                InstanceSpecification instSpecTarget;
                InstanceSpecification instSpecSource;
                Element assignmentSource = (Element)a.getFrom().get(0);
                Element assignmentTarget = (Element)a.getTo().get(0);
                if (!UMLUtils.elementIsPartitionInstance(assignmentTarget) || !UMLUtils.elementIsComponentInstance(assignmentSource) || !UMLUtils.isComponentInstance(instSpecSource = (InstanceSpecification)assignmentSource) || !((Classifier)(instSpecTarget = (InstanceSpecification)assignmentTarget).getClassifiers().get(0)).equals(functPart.getBase_Component())) continue;
                assignments.add((Object)a);
            }
            catch (Exception exception) {}
        }
        return assignments;
    }

    public static EList<Assign> getPartition2CoreAssignments(Model umlModel, String viewName) throws ModelError {
        Package parent = CHESSProfileManager.getViewByStereotype(umlModel, viewName);
        EList all = parent.allOwnedElements();
        BasicEList assignments = new BasicEList();
        Stereotype stereo = null;
        for (Element element : all) {
            if (element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign") == null) continue;
            stereo = element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign");
            EObject eobj = element.getStereotypeApplication(stereo);
            Assign a = (Assign)eobj;
            try {
                Element assignmentSource = (Element)a.getFrom().get(0);
                Element assignmentTarget = (Element)a.getTo().get(0);
                if (!UMLUtils.elementIsPartitionInstance(assignmentSource) || !UMLUtils.elementIsProcessorInstance(assignmentTarget)) continue;
                assignments.add((Object)a);
            }
            catch (Exception exception) {}
        }
        return assignments;
    }

    public static EList<Assign> getTask2CoreAssignments(Model umlModel, String viewName) throws ModelError {
        Package parent = CHESSProfileManager.getViewByStereotype(umlModel, viewName);
        EList all = parent.allOwnedElements();
        BasicEList assignments = new BasicEList();
        Stereotype stereo = null;
        for (Element element : all) {
            if (element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign") == null) continue;
            stereo = element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign");
            EObject eobj = element.getStereotypeApplication(stereo);
            Assign a = (Assign)eobj;
            try {
                Element assignmentSource = (Element)a.getFrom().get(0);
                Element assignmentTarget = (Element)a.getTo().get(0);
                if (!UMLUtils.elementIsSlotInstance(assignmentSource) || !UMLUtils.elementIsProcessorInstance(assignmentTarget)) continue;
                assignments.add((Object)a);
            }
            catch (Exception exception) {}
        }
        return assignments;
    }

    public static EList<Assign> getComponentAssignments(Model umlModel, String viewName) throws ModelError {
        Package parent = CHESSProfileManager.getViewByStereotype(umlModel, viewName);
        EList all = parent.allOwnedElements();
        BasicEList assignments = new BasicEList();
        Stereotype stereo = null;
        for (Element element : all) {
            if (element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign") == null) continue;
            stereo = element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign");
            EObject eobj = element.getStereotypeApplication(stereo);
            Assign a = (Assign)eobj;
            try {
                InstanceSpecification componentInst;
                Element assignmentSource = (Element)a.getFrom().get(0);
                if (!UMLUtils.elementIsComponentInstance(assignmentSource) || !UMLUtils.isComponentInstance(componentInst = (InstanceSpecification)assignmentSource)) continue;
                assignments.add((Object)a);
            }
            catch (Exception exception) {}
        }
        return assignments;
    }

    public static Component getResourcePlatformComponent(Model umlModel, String viewName) throws ModelError {
        Package parent = CHESSProfileManager.getViewByStereotype(umlModel, viewName);
        if (parent == null) {
            throw new ModelError(String.valueOf(viewName) + " not found.");
        }
        LinkedList<Element> breadthFirstList = new LinkedList<Element>();
        breadthFirstList.addAll((Collection<Element>)parent.getOwnedElements());
        while (!breadthFirstList.isEmpty()) {
            Component candidate;
            CHGaResourcePlatform a;
            Element t = (Element)breadthFirstList.poll();
            if (t instanceof Component && (a = UMLUtils.getStereotypeApplication((Element)(candidate = (Component)t), CHGaResourcePlatform.class)) != null) {
                return candidate;
            }
            for (Element e : t.getOwnedElements()) {
                breadthFirstList.addLast(e);
            }
        }
        throw new ModelError("CHGaResourcePlatform not found in " + viewName + " view.");
    }

    public static Component getResourcePlatformComponentInPackage(Model umlModel, Package pack) throws ModelError {
        LinkedList<Element> breadthFirstList = new LinkedList<Element>();
        breadthFirstList.addAll((Collection<Element>)pack.getOwnedElements());
        while (!breadthFirstList.isEmpty()) {
            Component candidate;
            CHGaResourcePlatform a;
            Element t = (Element)breadthFirstList.poll();
            if (t instanceof Component && (a = UMLUtils.getStereotypeApplication((Element)(candidate = (Component)t), CHGaResourcePlatform.class)) != null) {
                return candidate;
            }
            for (Element e : t.getOwnedElements()) {
                breadthFirstList.addLast(e);
            }
        }
        throw new ModelError("CHGaResourcePlatform not found in " + pack.getName() + " package.");
    }

    public static boolean elementIsProcessorInstance(Element element) {
        if (!(element instanceof InstanceSpecification)) {
            return false;
        }
        InstanceSpecification is = (InstanceSpecification)element;
        return is.getQualifiedName() != null && UMLUtils.isProcessorInstance(is);
    }

    public static boolean isProcessorInstance(InstanceSpecification e) {
        for (Classifier c : e.getClassifiers()) {
            if (UMLUtils.getStereotypeApplication((Element)c, CH_HwProcessor.class) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean elementIsComponentInstance(Element element) {
        if (!(element instanceof InstanceSpecification)) {
            return false;
        }
        InstanceSpecification is = (InstanceSpecification)element;
        return is.getQualifiedName() != null && UMLUtils.isComponentInstance(is);
    }

    public static boolean isComponentInstance(InstanceSpecification e) {
        for (Classifier c : e.getClassifiers()) {
            if (UMLUtils.getStereotypeApplication((Element)c, ComponentImplementation.class) == null) continue;
            return true;
        }
        return false;
    }

    public static int isAssigned2HowManyProcessingUnits(InstanceSpecification i, Element theDeploymentElem, EList<Assign> assignments) {
        int count = 0;
        for (Assign theAssignment : assignments) {
            if (theAssignment == null) continue;
            try {
                Element chgaResPlat;
                Element toElem = (Element)theAssignment.getTo().get(0);
                if (!theAssignment.getFrom().contains((Object)i) || !UMLUtils.elementIsProcessorInstance((Element)theAssignment.getTo().get(0)) || !theDeploymentElem.equals(chgaResPlat = toElem.getOwner())) continue;
                ++count;
            }
            catch (Exception exception) {}
        }
        return count;
    }

    public static int isAssigned2HowManyProcessingUnitsOrPartitions(InstanceSpecification i, Element theDeploymentElem, EList<Assign> assignments) {
        int count = 0;
        for (Assign theAssignment : assignments) {
            if (theAssignment == null) continue;
            try {
                Element chgaResPlat;
                Element toElem = (Element)theAssignment.getTo().get(0);
                if (!theAssignment.getFrom().contains((Object)i) || !UMLUtils.elementIsProcessorInstance(toElem) && !UMLUtils.elementIsPartitionInstance(toElem) || !(chgaResPlat = toElem.getOwner()).equals(theDeploymentElem)) continue;
                ++count;
            }
            catch (Exception exception) {}
        }
        return count;
    }

    public static int isAssigned2HowManyPartitions(InstanceSpecification i, EList<Assign> assignments) {
        int count = 0;
        for (Assign theAssignment : assignments) {
            if (theAssignment == null) continue;
            try {
                Element toElem = (Element)theAssignment.getTo().get(0);
                if (!theAssignment.getFrom().contains((Object)i) || !UMLUtils.elementIsProcessorInstance(toElem) && !UMLUtils.elementIsPartitionInstance(toElem)) continue;
                ++count;
            }
            catch (Exception exception) {}
        }
        return count;
    }

    public static EList<InstanceSpecification> getAllPartitionInstances(Model umlModel) throws ModelError {
        Package cmpv = CHESSProfileManager.getViewByStereotype(umlModel, "ComponentView");
        if (cmpv == null) {
            throw new ModelError("Component view not found.");
        }
        if ((cmpv = UMLUtils.getResourcePlatformPackage(cmpv)) == null) {
            throw new ModelError("CHGaResourcePlatform not found in Component View.");
        }
        EList all = cmpv.allOwnedElements();
        BasicEList partitions = new BasicEList();
        for (Element element : all) {
            InstanceSpecification is;
            if (!(element instanceof InstanceSpecification) || (is = (InstanceSpecification)element).getQualifiedName() == null || !UMLUtils.isPartitionInstance(is)) continue;
            partitions.add((Object)is);
        }
        if (partitions.size() == 0) {
            throw new ModelError("Partition Instances not found.");
        }
        return partitions;
    }

    public static Package getResourcePlatformPackage(Package cmpv) {
        LinkedList<Package> breadthFirstList = new LinkedList<Package>();
        breadthFirstList.addFirst(cmpv);
        while (!breadthFirstList.isEmpty()) {
            Package candidate = (Package)breadthFirstList.poll();
            CHGaResourcePlatform a = UMLUtils.getStereotypeApplication((Element)candidate, CHGaResourcePlatform.class);
            if (a != null) {
                return candidate;
            }
            for (Package p : candidate.getNestedPackages()) {
                breadthFirstList.addLast(p);
            }
        }
        return null;
    }

    public static EList<Package> getAllResourcePlatformPackage(Package cmpv) {
        BasicEList result = new BasicEList();
        LinkedList<Package> breadthFirstList = new LinkedList<Package>();
        breadthFirstList.addFirst(cmpv);
        while (!breadthFirstList.isEmpty()) {
            Package candidate = (Package)breadthFirstList.poll();
            CHGaResourcePlatform a = UMLUtils.getStereotypeApplication((Element)candidate, CHGaResourcePlatform.class);
            if (a != null) {
                result.add((Object)candidate);
            }
            for (Package p : candidate.getNestedPackages()) {
                breadthFirstList.addLast(p);
            }
        }
        return result;
    }

    public static boolean isPartitionInstance(InstanceSpecification e) {
        for (Classifier c : e.getClassifiers()) {
            if (UMLUtils.getStereotypeApplication((Element)c, FunctionalPartition.class) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean elementIsPartitionInstance(Element element) {
        if (!(element instanceof InstanceSpecification)) {
            return false;
        }
        InstanceSpecification is = (InstanceSpecification)element;
        return is.getQualifiedName() != null && UMLUtils.isPartitionInstance(is);
    }

    public static boolean isAssigned2Core(InstanceSpecification i, EList<Assign> assignments) {
        for (Assign theAssignment : assignments) {
            if (theAssignment == null) continue;
            try {
                if (!theAssignment.getFrom().contains((Object)i) || !UMLUtils.elementIsProcessorInstance((Element)theAssignment.getTo().get(0))) continue;
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static boolean hasComponentAssigned(InstanceSpecification i, EList<Assign> assignments) {
        for (Assign theAssignment : assignments) {
            if (theAssignment == null) continue;
            try {
                if (!theAssignment.getTo().contains((Object)i) || !UMLUtils.elementIsPartitionInstance((Element)theAssignment.getTo().get(0))) continue;
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static EList<Assign> getAssignments(Model umlModel, String viewName) throws ModelError {
        Package parent = CHESSProfileManager.getViewByStereotype(umlModel, viewName);
        EList all = parent.allOwnedElements();
        BasicEList assignments = new BasicEList();
        Stereotype stereo = null;
        for (Element element : all) {
            if (element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign") == null) continue;
            stereo = element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign");
            EObject eobj = element.getStereotypeApplication(stereo);
            Assign a = (Assign)eobj;
            assignments.add((Object)a);
        }
        return assignments;
    }

    public static boolean elementIsSlotInstance(Element element) {
        return element instanceof Slot;
    }

    public static boolean elementIsCHRtPortSlot(Element elem) {
        if (!UMLUtils.elementIsSlotInstance(elem)) {
            return false;
        }
        return elem.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtPortSlot") != null;
    }

    public static EList<InstanceSpecification> getAllComponentInstances(Model umlModel, boolean onlyTerminal) throws ModelError {
        Package cmpv = CHESSProfileManager.getViewByStereotype(umlModel, "ComponentView");
        if (cmpv == null) {
            throw new ModelError("Component view not found.");
        }
        if ((cmpv = UMLUtils.getResourcePlatformPackage(cmpv)) == null) {
            throw new ModelError("CHGaResourcePlatform not found in Component View.");
        }
        EList all = cmpv.allOwnedElements();
        BasicEList components = new BasicEList();
        for (Element element : all) {
            InstanceSpecification is;
            if (!(element instanceof InstanceSpecification) || (is = (InstanceSpecification)element).getQualifiedName() == null || !UMLUtils.isComponentInstance(is) || onlyTerminal && !UMLUtils.isLeafComponentInstance(is)) continue;
            components.add((Object)is);
        }
        if (components.size() == 0) {
            throw new ModelError("Component Instances not found.");
        }
        return components;
    }

    public static boolean isLeafComponentInstance(InstanceSpecification instSpec) {
        if (instSpec.getOwnedElements().size() > 0) {
            EList theOwnedElems = instSpec.getOwnedElements();
            for (Element theOwnedElem : theOwnedElems) {
                if (!(theOwnedElem instanceof Slot)) continue;
                Slot theSlot = (Slot)theOwnedElem;
                EList valSpecs = theSlot.getValues();
                for (ValueSpecification valSpec : valSpecs) {
                    if (!(valSpec instanceof InstanceValue)) continue;
                    InstanceSpecification theInstance = ((InstanceValue)valSpec).getInstance();
                    for (Classifier instClassifier : theInstance.getClassifiers()) {
                        Component instComp;
                        Stereotype compImplStereo;
                        if (!(instClassifier instanceof Component) || (compImplStereo = (instComp = (Component)instClassifier).getAppliedStereotype("CHESS::ComponentModel::ComponentImplementation")) == null) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static EList<Assign> getComponent2PartitionAssignments(Model umlModel, String viewName) throws ModelError {
        Package parent = CHESSProfileManager.getViewByStereotype(umlModel, viewName);
        EList all = parent.allOwnedElements();
        BasicEList assignments = new BasicEList();
        Stereotype stereo = null;
        for (Element element : all) {
            if (element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign") == null) continue;
            stereo = element.getAppliedStereotype("MARTE::MARTE_Foundations::Alloc::Assign");
            EObject eobj = element.getStereotypeApplication(stereo);
            Assign a = (Assign)eobj;
            try {
                InstanceSpecification componentInst;
                Element assignmentSource = (Element)a.getFrom().get(0);
                Element assignmentTarget = (Element)a.getTo().get(0);
                if (!UMLUtils.elementIsPartitionInstance(assignmentTarget) || !UMLUtils.elementIsComponentInstance(assignmentSource) || !UMLUtils.isComponentInstance(componentInst = (InstanceSpecification)assignmentSource)) continue;
                assignments.add((Object)a);
            }
            catch (Exception exception) {}
        }
        return assignments;
    }

    public static InstanceSpecification getRootInstanceInPackage(Package thePack) {
        EList allElems = thePack.allOwnedElements();
        String elementName = "";
        for (Element elem : allElems) {
            InstanceSpecification instSpec;
            if (!(elem instanceof InstanceSpecification) || (elementName = (instSpec = (InstanceSpecification)elem).getName()).contains(".")) continue;
            return instSpec;
        }
        return null;
    }

    public static String getValue(String s, String match) {
        String[] splits;
        if (s == null) {
            return "";
        }
        String found = null;
        String[] stringArray = splits = s.split(",");
        int n = splits.length;
        int n2 = 0;
        while (n2 < n) {
            String split = stringArray[n2];
            if (split.contains(match)) {
                String[] ssplits;
                String[] stringArray2 = ssplits = split.split("=");
                int n3 = ssplits.length;
                int n4 = 0;
                while (n4 < n3) {
                    String str = stringArray2[n4];
                    if (!str.contains(match)) {
                        found = str;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (found != null) {
            if ((found = found.trim()).startsWith("(")) {
                found = found.substring(1, found.length());
            }
            if (found.endsWith(")")) {
                found = found.substring(0, found.length() - 1);
            }
        }
        return found;
    }

    private static String getResponseTimeString(String rldlUnit, SaStep opSaStep) {
        double conv;
        String respT = "";
        String respUnit = "";
        String respValue = "";
        if (!opSaStep.getRespT().isEmpty()) {
            respT = (String)opSaStep.getRespT().get(0);
            respUnit = UMLUtils.getValue(respT, "unit");
            respValue = UMLUtils.getValue(respT, "worst");
        }
        if (respValue != null && !respValue.isEmpty() && rldlUnit.equals("ms")) {
            conv = Float.parseFloat(respValue) * 1000.0f;
            conv = (double)Math.round(conv * 100.0) / 100.0;
            respValue = Double.toString(conv);
            respUnit = "ms";
        }
        if (respValue != null && !respValue.isEmpty() && rldlUnit.equals("us")) {
            conv = Float.parseFloat(respValue) * 1000000.0f;
            conv = (double)Math.round(conv * 100.0) / 100.0;
            respValue = Double.toString(conv);
            respUnit = "us";
        }
        return String.valueOf(respValue) + respUnit;
    }

    public static String getBlockingTimeString(String rldlUnit, SaStep opSaStep) {
        double conv;
        String blockT = "";
        String blockUnit = "";
        String blockValue = "";
        blockT = opSaStep.getBlockT();
        blockUnit = UMLUtils.getValue(blockT, "unit");
        blockValue = UMLUtils.getValue(blockT, "worst");
        if (blockValue != null && !blockValue.isEmpty() && rldlUnit.equals("ms")) {
            conv = Float.parseFloat(blockValue) * 1000.0f;
            conv = (double)Math.round(conv * 100.0) / 100.0;
            blockValue = Double.toString(conv);
            blockUnit = "ms";
        }
        if (blockValue != null && !blockValue.isEmpty() && rldlUnit.equals("us")) {
            conv = Float.parseFloat(blockValue) * 1000000.0f;
            conv = (double)Math.round(conv * 100.0) / 100.0;
            blockValue = Double.toString(conv);
            blockUnit = "us";
        }
        return String.valueOf(blockValue) + blockUnit;
    }

    public static List<AnalysisResultData> getAnalysisResults(Class contextClass) {
        ArrayList<AnalysisResultData> listData = new ArrayList<AnalysisResultData>();
        Model model = contextClass.getModel();
        Package psm = ViewUtils.getCHESSPSMPackage(model);
        if (contextClass.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext") == null) {
            return listData;
        }
        String saAnalysisName = contextClass.getQualifiedName();
        SaEndtoEndFlow saEndtoEndFlow = null;
        SaStep saStep = null;
        for (Package pkg : psm.getNestedPackages()) {
            PSMPackage psmPkg;
            Stereotype stereo = pkg.getAppliedStereotype("CHESS::Core::PSMPackage");
            if (stereo == null || !(psmPkg = (PSMPackage)pkg.getStereotypeApplication(stereo)).getAnalysisContext().getBase_NamedElement().getQualifiedName().equals(saAnalysisName)) continue;
            Package psmPackage = pkg;
            Slot slot = null;
            InstanceSpecification componentInstance = null;
            Comment chrtComm = null;
            Package psmAnalysisContextPack = (Package)psmPackage.getOwnedMember("AnalysisContext");
            Class psmAnalysisContextClass = null;
            for (Element elem : psmAnalysisContextPack.getOwnedElements()) {
                if (!(elem instanceof Class)) continue;
                psmAnalysisContextClass = (Class)elem;
                SaAnalysisContext cfr_ignored_0 = (SaAnalysisContext)psmAnalysisContextClass.getStereotypeApplication(psmAnalysisContextClass.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext"));
            }
            block2: for (Element elem : psmAnalysisContextClass.allOwnedElements()) {
                if (!(elem instanceof Activity)) continue;
                Activity activity = (Activity)elem;
                if (elem.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaEndtoEndFlow") == null) continue;
                SaAnalysisContext cfr_ignored_1 = (SaAnalysisContext)psmAnalysisContextClass.getStereotypeApplication(psmAnalysisContextClass.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext"));
                saEndtoEndFlow = (SaEndtoEndFlow)elem.getStereotypeApplication(elem.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaEndtoEndFlow"));
                for (ActivityNode node : activity.getNodes()) {
                    EList schedParams;
                    InstanceSpecification inst;
                    if (node.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaStep") == null) continue;
                    saStep = (SaStep)node.getStereotypeApplication(node.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaStep"));
                    for (Constraint constr : psmAnalysisContextClass.getOwnedRules()) {
                        if (!constr.getConstrainedElements().contains((Object)activity)) continue;
                        for (Element constrained : constr.getConstrainedElements()) {
                            if (constrained instanceof Slot) {
                                slot = (Slot)constrained;
                            }
                            if (constrained instanceof Comment) {
                                chrtComm = (Comment)constrained;
                            }
                            if (!(constrained instanceof InstanceSpecification)) continue;
                            componentInstance = (InstanceSpecification)constrained;
                        }
                    }
                    if (chrtComm == null || slot == null && componentInstance == null) continue block2;
                    CHRtSpecification chrt = (CHRtSpecification)chrtComm.getStereotypeApplication(chrtComm.getApplicableStereotype("CHESS::Predictability::RTComponentModel::CHRtSpecification"));
                    AnalysisResultData resultData = new AnalysisResultData();
                    resultData.instSpec = inst = slot != null ? slot.getOwningInstance() : componentInstance;
                    resultData.ctxOP = (Operation)chrt.getContext();
                    resultData.instance = inst.getName();
                    resultData.context = chrt.getContext().getName();
                    ActivityNode initial = activity.getNode("InitialNode1");
                    Stereotype initialStereo = initial.getAppliedStereotype("MARTE::MARTE_AnalysisModel::GQAM::GaWorkloadEvent");
                    GaWorkloadEvent workload = (GaWorkloadEvent)initial.getStereotypeApplication(initialStereo);
                    resultData.arrival = workload.getPattern();
                    String rldlValue = "";
                    String rldlUnit = "";
                    if (saEndtoEndFlow.getEnd2EndD() != null && !saEndtoEndFlow.getEnd2EndD().isEmpty()) {
                        resultData.rldl = (String)saEndtoEndFlow.getEnd2EndD().get(0);
                        if (resultData.rldl != null) {
                            rldlValue = UMLUtils.getValue(resultData.rldl, "value");
                            rldlUnit = UMLUtils.getValue(resultData.rldl, "unit");
                            resultData.rldl = String.valueOf(rldlValue) + rldlUnit;
                        }
                    }
                    if (saStep.getConcurRes() != null && (schedParams = saStep.getConcurRes().getSchedParams()) != null && !schedParams.isEmpty()) {
                        String schedParam;
                        resultData.priority = schedParam = (String)schedParams.get(0);
                    }
                    if (saStep.getSubUsage() != null && !saStep.getSubUsage().isEmpty()) {
                        Operation operation = (Operation)((ResourceUsage)saStep.getSubUsage().get(0)).getBase_NamedElement();
                        SaStep opSaStep = (SaStep)operation.getStereotypeApplication(operation.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaStep"));
                        if (opSaStep.getExecTime() != null && !opSaStep.getExecTime().isEmpty()) {
                            resultData.localWCET = (String)opSaStep.getExecTime().get(0);
                        }
                        resultData.respT = UMLUtils.getResponseTimeString(rldlUnit, opSaStep);
                        resultData.blockT = UMLUtils.getBlockingTimeString(rldlUnit, opSaStep);
                    }
                    if (resultData.respT.isEmpty()) {
                        Stereotype latencyObs = null;
                        GaLatencyObs obs = null;
                        for (Constraint constr : activity.getOwnedRules()) {
                            String s;
                            latencyObs = constr.getAppliedStereotype("MARTE::MARTE_AnalysisModel::GQAM::GaLatencyObs");
                            if (latencyObs == null) continue;
                            obs = (GaLatencyObs)constr.getStereotypeApplication(latencyObs);
                            resultData.respT = s = (String)obs.getLatency().get(0);
                        }
                        if (saStep.getExecTime() != null && !saStep.getExecTime().isEmpty()) {
                            resultData.localWCET = (String)saStep.getExecTime().get(0);
                        }
                        if (saStep.getBlockT() != null && !saStep.getBlockT().isEmpty()) {
                            resultData.blockT = saStep.getBlockT();
                        }
                    }
                    String respT = "";
                    String respValue = "";
                    String respUnit = "";
                    if (saEndtoEndFlow.getEnd2EndT().size() > 0) {
                        respT = (String)saEndtoEndFlow.getEnd2EndT().get(0);
                        respValue = UMLUtils.getValue(respT, "worst");
                    }
                    if (respValue != null && !respValue.isEmpty() && rldlUnit.equals("ms")) {
                        double conv = Float.parseFloat(respValue) * 1000.0f;
                        conv = (double)Math.round(conv * 100.0) / 100.0;
                        respValue = Double.toString(conv);
                        respUnit = "ms";
                    }
                    if (respValue != null && !respValue.isEmpty() && rldlUnit.equals("us")) {
                        double conv = Float.parseFloat(respValue) * 1000000.0f;
                        conv = (double)Math.round(conv * 100.0) / 100.0;
                        respValue = Double.toString(conv);
                        respUnit = "us";
                    }
                    String cfr_ignored_2 = String.valueOf(respValue) + respUnit;
                    if (!respValue.isEmpty() && !rldlValue.isEmpty()) {
                        resultData.isSched = Float.parseFloat(respValue) <= Float.parseFloat(rldlValue) ? "YES" : "NO";
                    }
                    listData.add(resultData);
                }
            }
        }
        return listData;
    }

    public static List<HWAnalysisResultData> getHWAnalysisResults(Class contextClass) {
        ArrayList<HWAnalysisResultData> listData = new ArrayList<HWAnalysisResultData>();
        Model model = contextClass.getModel();
        Package psm = ViewUtils.getCHESSPSMPackage(model);
        if (contextClass.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext") == null) {
            return listData;
        }
        String saAnalysisName = contextClass.getQualifiedName();
        SaExecHost host = null;
        for (Package pkg : psm.getNestedPackages()) {
            Stereotype stereo = pkg.getAppliedStereotype("CHESS::Core::PSMPackage");
            if (stereo == null) continue;
            PSMPackage psmPkg = (PSMPackage)pkg.getStereotypeApplication(stereo);
            System.out.println("Pkg QN=" + psmPkg.getAnalysisContext().getBase_NamedElement().getQualifiedName());
            if (!psmPkg.getAnalysisContext().getBase_NamedElement().getQualifiedName().equals(saAnalysisName)) continue;
            Package psmPackage = pkg;
            Package psmHostPack = (Package)psmPackage.getOwnedMember("Host");
            for (Element elem : psmHostPack.getOwnedElements()) {
                if (elem.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaExecHost") == null) continue;
                host = (SaExecHost)elem.getStereotypeApplication(elem.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaExecHost"));
                HWAnalysisResultData data = new HWAnalysisResultData();
                data.hw_instance = ((Class)elem).getName();
                if (host.getUtilization().size() > 0) {
                    data.hw_utilization = (String)host.getUtilization().get(0);
                }
                listData.add(data);
            }
        }
        return listData;
    }

    public static List<EndToEndResultData> getEndtoEndAnalysisResults(Class contextClass) {
        ArrayList<EndToEndResultData> listData = new ArrayList<EndToEndResultData>();
        Model model = contextClass.getModel();
        Package psm = ViewUtils.getCHESSPSMPackage(model);
        if (contextClass.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext") == null) {
            return listData;
        }
        String saAnalysisName = contextClass.getQualifiedName();
        for (Package pkg : psm.getNestedPackages()) {
            PSMPackage psmPkg;
            Stereotype stereo = pkg.getAppliedStereotype("CHESS::Core::PSMPackage");
            if (stereo == null || !(psmPkg = (PSMPackage)pkg.getStereotypeApplication(stereo)).getAnalysisContext().getBase_NamedElement().getQualifiedName().equals(saAnalysisName)) continue;
            Package psmPackage = pkg;
            Package psmAnalysisContextPack = (Package)psmPackage.getOwnedMember("AnalysisContext");
            Class psmAnalysisContextClass = null;
            for (Element temp : psmAnalysisContextPack.getOwnedElements()) {
                if (!(temp instanceof Class)) continue;
                psmAnalysisContextClass = (Class)temp;
                for (Element elem : psmAnalysisContextClass.allOwnedElements()) {
                    if (!(elem instanceof Activity)) continue;
                    Activity activity = (Activity)elem;
                    if (elem.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaEndtoEndFlow") == null) continue;
                    SaEndtoEndFlow pimEndtoEndFlow = null;
                    for (Constraint constr : psmAnalysisContextClass.getOwnedRules()) {
                        if (!constr.getConstrainedElements().contains((Object)activity)) continue;
                        for (Element constrained : constr.getConstrainedElements()) {
                            if (!(constrained instanceof Activity) || constrained == activity || constrained.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaEndtoEndFlow") == null || constrained.getAppliedStereotype("MARTE::MARTE_AnalysisModel::GQAM::GaWorkloadBehavior") == null) continue;
                            pimEndtoEndFlow = (SaEndtoEndFlow)constrained.getStereotypeApplication(constrained.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaEndtoEndFlow"));
                            break;
                        }
                        if (pimEndtoEndFlow != null) break;
                    }
                    if (pimEndtoEndFlow == null) continue;
                    SaEndtoEndFlow psmEndtoEndFlow = (SaEndtoEndFlow)activity.getStereotypeApplication(activity.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaEndtoEndFlow"));
                    EndToEndResultData data = new EndToEndResultData();
                    data.scenarioName = activity.getName();
                    if (pimEndtoEndFlow.getEnd2EndD().size() > 0) {
                        data.deadline = (String)pimEndtoEndFlow.getEnd2EndD().get(0);
                    }
                    if (psmEndtoEndFlow.getEnd2EndT().size() > 0) {
                        data.respTime = (String)psmEndtoEndFlow.getEnd2EndT().get(0);
                    }
                    listData.add(data);
                }
            }
        }
        return listData;
    }

    public static EObject getSelectedElement() {
        EObject eObject = null;
        Object selection = null;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            selection = activeWorkbenchWindow.getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                selection = structuredSelection.getFirstElement();
            }
            if (selection != null) {
                Object businessObject;
                if (selection instanceof IAdaptable) {
                    selection = EMFHelper.getEObject((Object)selection);
                }
                if ((businessObject = BusinessModelResolver.getInstance().getBusinessModel(selection)) instanceof EObject) {
                    eObject = (EObject)businessObject;
                }
            }
        }
        return eObject;
    }

    public static EList<EObject> getTwoSelectedElements() {
        EObject eObject1 = null;
        EObject eObject2 = null;
        ISelection selection = null;
        Object selection1 = null;
        Object selection2 = null;
        BasicEList result = new BasicEList();
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            selection = activeWorkbenchWindow.getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (structuredSelection.size() != 2) {
                    return result;
                }
                Iterator iterator = structuredSelection.iterator();
                if (iterator.hasNext()) {
                    selection1 = iterator.next();
                }
                if (iterator.hasNext()) {
                    selection2 = iterator.next();
                }
            }
            if (selection1 != null) {
                Object businessObject1;
                if (selection1 instanceof IAdaptable) {
                    selection1 = EMFHelper.getEObject(selection1);
                }
                if ((businessObject1 = BusinessModelResolver.getInstance().getBusinessModel(selection1)) instanceof EObject) {
                    eObject1 = (EObject)businessObject1;
                }
            }
            result.add(eObject1);
            if (selection2 != null) {
                Object businessObject2;
                if (selection2 instanceof IAdaptable) {
                    selection2 = EMFHelper.getEObject(selection2);
                }
                if ((businessObject2 = BusinessModelResolver.getInstance().getBusinessModel(selection2)) instanceof EObject) {
                    eObject2 = (EObject)businessObject2;
                }
            }
            result.add(eObject2);
        }
        return result;
    }

    public static List<ValueNFP> getAllNfpValues(String str, String toSearch) {
        ArrayList<ValueNFP> result = new ArrayList<ValueNFP>();
        String[] array = str.split("[()=, ]");
        int i = 0;
        while (i < array.length - 1) {
            if (array[i].equalsIgnoreCase(toSearch)) {
                int j = i + 1;
                block1: while (j < array.length) {
                    if (array[j].equalsIgnoreCase("value")) {
                        String d = array[j + 1];
                        ValueNFP res = new ValueNFP();
                        res.value = Double.valueOf(d.trim());
                        int k = j + 1;
                        while (k < array.length) {
                            if (array[k].equalsIgnoreCase("unit")) {
                                res.unit = array[k + 1].trim();
                                result.add(res);
                                break block1;
                            }
                            ++k;
                        }
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public static ValueNFP getNfpValue(String str, String toSearch) {
        ValueNFP res = new ValueNFP();
        String[] array = str.split("[()=, ]");
        int i = 0;
        while (i < array.length - 1) {
            int j = i + 1;
            while (j < array.length) {
                if (array[i].equalsIgnoreCase(toSearch) && array[j].equalsIgnoreCase("value")) {
                    String d = array[j + 1];
                    res.value = Double.valueOf(d.trim());
                    int k = i + 1;
                    while (k < array.length) {
                        if (array[k].equalsIgnoreCase("unit")) {
                            res.unit = array[k + 1].trim();
                            break;
                        }
                        ++k;
                    }
                    return res;
                }
                ++j;
            }
            ++i;
        }
        res.value = -1.0;
        res.unit = "";
        return res;
    }

    public static String setNfpValue(String str, String toSearch, Double value, String units) {
        String res = new String();
        String toBeAdded = String.valueOf(toSearch) + "=(value=" + value.toString() + ", unit=" + units + ")";
        if (str == null || str.isEmpty() || str.trim().matches("\\(( *)\\)")) {
            res = "(" + toBeAdded + ")";
            return res;
        }
        if (str.contains(toSearch)) {
            res = str.replaceFirst(String.valueOf(toSearch) + "( *)=( *)\\((.[^\\)]*)\\)", toBeAdded);
        } else {
            int index = str.lastIndexOf(41);
            res = String.valueOf(str.substring(0, index)) + ", " + toBeAdded + str.substring(index);
        }
        return res;
    }

    public static ValueNFP getValueNFP(String value) {
        ValueNFP res = new ValueNFP();
        res.value = -1.0;
        res.unit = "";
        String[] array = value.split("[()=,]");
        int i = 0;
        while (i < array.length - 1) {
            if (array[i].trim().equalsIgnoreCase("value")) {
                String d = array[i + 1].trim();
                res.value = Double.valueOf(d);
            }
            ++i;
        }
        i = 0;
        while (i < array.length - 1) {
            if (array[i].trim().equalsIgnoreCase("unit")) {
                res.unit = array[i + 1].trim();
            }
            ++i;
        }
        return res;
    }

    public static Double toSeconds(Double value, String units) {
        Double res = value;
        if (units == null || units.trim().equalsIgnoreCase("s")) {
            res = res * 1.0;
        } else if (units.trim().equalsIgnoreCase("ms")) {
            res = res * 0.001;
        } else if (units.trim().equalsIgnoreCase("us")) {
            res = res * 1.0E-6;
        } else if (units.trim().equalsIgnoreCase("ns")) {
            res = res * 1.0E-9;
        } else if (units.trim().equalsIgnoreCase("min")) {
            res = res * 60.0;
        } else if (units.trim().equalsIgnoreCase("hrs")) {
            res = res * 360.0;
        } else if (units.trim().equalsIgnoreCase("dys")) {
            res = res * 8640.0;
        }
        return res;
    }

    public static CHRtSpecification getArincProcessSpecification(InstanceSpecification instSpec, CHRtSpecification arincFunctionSpec) throws ModelError {
        String theArincFunctName = "";
        BehavioralFeature behavFeatFromArincFunctSpec = arincFunctionSpec.getContext();
        if (behavFeatFromArincFunctSpec.getAppliedStereotype("CHESS::Predictability::ARINCComponentModel::ARINCFunction") == null) {
            throw new ModelError("Error: the input arincFunctionSpec has a context that is not an ARINCFunction");
        }
        Stereotype arincFunctionStereo = behavFeatFromArincFunctSpec.getAppliedStereotype("CHESS::Predictability::ARINCComponentModel::ARINCFunction");
        ARINCFunction arincFunction = (ARINCFunction)behavFeatFromArincFunctSpec.getStereotypeApplication(arincFunctionStereo);
        theArincFunctName = arincFunction.getBase_Operation().getName();
        EList slotList = instSpec.getSlots();
        for (Slot slot : slotList) {
            if (slot.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtPortSlot") == null) continue;
            Stereotype chrtPortSlotStereo = slot.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtPortSlot");
            CHRtPortSlot chrtPortSlot = (CHRtPortSlot)slot.getStereotypeApplication(chrtPortSlotStereo);
            EList chrtspecs = chrtPortSlot.getCH_RtSpecification();
            for (CHRtSpecification chrtspec : chrtspecs) {
                Stereotype arincProcessStereo;
                ARINCProcess arincProcess;
                String opGroupsString;
                BehavioralFeature behavFeat = chrtspec.getContext();
                if (behavFeat.getAppliedStereotype("CHESS::Predictability::ARINCComponentModel::ARINCProcess") == null || (opGroupsString = (arincProcess = (ARINCProcess)behavFeat.getStereotypeApplication(arincProcessStereo = behavFeat.getAppliedStereotype("CHESS::Predictability::ARINCComponentModel::ARINCProcess"))).getOperationsGroups()) == null || !opGroupsString.contains(theArincFunctName)) continue;
                return chrtspec;
            }
        }
        return null;
    }

    public static CHRtSpecification getUpdatedArincFunChrtSpec(InstanceSpecification instance, CHRtSpecification arincFunctChrtspec) throws ModelError {
        CHRtSpecification arincProcessChrtspec = UMLUtils.getArincProcessSpecification(instance, arincFunctChrtspec);
        if (arincProcessChrtspec == null) {
            CHESSProjectSupport.printlnToCHESSConsole("ERROR: Unable to retrieve the ARICProcess from the ARINCFunction " + arincFunctChrtspec);
            return null;
        }
        CHRtSpecification chrtspec = arincFunctChrtspec;
        String occurrencyKindArincProc = arincProcessChrtspec.getOccKind();
        String occurrencyKindArincFunct = arincFunctChrtspec.getOccKind();
        if (occurrencyKindArincFunct.contains("periodic") || occurrencyKindArincFunct.contains("sporadic")) {
            occurrencyKindArincFunct = "(" + occurrencyKindArincFunct.substring(occurrencyKindArincFunct.indexOf("phase"));
        }
        if (!occurrencyKindArincProc.matches("\\s*periodic\\s*(\\(\\s*period\\s*=\\s*\\(\\s*value\\s*=\\s*(\\w*\\.?\\w*)\\s*,\\s*unit\\s*=\\s*(\\w*\\.?\\w*)\\s*\\)\\s*\\))")) {
            throw new ModelError("Unexpected Occurrency Kind for ARINCProcess: " + occurrencyKindArincProc);
        }
        String newOccurrencyKind = occurrencyKindArincProc.substring(0, occurrencyKindArincProc.lastIndexOf(")"));
        newOccurrencyKind = String.valueOf(newOccurrencyKind) + "," + occurrencyKindArincFunct.substring(1);
        int ratediv = 1;
        BehavioralFeature behavFeat = arincFunctChrtspec.getContext();
        if (behavFeat.getAppliedStereotype("CHESS::Predictability::ARINCComponentModel::ARINCFunction") == null) {
            throw new ModelError("ARINCProcess not found for " + behavFeat);
        }
        Stereotype arincFunctionStereo = behavFeat.getAppliedStereotype("CHESS::Predictability::ARINCComponentModel::ARINCFunction");
        ARINCFunction arincFunction = (ARINCFunction)behavFeat.getStereotypeApplication(arincFunctionStereo);
        ratediv = arincFunction.getRateDivider();
        ValueNFP nfp = UMLUtils.getNfpValue(occurrencyKindArincProc, "period");
        newOccurrencyKind = UMLUtils.setNfpValue(newOccurrencyKind, "period", nfp.value * (double)ratediv, nfp.unit);
        chrtspec.setOccKind(newOccurrencyKind);
        return chrtspec;
    }

    public static EList<CHRtSpecification> getAllChrtSpecs(Model umlModel, String viewName) throws ModelError {
        Package parent = CHESSProfileManager.getViewByStereotype(umlModel, viewName);
        EList all = parent.allOwnedElements();
        BasicEList chrtSpecs = new BasicEList();
        Stereotype stereo = null;
        for (Element element : all) {
            if (element.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtSpecification") == null) continue;
            stereo = element.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtSpecification");
            EObject eobj = element.getStereotypeApplication(stereo);
            CHRtSpecification chrtSpecification = (CHRtSpecification)eobj;
            chrtSpecs.add((Object)chrtSpecification);
        }
        return chrtSpecs;
    }

    public static boolean checkPlatformsInContext(SaAnalysisContext saAnalysisContext, Model umlModel) {
        boolean result = false;
        EList thePlatforms = saAnalysisContext.getPlatform();
        int count = 0;
        int countInDeploymentView = 0;
        int countInComponentView = 0;
        for (GaResourcesPlatform thePlatform : thePlatforms) {
            if (thePlatform instanceof CHGaResourcePlatform) {
                ++count;
            }
            Package instancePkg = ((CHGaResourcePlatform)thePlatform).getBase_Package();
            EList owningPkgs = instancePkg.allOwningPackages();
            for (Package pack : owningPkgs) {
                if (pack.equals(CHESSProfileManager.getViewByStereotype(umlModel, "DeploymentView"))) {
                    ++countInDeploymentView;
                    continue;
                }
                if (!pack.equals(CHESSProfileManager.getViewByStereotype(umlModel, "ComponentView"))) continue;
                ++countInComponentView;
            }
        }
        if (count == 2 && countInDeploymentView == 1 && countInComponentView == 1) {
            result = true;
        }
        return result;
    }

    public static boolean checkAllocationToCores(List<CH_HwProcessor> chHwProcList, Model umlModel) throws ModelError {
        boolean result = false;
        for (CH_HwProcessor chHwProc : chHwProcList) {
            EList<Assign> all2CoresAssignments = UMLUtils.getAll2CoreAssignments(umlModel, "DeploymentView");
            for (Assign assignment : all2CoresAssignments) {
                EList destinations = assignment.getTo();
                for (Element assignmentTarget : destinations) {
                    Stereotype chHwProcStereo;
                    CH_HwProcessor theAssignmentChHwProc;
                    if (!UMLUtils.elementIsProcessorInstance(assignmentTarget) || !chHwProc.equals(theAssignmentChHwProc = (CH_HwProcessor)assignmentTarget.getStereotypeApplication(chHwProcStereo = assignmentTarget.getAppliedStereotype("CHESS::Predictability::DeploymentConfiguration::HardwareBaseline::CH_HwProcessor")))) continue;
                    return true;
                }
            }
        }
        return result;
    }
}

