/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.internal.views.permissions;

import org.polarsys.chess.chessmlprofile.Core.Domain;
import org.polarsys.chess.core.internal.views.permissions.EntryId;

public class PermissionEntry {
    public static final byte WRITABLE = 0;
    public static final byte OWNER = 1;
    public static final byte VISIBLE = 2;
    public static final byte DOMAIN = 3;
    public static String OWNER_ATR = "owner";
    public static String VISIBLE_ATR = "visible";
    public static String WRITE_ATR = "write";
    public static String DOMAIN_ATR = "domain";
    private EntryId id;
    private boolean owner;
    private boolean visible;
    private boolean write;
    private Domain domain;

    public EntryId getId() {
        return this.id;
    }

    public boolean checkPermission(byte permission) {
        if (permission == 1) {
            return this.owner;
        }
        if (permission == 0) {
            return this.write;
        }
        if (permission == 2) {
            return this.visible;
        }
        return false;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public boolean isOwner() {
        return this.owner;
    }

    public boolean isWriteable() {
        return this.write;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public PermissionEntry(EntryId id, boolean owner, boolean write, boolean visible, Domain domain) {
        this.id = id;
        this.owner = owner;
        this.write = write;
        this.visible = visible;
        this.domain = domain;
    }

    public PermissionEntry match(EntryId id) {
        if (this.id.match(id)) {
            return this;
        }
        return null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(30);
        s.append(this.id.toString());
        s.append('|');
        s.append(this.owner ? (char)'o' : '-');
        s.append(this.write ? "rw" : "r-");
        s.append(this.visible ? (char)'v' : '-');
        return s.toString();
    }

    public static String getPermissionType(byte permission) {
        switch (permission) {
            case 1: {
                return "OWNER";
            }
            case 2: {
                return "VISIBLE";
            }
            case 0: {
                return "WRITE";
            }
            case 3: {
                return "DOMAIN";
            }
        }
        return "";
    }
}

