/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.assurproj.assuranceproject.etl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.opencert.apm.assurproj.assuranceproject.etl.EpfTransformParameters;
import org.eclipse.opencert.apm.assurproj.assuranceproject.etl.EpfTransformation;
import org.eclipse.opencert.apm.assurproj.assuranceproject.etl.RedirectSystemErr;
import org.eclipse.opencert.apm.assurproj.assuranceproject.provider.AssuranceprojectEditPlugin;
import org.eclipse.opencert.evm.evidspec.evidence.ArtefactModel;
import org.eclipse.opencert.evm.evidspec.evidence.EvidenceFactory;
import org.eclipse.opencert.evm.evidspec.evidence.EvidencePackage;
import org.eclipse.opencert.evm.evidspec.evidence.impl.ArtefactModelImpl;
import org.eclipse.opencert.pam.procspec.process.ProcessFactory;
import org.eclipse.opencert.pam.procspec.process.ProcessModel;
import org.eclipse.opencert.pam.procspec.process.ProcessPackage;
import org.eclipse.opencert.pam.procspec.process.impl.ProcessModelImpl;

public class CDOTransformHandler {
    private static final String UTF_8 = "UTF-8";
    private static String etlFile = "epsilon/epf2assetspackage.etl";
    private static String eviModelURI = "eviModel.evidence";
    private static String procModelURI = "procModel.process";
    private static String epfMetamodelFileURI = "model/EPFSchema.xsd";
    private static String eviMetamodelFileURI = "model/evidence.ecore";
    private static String procMetamodelFileURI = "model/process.ecore";
    private static String pluginInWorkSpace = "";
    private static String pluginPath = "";
    private static String epfMetamodelFile = "";
    private static String eviMetamodelFile = "";
    private static String procMetamodelFile = "";
    private CDOResource eviModel;
    private CDOResource processModel;
    private CDOResourceFolder project;
    private EMFPlugin pluginProject;
    private CDOTransaction transaction;
    String methodFilePath = "";
    String configurationFilePath = "";
    private String eviModelFile;
    private String procModelFile;
    private Resource eviModelResource = null;
    private Resource procModelResource = null;

    public CDOTransformHandler(CDOResourceFolder project, String methodFilePath, String configurationFilePath, CDOResource evidenceModel, CDOResource processModel, CDOTransaction transaction) {
        try {
            this.project = project;
            this.pluginProject = AssuranceprojectEditPlugin.INSTANCE;
            this.configurationFilePath = configurationFilePath;
            this.methodFilePath = methodFilePath;
            this.eviModel = evidenceModel;
            this.processModel = processModel;
            this.transaction = transaction;
            URL entry = null;
            URL fileURL = null;
            String file = "";
            try {
                String sname;
                String spluginPath = AssuranceprojectEditPlugin.getPlugin().getBundle().getLocation();
                RedirectSystemErr.out("spluginPath:= ." + spluginPath + ".");
                if (spluginPath.contains("plugins")) {
                    entry = AssuranceprojectEditPlugin.getPlugin().getBundle().getEntry(eviMetamodelFileURI);
                    fileURL = FileLocator.resolve((URL)entry);
                    file = fileURL.getFile();
                    RedirectSystemErr.out("file:= ." + file + ".");
                    pluginPath = String.valueOf(file.substring("file:/".length(), file.indexOf("plugins"))) + "configuration";
                    RedirectSystemErr.out("pluginPath:= ." + pluginPath + ".");
                    sname = AssuranceprojectEditPlugin.getPlugin().getBundle().getSymbolicName();
                    RedirectSystemErr.out("sname:= ." + sname + ".");
                    pluginInWorkSpace = "";
                } else {
                    pluginPath = spluginPath.substring("reference:file:/".length(), spluginPath.length() - 1);
                    RedirectSystemErr.out("pluginPath:= ." + pluginPath + ".");
                    sname = AssuranceprojectEditPlugin.getPlugin().getBundle().getSymbolicName();
                    int index0 = pluginPath.lastIndexOf("/", pluginPath.length() - (sname.length() + 2));
                    pluginInWorkSpace = pluginPath.substring(index0 + 1, pluginPath.lastIndexOf("/"));
                }
                RedirectSystemErr.out("pluginInWorkSpace:= ." + pluginInWorkSpace + ".");
                epfMetamodelFile = String.valueOf(pluginPath) + "/" + epfMetamodelFileURI;
                eviMetamodelFile = String.valueOf(pluginPath) + "/" + eviMetamodelFileURI;
                procMetamodelFile = String.valueOf(pluginPath) + "/" + procMetamodelFileURI;
                String modelsPath = System.getProperty("user.home");
                RedirectSystemErr.out("modelsPath:= ." + modelsPath + ".");
                this.eviModelFile = String.valueOf(modelsPath) + '/' + eviModelURI;
                this.procModelFile = String.valueOf(modelsPath) + '/' + procModelURI;
                URI eviModelLocalURI = URI.createFileURI((String)this.eviModelFile);
                URI procModelLocalURI = URI.createFileURI((String)this.procModelFile);
                this.eviModelResource = this.createEviModel(eviModelLocalURI, null);
                this.procModelResource = this.createProcModel(procModelLocalURI, null);
            }
            catch (IOException e) {
                e.printStackTrace();
                RedirectSystemErr.out("CDOTransformHandler Exception 1 ." + e.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            RedirectSystemErr.out("CDOTransformHandler Exception 3 ." + e.toString());
        }
    }

    private void attachModelToResource(EObject model, Resource resource) {
        resource.getContents().add((Object)model);
    }

    private void setCharset(IFile file) {
        if (file == null) {
            return;
        }
        try {
            file.setCharset(UTF_8, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private ArtefactModel createEviInitialModel() {
        return EvidenceFactory.eINSTANCE.createArtefactModel();
    }

    private Resource createEviModel(URI modelURI, final CDOResource modelCDO) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        final Resource modelResource = editingDomain.getResourceSet().createResource(modelURI);
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Create Evidence Model File", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                ArtefactModelImpl model = (ArtefactModelImpl)CDOTransformHandler.this.createEviInitialModel();
                if (modelCDO != null) {
                    model = (ArtefactModelImpl)modelCDO.getContents().get(0);
                }
                CDOTransformHandler.this.attachModelToResource((EObject)model, modelResource);
                try {
                    modelResource.save(null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        this.setCharset(WorkspaceSynchronizer.getFile((Resource)modelResource));
        return modelResource;
    }

    private ProcessModel createProcInitialModel() {
        return ProcessFactory.eINSTANCE.createProcessModel();
    }

    private Resource createProcModel(URI modelURI, final CDOResource modelCDO) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        final Resource modelResource = editingDomain.getResourceSet().createResource(modelURI);
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Create Process Model File", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                ProcessModelImpl model = (ProcessModelImpl)CDOTransformHandler.this.createProcInitialModel();
                if (modelCDO != null) {
                    model = (ProcessModelImpl)modelCDO.getContents().get(0);
                }
                CDOTransformHandler.this.attachModelToResource((EObject)model, modelResource);
                try {
                    modelResource.save(null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        this.setCharset(WorkspaceSynchronizer.getFile((Resource)modelResource));
        return modelResource;
    }

    public Object execute() throws ExecutionException, IOException {
        Object res = null;
        EpfTransformParameters parameters = this.createTransformParameters(new EpfTransformParameters());
        EpfTransformation service = new EpfTransformation();
        service.createJob(parameters);
        try {
            RedirectSystemErr.out(" before service.execute() ");
            service.execute();
            res = service.getResult();
            RedirectSystemErr.out(" res :=." + res + ".");
            RedirectSystemErr.out(" before refreshing file content ");
            if (this.eviModelResource.isLoaded()) {
                this.eviModelResource.unload();
                try {
                    this.eviModelResource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
            if (this.procModelResource.isLoaded()) {
                this.procModelResource.unload();
                try {
                    this.procModelResource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
            RedirectSystemErr.out(" before creating CDO Evidence and Process models. ");
            URI eviXmiUri = URI.createFileURI((String)this.eviModelFile);
            URI eviCdoURI = this.eviModel.getURI();
            URI procXmiUri = URI.createFileURI((String)this.procModelFile);
            URI procCdoURI = this.processModel.getURI();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
            Resource eviXmiResource = resourceSet.createResource(eviXmiUri);
            Resource procXmiResource = resourceSet.createResource(procXmiUri);
            FileInputStream eviFileInStream = new FileInputStream(eviXmiUri.path());
            eviXmiResource.load((InputStream)eviFileInStream, Collections.EMPTY_MAP);
            FileInputStream procFileInStream = new FileInputStream(procXmiUri.path());
            procXmiResource.load((InputStream)procFileInStream, Collections.EMPTY_MAP);
            eviXmiResource.setURI(eviXmiUri);
            procXmiResource.setURI(procXmiUri);
            EMFUtil.safeResolveAll((ResourceSet)resourceSet);
            CDOResource eviCdoResource = this.transaction.getOrCreateResource(eviCdoURI.path());
            eviCdoResource.getContents().addAll((Collection)eviXmiResource.getContents());
            CDOResource procCdoResource = this.transaction.getOrCreateResource(procCdoURI.path());
            procCdoResource.getContents().addAll((Collection)procXmiResource.getContents());
            EMFUtil.safeResolveAll((ResourceSet)resourceSet);
            eviCdoResource.save(Collections.EMPTY_MAP);
            procCdoResource.save(Collections.EMPTY_MAP);
            this.transaction.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RedirectSystemErr.end();
        return res;
    }

    public EpfTransformParameters createTransformParameters(EpfTransformParameters epfTransformParameters) {
        epfTransformParameters.setEtlTransform(etlFile);
        epfTransformParameters.setEPFMetaModelFilePath(epfMetamodelFile);
        epfTransformParameters.setConfModelFilePath(this.configurationFilePath);
        epfTransformParameters.setLibModelFilePath(this.methodFilePath);
        epfTransformParameters.setConfName("CONF");
        epfTransformParameters.setLibName("LIB");
        epfTransformParameters.setConfReadOnLoad(true);
        epfTransformParameters.setLibReadOnLoad(true);
        epfTransformParameters.setConfStoreOnDisposal(true);
        epfTransformParameters.setLibStoreOnDisposal(true);
        epfTransformParameters.setArtMetaModelFilePath(eviMetamodelFile);
        epfTransformParameters.setProcessMetaModelFilePath(procMetamodelFile);
        epfTransformParameters.setArtMetamodelURI(EvidencePackage.eINSTANCE.getNsURI());
        epfTransformParameters.setProcessMetaModelURI(ProcessPackage.eINSTANCE.getNsURI());
        epfTransformParameters.setArtModelFilePath(this.eviModelFile);
        epfTransformParameters.setProcessModelFilePath(this.procModelFile);
        epfTransformParameters.setArtName("ART");
        epfTransformParameters.setProcessName("PRO");
        epfTransformParameters.setArtReadOnLoad(false);
        epfTransformParameters.setProcessReadOnLoad(false);
        epfTransformParameters.setArtStoreOnDisposal(true);
        epfTransformParameters.setProcessStoreOnDisposal(true);
        return epfTransformParameters;
    }
}

