/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.webkit.GdkRectangle;
import org.eclipse.swt.internal.webkit.JSClassDefinition;
import org.eclipse.swt.internal.webkit.WebKitGTK;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class WebKit
extends WebBrowser {
    int webView;
    int scrolledWindow;
    int webViewData;
    int failureCount;
    int lastKeyCode;
    int lastCharCode;
    String postData;
    String[] headers;
    boolean ignoreDispose;
    boolean loadingText;
    boolean untrustedText;
    byte[] htmlBytes;
    BrowserFunction eventFunction;
    static boolean bug522733FirstInstanceCreated = false;
    private static int nonBlockingEvaluate = 0;
    static int DisabledJSCount;
    static int ExternalClass;
    static int PostString;
    static int WebViewType;
    static boolean IsWebKit14orNewer;
    static boolean LibraryLoaded;
    static Map<LONG, LONG> WindowMappings;
    static final String ABOUT_BLANK = "about:blank";
    static final String CLASSNAME_EXTERNAL = "External";
    static final String FUNCTIONNAME_CALLJAVA = "callJava";
    static final String HEADER_CONTENTTYPE = "content-type";
    static final String MIMETYPE_FORMURLENCODED = "application/x-www-form-urlencoded";
    static final String OBJECTNAME_EXTERNAL = "external";
    static final String PROPERTY_LENGTH = "length";
    static final String PROPERTY_PROXYHOST = "network.proxy_host";
    static final String PROPERTY_PROXYPORT = "network.proxy_port";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_HTTP = "http://";
    static final String URI_FILEROOT = "file:///";
    static final String USER_AGENT = "user-agent";
    static final int MAX_PORT = 65535;
    static final int MAX_PROGRESS = 100;
    static final int[] MIN_VERSION;
    static final int SENTINEL_KEYPRESS = -1;
    static final char SEPARATOR_FILE;
    static final int STOP_PROPOGATE = 1;
    static final String DOMEVENT_DRAGSTART = "dragstart";
    static final String DOMEVENT_KEYDOWN = "keydown";
    static final String DOMEVENT_KEYPRESS = "keypress";
    static final String DOMEVENT_KEYUP = "keyup";
    static final String DOMEVENT_MOUSEDOWN = "mousedown";
    static final String DOMEVENT_MOUSEUP = "mouseup";
    static final String DOMEVENT_MOUSEMOVE = "mousemove";
    static final String DOMEVENT_MOUSEOUT = "mouseout";
    static final String DOMEVENT_MOUSEOVER = "mouseover";
    static final String DOMEVENT_MOUSEWHEEL = "mousewheel";
    static final int HOVERING_OVER_LINK = 1;
    static final int NOTIFY_PROGRESS = 2;
    static final int NAVIGATION_POLICY_DECISION_REQUESTED = 3;
    static final int NOTIFY_TITLE = 4;
    static final int POPULATE_POPUP = 5;
    static final int STATUS_BAR_TEXT_CHANGED = 6;
    static final int CREATE_WEB_VIEW = 7;
    static final int WEB_VIEW_READY = 8;
    static final int NOTIFY_LOAD_STATUS = 9;
    static final int RESOURCE_REQUEST_STARTING = 10;
    static final int DOWNLOAD_REQUESTED = 11;
    static final int MIME_TYPE_POLICY_DECISION_REQUESTED = 12;
    static final int CLOSE_WEB_VIEW = 13;
    static final int WINDOW_OBJECT_CLEARED = 14;
    static final int CONSOLE_MESSAGE = 15;
    static final int LOAD_CHANGED = 16;
    static final int DECIDE_POLICY = 17;
    static final int MOUSE_TARGET_CHANGED = 18;
    static final int CONTEXT_MENU = 19;
    static final int AUTHENTICATE = 20;
    static final String KEY_CHECK_SUBWINDOW = "org.eclipse.swt.internal.control.checksubwindow";
    static final String SWT_WEBKITGTK_VERSION = "org.eclipse.swt.internal.webkitgtk.version";
    static Callback Proc2;
    static Callback Proc3;
    static Callback Proc4;
    static Callback Proc5;
    static Callback Proc6;
    static Callback JSObjectHasPropertyProc;
    static Callback JSObjectGetPropertyProc;
    static Callback JSObjectCallAsFunctionProc;
    static Callback JSDOMEventProc;
    static boolean WEBKIT2;

    static {
        WindowMappings = new HashMap<LONG, LONG>();
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        MIN_VERSION = nArray;
        SEPARATOR_FILE = System.getProperty("file.separator").charAt(0);
        try {
            Library.loadLibrary("swt-webkit");
            LibraryLoaded = true;
        }
        catch (Throwable throwable) {}
        if (LibraryLoaded) {
            String webkit2 = System.getenv("SWT_WEBKIT2");
            int webkit2VersionFunction = WebKitGTK.webkit_get_major_version();
            if (webkit2VersionFunction != 0) {
                webkit2 = "1";
            }
            WEBKIT2 = webkit2 != null && webkit2.equals("1") && OS.GTK3;
            WebViewType = WebKitGTK.webkit_web_view_get_type();
            Proc2 = new Callback(WebKit.class, "Proc", 2);
            if (Proc2.getAddress() == 0) {
                SWT.error(3);
            }
            if ((Proc3 = new Callback(WebKit.class, "Proc", 3)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((Proc4 = new Callback(WebKit.class, "Proc", 4)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((Proc5 = new Callback(WebKit.class, "Proc", 5)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((Proc6 = new Callback(WebKit.class, "Proc", 6)).getAddress() == 0) {
                SWT.error(3);
            }
            if (WEBKIT2) {
                new Webkit2JavascriptEvaluator();
            }
            if (WEBKIT2) {
                new Webkit2JavaCallback();
            } else {
                JSObjectHasPropertyProc = new Callback(WebKit.class, "JSObjectHasPropertyProc", 3);
                if (JSObjectHasPropertyProc.getAddress() == 0) {
                    SWT.error(3);
                }
                if ((JSObjectGetPropertyProc = new Callback(WebKit.class, "JSObjectGetPropertyProc", 4)).getAddress() == 0) {
                    SWT.error(3);
                }
                if ((JSObjectCallAsFunctionProc = new Callback(WebKit.class, "JSObjectCallAsFunctionProc", 6)).getAddress() == 0) {
                    SWT.error(3);
                }
            }
            JSDOMEventProc = new Callback(WebKit.class, "JSDOMEventProc", 3);
            if (JSDOMEventProc.getAddress() == 0) {
                SWT.error(3);
            }
            NativeClearSessions = () -> {
                int type;
                if (!LibraryLoaded) {
                    return;
                }
                int session = WebKitGTK.webkit_get_default_session();
                int jar = WebKitGTK.soup_session_get_feature(session, type = WebKitGTK.soup_cookie_jar_get_type());
                if (jar == 0) {
                    return;
                }
                int cookies = WebKitGTK.soup_cookie_jar_all_cookies(jar);
                int length = OS.g_slist_length(cookies);
                int current = cookies;
                int i = 0;
                while (i < length) {
                    int cookie = OS.g_slist_data(current);
                    int expires = WebKitGTK.SoupCookie_expires(cookie);
                    if (expires == 0) {
                        WebKitGTK.soup_cookie_jar_delete_cookie(jar, cookie);
                    }
                    WebKitGTK.soup_cookie_free(cookie);
                    current = OS.g_slist_next(current);
                    ++i;
                }
                OS.g_slist_free(cookies);
            };
            NativeGetCookie = () -> {
                int type;
                if (!LibraryLoaded) {
                    return;
                }
                int session = WebKitGTK.webkit_get_default_session();
                int jar = WebKitGTK.soup_session_get_feature(session, type = WebKitGTK.soup_cookie_jar_get_type());
                if (jar == 0) {
                    return;
                }
                byte[] bytes = Converter.wcsToMbcs(CookieUrl, true);
                int uri = WebKitGTK.soup_uri_new(bytes);
                if (uri == 0) {
                    return;
                }
                int cookies = WebKitGTK.soup_cookie_jar_get_cookies(jar, uri, 0);
                WebKitGTK.soup_uri_free(uri);
                if (cookies == 0) {
                    return;
                }
                int length = OS.strlen(cookies);
                bytes = new byte[length];
                C.memmove(bytes, cookies, length);
                OS.g_free(cookies);
                String allCookies = new String(Converter.mbcsToWcs(bytes));
                StringTokenizer tokenizer = new StringTokenizer(allCookies, ";");
                while (tokenizer.hasMoreTokens()) {
                    String name;
                    String cookie = tokenizer.nextToken();
                    int index = cookie.indexOf(61);
                    if (index == -1 || !(name = cookie.substring(0, index).trim()).equals(CookieName)) continue;
                    CookieValue = cookie.substring(index + 1).trim();
                    return;
                }
            };
            NativeSetCookie = () -> {
                int type;
                if (!LibraryLoaded) {
                    return;
                }
                int session = WebKitGTK.webkit_get_default_session();
                int jar = WebKitGTK.soup_session_get_feature(session, type = WebKitGTK.soup_cookie_jar_get_type());
                if (jar == 0) {
                    WebKitGTK.soup_session_add_feature_by_type(session, type);
                    jar = WebKitGTK.soup_session_get_feature(session, type);
                }
                if (jar == 0) {
                    return;
                }
                byte[] bytes = Converter.wcsToMbcs(CookieUrl, true);
                int uri = WebKitGTK.soup_uri_new(bytes);
                if (uri == 0) {
                    return;
                }
                bytes = Converter.wcsToMbcs(CookieValue, true);
                int cookie = WebKitGTK.soup_cookie_parse(bytes, uri);
                if (cookie != 0) {
                    WebKitGTK.soup_cookie_jar_add_cookie(jar, cookie);
                    CookieResult = true;
                }
                WebKitGTK.soup_uri_free(uri);
            };
            if (NativePendingCookies != null) {
                WebKit.SetPendingCookies(NativePendingCookies);
                NativePendingCookies = null;
            }
        }
    }

    WebKit() {
    }

    @Override
    String getJavaCallDeclaration() {
        if (WEBKIT2) {
            return "if (!window.callJava) {\n\t\twindow.callJava = function callJava(index, token, args) {\n         window.webkit.messageHandlers.webkit2JavaCallProc.postMessage([index,token, args]);\n\t\t}\n};\n";
        }
        return super.getJavaCallDeclaration();
    }

    private static int[] internalGetWebkitVersion() {
        int[] vers = new int[3];
        if (WEBKIT2) {
            vers[0] = WebKitGTK.webkit_get_major_version();
            vers[1] = WebKitGTK.webkit_get_minor_version();
            vers[2] = WebKitGTK.webkit_get_micro_version();
        } else {
            vers[0] = WebKitGTK.webkit_major_version();
            vers[1] = WebKitGTK.webkit_minor_version();
            vers[2] = WebKitGTK.webkit_micro_version();
        }
        return vers;
    }

    static String getString(int strPtr) {
        int length = OS.strlen(strPtr);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, strPtr, length);
        return new String(Converter.mbcsToWcs(buffer));
    }

    static Browser FindBrowser(int webView) {
        if (webView == 0) {
            return null;
        }
        int parent = OS.gtk_widget_get_parent(webView);
        if (!WEBKIT2) {
            parent = OS.gtk_widget_get_parent(parent);
        }
        return (Browser)Display.getCurrent().findWidget(parent);
    }

    static boolean IsInstalled() {
        if (!LibraryLoaded) {
            return false;
        }
        int[] vers = WebKit.internalGetWebkitVersion();
        int major = vers[0];
        int minor = vers[1];
        int micro = vers[2];
        boolean bl = IsWebKit14orNewer = major > 1 || major == 1 && minor > 4 || major == 1 && minor == 4 && micro >= 0;
        return major > MIN_VERSION[0] || major == MIN_VERSION[0] && minor > MIN_VERSION[1] || major == MIN_VERSION[0] && minor == MIN_VERSION[1] && micro >= MIN_VERSION[2];
    }

    static int JSObjectCallAsFunctionProc(int ctx, int function, int thisObject, int argumentCount, int arguments, int exception) {
        if (WEBKIT2) {
            System.err.println("Internal error: SWT JSObjectCallAsFunctionProc. This should never have been called on webkit2.");
            return 0;
        }
        if (WebKitGTK.JSValueIsObjectOfClass(ctx, thisObject, ExternalClass) == 0) {
            return WebKitGTK.JSValueMakeUndefined(ctx);
        }
        int ptr = WebKitGTK.JSObjectGetPrivate(thisObject);
        int[] handle = new int[1];
        C.memmove(handle, ptr, C.PTR_SIZEOF);
        Browser browser = WebKit.FindBrowser(handle[0]);
        if (browser == null) {
            return 0;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        return webkit.callJava(ctx, function, thisObject, argumentCount, arguments, exception);
    }

    static int JSObjectGetPropertyProc(int ctx, int object, int propertyName, int exception) {
        if (WEBKIT2) {
            System.err.println("Internal error: SWT WebKit.java:JSObjectGetPropertyProc. This should never have been called on webkit2.");
            return 0;
        }
        byte[] bytes = "callJava\u0000".getBytes(StandardCharsets.UTF_8);
        int name = WebKitGTK.JSStringCreateWithUTF8CString(bytes);
        int function = WebKitGTK.JSObjectMakeFunctionWithCallback(ctx, name, JSObjectCallAsFunctionProc.getAddress());
        WebKitGTK.JSStringRelease(name);
        return function;
    }

    static int JSObjectHasPropertyProc(int ctx, int object, int propertyName) {
        if (WEBKIT2) {
            System.err.println("Internal error: SWT JSObjectHasPropertyProc. This should never have been called on webkit2.");
            return 0;
        }
        byte[] bytes = "callJava\u0000".getBytes(StandardCharsets.UTF_8);
        return WebKitGTK.JSStringIsEqualToUTF8CString(propertyName, bytes);
    }

    static int JSDOMEventProc(int arg0, int event, int user_data) {
        block14: {
            block15: {
                Browser browser;
                block16: {
                    if (OS.GTK_IS_SCROLLED_WINDOW(arg0)) {
                        return user_data;
                    }
                    if (!OS.G_TYPE_CHECK_INSTANCE_TYPE(arg0, WebViewType)) break block14;
                    if (DisabledJSCount <= 0 || (browser = WebKit.FindBrowser(arg0)) == null || browser.webBrowser.jsEnabled) break block15;
                    block0 : switch (OS.GDK_EVENT_TYPE(event)) {
                        case 8: {
                            if (!browser.isFocusControl()) break;
                            GdkEventKey gdkEvent = new GdkEventKey();
                            OS.memmove(gdkEvent, event, GdkEventKey.sizeof);
                            switch (gdkEvent.keyval) {
                                case 65056: 
                                case 65289: {
                                    if ((gdkEvent.state & 0xC) == 0) {
                                        browser.getDisplay().asyncExec(() -> {
                                            if (browser.isDisposed()) {
                                                return;
                                            }
                                            if (browser.getDisplay().getFocusControl() == null) {
                                                int traversal = (gdkEventKey.state & 1) != 0 ? 8 : 16;
                                                browser.traverse(traversal);
                                            }
                                        });
                                        break block0;
                                    }
                                    break block16;
                                }
                                case 65307: {
                                    Event keyEvent = new Event();
                                    keyEvent.widget = browser;
                                    keyEvent.type = 1;
                                    keyEvent.character = (char)27;
                                    keyEvent.keyCode = 27;
                                    if ((gdkEvent.state & 8) != 0) {
                                        keyEvent.stateMask |= 0x10000;
                                    }
                                    if ((gdkEvent.state & 1) != 0) {
                                        keyEvent.stateMask |= 0x20000;
                                    }
                                    if ((gdkEvent.state & 4) != 0) {
                                        keyEvent.stateMask |= 0x40000;
                                    }
                                    browser.webBrowser.sendKeyEvent(keyEvent);
                                    return 1;
                                }
                            }
                        }
                    }
                }
                OS.gtk_widget_event(browser.handle, event);
            }
            return 0;
        }
        LONG webViewHandle = WindowMappings.get(new LONG(arg0));
        if (webViewHandle == null) {
            return 0;
        }
        Browser browser = WebKit.FindBrowser(webViewHandle.value);
        if (browser == null) {
            return 0;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        return webkit.handleDOMEvent(event, user_data) ? 0 : 1;
    }

    static int Proc(int handle, int user_data) {
        Browser browser = WebKit.FindBrowser(handle);
        if (browser == null) {
            return 0;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        return webkit.webViewProc(handle, user_data);
    }

    static int Proc(int handle, int arg0, int user_data) {
        int webView;
        if (OS.G_TYPE_CHECK_INSTANCE_TYPE(handle, WebKitGTK.webkit_web_view_get_type())) {
            webView = handle;
        } else if (OS.G_TYPE_CHECK_INSTANCE_TYPE(handle, WebKitGTK.webkit_web_frame_get_type())) {
            webView = WebKitGTK.webkit_web_frame_get_web_view(handle);
        } else {
            return 0;
        }
        Browser browser = WebKit.FindBrowser(webView);
        if (browser == null) {
            return 0;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        if (webView == handle) {
            return webkit.webViewProc(handle, arg0, user_data);
        }
        return webkit.webFrameProc(handle, arg0, user_data);
    }

    static int Proc(int handle, int arg0, int arg1, int user_data) {
        Browser browser = WebKit.FindBrowser(handle);
        if (browser == null) {
            return 0;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        return webkit.webViewProc(handle, arg0, arg1, user_data);
    }

    static int Proc(int handle, int arg0, int arg1, int arg2, int user_data) {
        int webView = !WEBKIT2 && OS.G_TYPE_CHECK_INSTANCE_TYPE(handle, WebKitGTK.soup_session_get_type()) ? user_data : handle;
        Browser browser = WebKit.FindBrowser(webView);
        if (browser == null) {
            return 0;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        if (!WEBKIT2 && webView == user_data) {
            return webkit.sessionProc(handle, arg0, arg1, arg2, user_data);
        }
        return webkit.webViewProc(handle, arg0, arg1, arg2, user_data);
    }

    static int Proc(int handle, int arg0, int arg1, int arg2, int arg3, int user_data) {
        Browser browser = WebKit.FindBrowser(handle);
        if (browser == null) {
            return 0;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        return webkit.webViewProc(handle, arg0, arg1, arg2, arg3, user_data);
    }

    int sessionProc(int session, int msg, int auth, int retrying, int user_data) {
        if (retrying == 0) {
            this.failureCount = 0;
        } else if (++this.failureCount >= 3) {
            return 0;
        }
        int uri = WebKitGTK.soup_message_get_uri(msg);
        int uriString = WebKitGTK.soup_uri_to_string(uri, 0);
        int length = C.strlen(uriString);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, uriString, length);
        OS.g_free(uriString);
        String location = new String(Converter.mbcsToWcs(bytes));
        int i = 0;
        while (i < this.authenticationListeners.length) {
            AuthenticationEvent event = new AuthenticationEvent(this.browser);
            event.location = location;
            this.authenticationListeners[i].authenticate(event);
            if (!event.doit) {
                OS.g_signal_stop_emission_by_name(session, WebKitGTK.authenticate);
                return 0;
            }
            if (event.user != null && event.password != null) {
                byte[] userBytes = Converter.wcsToMbcs(event.user, true);
                byte[] passwordBytes = Converter.wcsToMbcs(event.password, true);
                WebKitGTK.soup_auth_authenticate(auth, userBytes, passwordBytes);
                OS.g_signal_stop_emission_by_name(session, WebKitGTK.authenticate);
                return 0;
            }
            ++i;
        }
        return 0;
    }

    int webkit_authenticate(int web_view, int request) {
        if (!WebKitGTK.webkit_authentication_request_is_retry(request)) {
            this.failureCount = 0;
        } else if (++this.failureCount >= 3) {
            return 0;
        }
        String location = this.getUrl();
        int i = 0;
        while (i < this.authenticationListeners.length) {
            AuthenticationEvent event = new AuthenticationEvent(this.browser);
            event.location = location;
            try {
                ++nonBlockingEvaluate;
                this.authenticationListeners[i].authenticate(event);
            }
            finally {
                --nonBlockingEvaluate;
            }
            if (!event.doit) {
                WebKitGTK.webkit_authentication_request_cancel(request);
                return 0;
            }
            if (event.user != null && event.password != null) {
                byte[] userBytes = Converter.wcsToMbcs(event.user, true);
                byte[] passwordBytes = Converter.wcsToMbcs(event.password, true);
                int credentials = WebKitGTK.webkit_credential_new(userBytes, passwordBytes, 0);
                WebKitGTK.webkit_authentication_request_authenticate(request, credentials);
                WebKitGTK.webkit_credential_free(credentials);
                return 0;
            }
            ++i;
        }
        return 0;
    }

    int webFrameProc(int handle, int arg0, int user_data) {
        switch (user_data) {
            case 9: {
                return this.webframe_notify_load_status(handle, arg0);
            }
            case 16: {
                return this.webkit_load_changed(handle, arg0, user_data);
            }
        }
        return 0;
    }

    int webViewProc(int handle, int user_data) {
        switch (user_data) {
            case 13: {
                return this.webkit_close_web_view(handle);
            }
            case 8: {
                return this.webkit_web_view_ready(handle);
            }
        }
        return 0;
    }

    int webViewProc(int handle, int arg0, int user_data) {
        switch (user_data) {
            case 7: {
                return this.webkit_create_web_view(handle, arg0);
            }
            case 11: {
                return this.webkit_download_requested(handle, arg0);
            }
            case 9: {
                return this.webkit_notify_load_status(handle, arg0);
            }
            case 16: {
                return this.webkit_load_changed(handle, arg0, user_data);
            }
            case 2: {
                return this.webkit_notify_progress(handle, arg0);
            }
            case 4: {
                return this.webkit_notify_title(handle, arg0);
            }
            case 5: {
                return this.webkit_populate_popup(handle, arg0);
            }
            case 6: {
                return this.webkit_status_bar_text_changed(handle, arg0);
            }
            case 20: {
                return this.webkit_authenticate(handle, arg0);
            }
        }
        return 0;
    }

    int webViewProc(int handle, int arg0, int arg1, int user_data) {
        switch (user_data) {
            case 1: {
                return this.webkit_hovering_over_link(handle, arg0, arg1);
            }
            case 18: {
                return this.webkit_mouse_target_changed(handle, arg0, arg1);
            }
            case 17: {
                return this.webkit_decide_policy(handle, arg0, arg1, user_data);
            }
        }
        return 0;
    }

    int webViewProc(int handle, int arg0, int arg1, int arg2, int user_data) {
        switch (user_data) {
            case 15: {
                return this.webkit_console_message(handle, arg0, arg1, arg2);
            }
            case 14: {
                return this.webkit_window_object_cleared(handle, arg0, arg1, arg2);
            }
            case 19: {
                return this.webkit_context_menu(handle, arg0, arg1, arg2);
            }
        }
        return 0;
    }

    int webViewProc(int handle, int arg0, int arg1, int arg2, int arg3, int user_data) {
        switch (user_data) {
            case 12: {
                return this.webkit_mime_type_policy_decision_requested(handle, arg0, arg1, arg2, arg3);
            }
            case 3: {
                return this.webkit_navigation_policy_decision_requested(handle, arg0, arg1, arg2, arg3);
            }
            case 10: {
                return this.webkit_resource_request_starting(handle, arg0, arg1, arg2, arg3);
            }
        }
        return 0;
    }

    @Override
    public void create(Composite parent, int style) {
        int[] vers = WebKit.internalGetWebkitVersion();
        if (ExternalClass == 0) {
            int database;
            System.setProperty(SWT_WEBKITGTK_VERSION, String.format("%s.%s.%s", vers[0], vers[1], vers[2]));
            if (Device.DEBUG) {
                System.out.println(String.format("WebKit version %s.%s.%s", vers[0], vers[1], vers[2]));
            }
            if (!WEBKIT2) {
                JSClassDefinition jsClassDefinition = new JSClassDefinition();
                byte[] bytes = Converter.wcsToMbcs(CLASSNAME_EXTERNAL, true);
                jsClassDefinition.className = C.malloc(bytes.length);
                OS.memmove(jsClassDefinition.className, bytes, bytes.length);
                jsClassDefinition.hasProperty = JSObjectHasPropertyProc.getAddress();
                jsClassDefinition.getProperty = JSObjectGetPropertyProc.getAddress();
                int classDefinitionPtr = C.malloc(JSClassDefinition.sizeof);
                WebKitGTK.memmove(classDefinitionPtr, jsClassDefinition, JSClassDefinition.sizeof);
                ExternalClass = WebKitGTK.JSClassCreate(classDefinitionPtr);
            }
            byte[] bytes = Converter.wcsToMbcs("POST", true);
            PostString = C.malloc(bytes.length);
            C.memmove(PostString, bytes, bytes.length);
            if (!WEBKIT2 && (database = WebKitGTK.webkit_get_favicon_database()) != 0) {
                WebKitGTK.webkit_favicon_database_set_path(database, 0);
            }
        }
        if (!WEBKIT2) {
            this.scrolledWindow = OS.gtk_scrolled_window_new(0, 0);
            OS.gtk_scrolled_window_set_policy(this.scrolledWindow, 1, 1);
        }
        if (WEBKIT2) {
            int WebKitUserContentManager = WebKitGTK.webkit_user_content_manager_new();
            this.webView = WebKitGTK.webkit_web_view_new_with_user_content_manager(WebKitUserContentManager);
            Webkit2JavaCallback.connectSignal(WebKitUserContentManager, this.webView);
        } else {
            this.webView = WebKitGTK.webkit_web_view_new();
        }
        if (WEBKIT2 && !bug522733FirstInstanceCreated && vers[0] == 2 && vers[1] >= 18) {
            bug522733FirstInstanceCreated = true;
            OS.g_object_ref(this.webView);
        }
        if (!WEBKIT2) {
            this.webViewData = C.malloc(C.PTR_SIZEOF);
            C.memmove(this.webViewData, new int[]{this.webView}, C.PTR_SIZEOF);
        }
        if (!WEBKIT2) {
            OS.gtk_container_add(this.scrolledWindow, this.webView);
            OS.gtk_container_add(this.browser.handle, this.scrolledWindow);
            OS.gtk_widget_show(this.scrolledWindow);
            OS.g_signal_connect(this.webView, WebKitGTK.close_web_view, Proc2.getAddress(), 13);
            OS.g_signal_connect(this.webView, WebKitGTK.console_message, Proc5.getAddress(), 15);
            OS.g_signal_connect(this.webView, WebKitGTK.create_web_view, Proc3.getAddress(), 7);
            OS.g_signal_connect(this.webView, WebKitGTK.notify_load_status, Proc3.getAddress(), 9);
            OS.g_signal_connect(this.webView, WebKitGTK.web_view_ready, Proc2.getAddress(), 8);
            OS.g_signal_connect(this.webView, WebKitGTK.navigation_policy_decision_requested, Proc6.getAddress(), 3);
            OS.g_signal_connect(this.webView, WebKitGTK.mime_type_policy_decision_requested, Proc6.getAddress(), 12);
            OS.g_signal_connect(this.webView, WebKitGTK.resource_request_starting, Proc6.getAddress(), 10);
            OS.g_signal_connect(this.webView, WebKitGTK.download_requested, Proc3.getAddress(), 11);
            OS.g_signal_connect(this.webView, WebKitGTK.hovering_over_link, Proc4.getAddress(), 1);
            OS.g_signal_connect(this.webView, WebKitGTK.populate_popup, Proc3.getAddress(), 5);
            OS.g_signal_connect(this.webView, WebKitGTK.notify_progress, Proc3.getAddress(), 2);
            OS.g_signal_connect(this.webView, WebKitGTK.window_object_cleared, Proc5.getAddress(), 14);
            OS.g_signal_connect(this.webView, WebKitGTK.status_bar_text_changed, Proc3.getAddress(), 6);
        } else {
            OS.gtk_container_add(this.browser.handle, this.webView);
            OS.g_signal_connect(this.webView, WebKitGTK.close, Proc2.getAddress(), 13);
            OS.g_signal_connect(this.webView, WebKitGTK.create, Proc3.getAddress(), 7);
            OS.g_signal_connect(this.webView, WebKitGTK.load_changed, Proc3.getAddress(), 16);
            OS.g_signal_connect(this.webView, WebKitGTK.ready_to_show, Proc2.getAddress(), 8);
            OS.g_signal_connect(this.webView, WebKitGTK.decide_policy, Proc4.getAddress(), 17);
            OS.g_signal_connect(WebKitGTK.webkit_web_context_get_default(), WebKitGTK.download_started, Proc3.getAddress(), 11);
            OS.g_signal_connect(this.webView, WebKitGTK.mouse_target_changed, Proc4.getAddress(), 18);
            OS.g_signal_connect(this.webView, WebKitGTK.context_menu, Proc5.getAddress(), 19);
            OS.g_signal_connect(this.webView, WebKitGTK.notify_estimated_load_progress, Proc3.getAddress(), 2);
            OS.g_signal_connect(this.webView, WebKitGTK.authenticate, Proc3.getAddress(), 20);
        }
        OS.gtk_widget_show(this.webView);
        OS.gtk_widget_show(this.browser.handle);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_title, Proc3.getAddress(), 4);
        OS.g_signal_connect(this.webView, OS.button_press_event, JSDOMEventProc.getAddress(), 0);
        OS.g_signal_connect(this.webView, OS.button_release_event, JSDOMEventProc.getAddress(), 0);
        OS.g_signal_connect(this.webView, OS.key_press_event, JSDOMEventProc.getAddress(), 0);
        OS.g_signal_connect(this.webView, OS.key_release_event, JSDOMEventProc.getAddress(), 0);
        OS.g_signal_connect(this.webView, OS.scroll_event, JSDOMEventProc.getAddress(), 0);
        OS.g_signal_connect(this.webView, OS.motion_notify_event, JSDOMEventProc.getAddress(), 0);
        if (!WEBKIT2) {
            OS.g_signal_connect(this.scrolledWindow, OS.button_press_event, JSDOMEventProc.getAddress(), 1);
            OS.g_signal_connect(this.scrolledWindow, OS.button_release_event, JSDOMEventProc.getAddress(), 1);
            OS.g_signal_connect(this.scrolledWindow, OS.key_press_event, JSDOMEventProc.getAddress(), 1);
            OS.g_signal_connect(this.scrolledWindow, OS.key_release_event, JSDOMEventProc.getAddress(), 1);
            OS.g_signal_connect(this.scrolledWindow, OS.scroll_event, JSDOMEventProc.getAddress(), 1);
            OS.g_signal_connect(this.scrolledWindow, OS.motion_notify_event, JSDOMEventProc.getAddress(), 1);
        }
        byte[] bytes = Converter.wcsToMbcs("UTF-8", true);
        int settings = WebKitGTK.webkit_web_view_get_settings(this.webView);
        OS.g_object_set(settings, WebKitGTK.javascript_can_open_windows_automatically, 1, 0);
        OS.g_object_set(settings, WebKitGTK.enable_webgl, 1, 0);
        if (WEBKIT2) {
            OS.g_object_set(settings, WebKitGTK.default_charset, bytes, 0);
            OS.g_object_set(settings, WebKitGTK.allow_universal_access_from_file_urls, 1, 0);
        } else {
            OS.g_object_set(settings, WebKitGTK.default_encoding, bytes, 0);
            OS.g_object_set(settings, WebKitGTK.enable_universal_access_from_file_uris, 1, 0);
        }
        Listener listener = event -> {
            switch (event.type) {
                case 12: {
                    if (this.ignoreDispose) {
                        this.ignoreDispose = false;
                        break;
                    }
                    this.ignoreDispose = true;
                    this.browser.notifyListeners(event.type, event);
                    event.type = 0;
                    this.onDispose(event);
                    break;
                }
                case 15: {
                    OS.gtk_widget_grab_focus(this.webView);
                    break;
                }
                case 11: {
                    this.onResize(event);
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(15, listener);
        this.browser.addListener(1, listener);
        this.browser.addListener(11, listener);
        if (!WEBKIT2) {
            int session = WebKitGTK.webkit_get_default_session();
            int originalAuth = WebKitGTK.soup_session_get_feature(session, WebKitGTK.webkit_soup_auth_dialog_get_type());
            if (originalAuth != 0) {
                WebKitGTK.soup_session_feature_detach(originalAuth, session);
            }
            OS.g_signal_connect(session, WebKitGTK.authenticate, Proc5.getAddress(), this.webView);
            if (originalAuth != 0) {
                WebKitGTK.soup_session_feature_attach(originalAuth, session);
            }
            String proxyHost = System.getProperty(PROPERTY_PROXYHOST);
            String proxyPortString = System.getProperty(PROPERTY_PROXYPORT);
            int port = -1;
            if (proxyPortString != null) {
                try {
                    int value = Integer.valueOf(proxyPortString);
                    if (value >= 0 && value <= 65535) {
                        port = value;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (proxyHost != null || port != -1) {
                int uri;
                if (!proxyHost.startsWith(PROTOCOL_HTTP)) {
                    proxyHost = PROTOCOL_HTTP + proxyHost;
                }
                if ((uri = WebKitGTK.soup_uri_new(bytes = Converter.wcsToMbcs(proxyHost = String.valueOf(proxyHost) + ":" + port, true))) != 0) {
                    OS.g_object_set(session, WebKitGTK.SOUP_SESSION_PROXY_URI, uri, 0);
                    WebKitGTK.soup_uri_free(uri);
                }
            }
        }
        if (!WEBKIT2) {
            this.eventFunction = new BrowserFunction(this.browser, "HandleWebKitEvent"){

                @Override
                public Object function(Object[] arguments) {
                    return WebKit.this.handleEventFromFunction(arguments) ? Boolean.TRUE : Boolean.FALSE;
                }
            };
        }
        this.browser.setData(KEY_CHECK_SUBWINDOW, Boolean.FALSE);
        int major = vers[0];
        int minor = vers[1];
        if (major == 1 && minor >= 10) {
            Rectangle minSize = this.browser.computeTrim(0, 0, 2, 2);
            Point size = this.browser.getSize();
            size.x += minSize.width;
            size.y += minSize.height;
            this.browser.setSize(size);
            size.x -= minSize.width;
            size.y -= minSize.height;
            this.browser.setSize(size);
        }
    }

    void addEventHandlers(int web_view, boolean top) {
        if (!this.jsEnabled) {
            return;
        }
        if (top && IsWebKit14orNewer) {
            int domDocument = WebKitGTK.webkit_web_view_get_dom_document(web_view);
            if (domDocument != 0) {
                WindowMappings.put(new LONG(domDocument), new LONG(web_view));
                WebKitGTK.webkit_dom_event_target_add_event_listener(domDocument, WebKitGTK.dragstart, JSDOMEventProc.getAddress(), 0, 29);
                WebKitGTK.webkit_dom_event_target_add_event_listener(domDocument, WebKitGTK.keydown, JSDOMEventProc.getAddress(), 0, 1);
                WebKitGTK.webkit_dom_event_target_add_event_listener(domDocument, WebKitGTK.keypress, JSDOMEventProc.getAddress(), 0, -1);
                WebKitGTK.webkit_dom_event_target_add_event_listener(domDocument, WebKitGTK.keyup, JSDOMEventProc.getAddress(), 0, 2);
                WebKitGTK.webkit_dom_event_target_add_event_listener(domDocument, WebKitGTK.mousedown, JSDOMEventProc.getAddress(), 0, 3);
                WebKitGTK.webkit_dom_event_target_add_event_listener(domDocument, WebKitGTK.mousemove, JSDOMEventProc.getAddress(), 0, 5);
                WebKitGTK.webkit_dom_event_target_add_event_listener(domDocument, WebKitGTK.mouseup, JSDOMEventProc.getAddress(), 0, 4);
                WebKitGTK.webkit_dom_event_target_add_event_listener(domDocument, WebKitGTK.mousewheel, JSDOMEventProc.getAddress(), 0, 37);
            }
            return;
        }
        if (!WEBKIT2) {
            StringBuffer buffer = new StringBuffer("window.SWTkeyhandler = function SWTkeyhandler(e) {");
            buffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.keyCode, e.charCode, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey);} catch (e) {}};");
            this.execute(buffer.toString());
            buffer = new StringBuffer("window.SWTmousehandler = function SWTmousehandler(e) {");
            buffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.screenX, e.screenY, e.detail, e.button, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey, e.relatedTarget != null);} catch (e) {}};");
            this.execute(buffer.toString());
            if (top) {
                buffer = new StringBuffer("document.addEventListener('keydown', SWTkeyhandler, true);");
                buffer.append("document.addEventListener('keypress', SWTkeyhandler, true);");
                buffer.append("document.addEventListener('keyup', SWTkeyhandler, true);");
                buffer.append("document.addEventListener('mousedown', SWTmousehandler, true);");
                buffer.append("document.addEventListener('mouseup', SWTmousehandler, true);");
                buffer.append("document.addEventListener('mousemove', SWTmousehandler, true);");
                buffer.append("document.addEventListener('mousewheel', SWTmousehandler, true);");
                buffer.append("document.addEventListener('dragstart', SWTmousehandler, true);");
                this.execute(buffer.toString());
                return;
            }
            buffer = new StringBuffer("for (var i = 0; i < frames.length; i++) {");
            buffer.append("frames[i].document.addEventListener('keydown', window.SWTkeyhandler, true);");
            buffer.append("frames[i].document.addEventListener('keypress', window.SWTkeyhandler, true);");
            buffer.append("frames[i].document.addEventListener('keyup', window.SWTkeyhandler, true);");
            buffer.append("frames[i].document.addEventListener('mousedown', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('mouseup', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('mousemove', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('mouseover', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('mouseout', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('mousewheel', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('dragstart', window.SWTmousehandler, true);");
            buffer.append('}');
            this.execute(buffer.toString());
        }
    }

    @Override
    public boolean back() {
        if (WebKitGTK.webkit_web_view_can_go_back(this.webView) == 0) {
            return false;
        }
        WebKitGTK.webkit_web_view_go_back(this.webView);
        return true;
    }

    @Override
    public boolean close() {
        return this.close(true);
    }

    boolean close(boolean showPrompters) {
        Boolean result;
        if (!this.jsEnabled) {
            return true;
        }
        String message1 = Compatibility.getMessage("SWT_OnBeforeUnload_Message1");
        String message2 = Compatibility.getMessage("SWT_OnBeforeUnload_Message2");
        String functionName = "SWTExecuteTemporaryFunctionCLOSE";
        StringBuffer buffer = new StringBuffer("function ");
        buffer.append(functionName);
        buffer.append("(win) {\n");
        buffer.append("var fn = win.onbeforeunload; if (fn != null) {try {var str = fn(); ");
        if (showPrompters) {
            buffer.append("if (str != null) { ");
            buffer.append("var result = confirm('");
            buffer.append(message1);
            buffer.append("\\n\\n'+str+'\\n\\n");
            buffer.append(message2);
            buffer.append("');");
            buffer.append("if (!result) return false;}");
        }
        buffer.append("} catch (e) {}}");
        buffer.append("try {for (var i = 0; i < win.frames.length; i++) {var result = ");
        buffer.append(functionName);
        buffer.append("(win.frames[i]); if (!result) return false;}} catch (e) {} return true;");
        buffer.append("\n};");
        this.execute(buffer.toString());
        if (!WEBKIT2) {
            result = (Boolean)this.evaluate("return " + functionName + "(window);");
            if (result == null) {
                return false;
            }
        } else {
            try {
                result = (Boolean)this.evaluate("return " + functionName + "(window);");
                if (result == null) {
                    return true;
                }
            }
            catch (SWTException sWTException) {
                return true;
            }
        }
        return result;
    }

    @Override
    public boolean execute(String script) {
        int result = 0;
        if (WEBKIT2) {
            try {
                this.evaluate(script);
            }
            catch (SWTException sWTException) {
                return false;
            }
            return true;
        }
        byte[] scriptBytes = (String.valueOf(script) + '\u0000').getBytes(StandardCharsets.UTF_8);
        int jsScriptString = WebKitGTK.JSStringCreateWithUTF8CString(scriptBytes);
        byte[] sourceUrlbytes = (String.valueOf(this.getUrl()) + '\u0000').getBytes(StandardCharsets.UTF_8);
        int jsSourceUrlString = WebKitGTK.JSStringCreateWithUTF8CString(sourceUrlbytes);
        int frame = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        int context = WebKitGTK.webkit_web_frame_get_global_context(frame);
        result = WebKitGTK.JSEvaluateScript(context, jsScriptString, 0, jsSourceUrlString, 0, null);
        WebKitGTK.JSStringRelease(jsSourceUrlString);
        WebKitGTK.JSStringRelease(jsScriptString);
        return result != 0;
    }

    @Override
    public Object evaluate(String script) throws SWTException {
        if (WEBKIT2) {
            if (this.webkit_settings_get(WebKitGTK.enable_javascript) == 0) {
                return null;
            }
            boolean doNotBlock = nonBlockingEvaluate > 0;
            return Webkit2JavascriptEvaluator.evaluate(script, this.browser, this.webView, doNotBlock);
        }
        return super.evaluate(script);
    }

    @Override
    public boolean forward() {
        if (WebKitGTK.webkit_web_view_can_go_forward(this.webView) == 0) {
            return false;
        }
        WebKitGTK.webkit_web_view_go_forward(this.webView);
        return true;
    }

    @Override
    public String getBrowserType() {
        return "webkit";
    }

    @Override
    public String getText() {
        int frame = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        int source = WebKitGTK.webkit_web_frame_get_data_source(frame);
        if (source == 0) {
            return "";
        }
        int data = WebKitGTK.webkit_web_data_source_get_data(source);
        if (data == 0) {
            return "";
        }
        int encoding = WebKitGTK.webkit_web_data_source_get_encoding(source);
        int length = OS.strlen(encoding);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, encoding, length);
        String encodingString = new String(Converter.mbcsToWcs(bytes));
        length = OS.GString_len(data);
        bytes = new byte[length];
        int string = OS.GString_str(data);
        C.memmove(bytes, string, length);
        try {
            return new String(bytes, encodingString);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(Converter.mbcsToWcs(bytes));
        }
    }

    @Override
    public String getUrl() {
        int uri = WebKitGTK.webkit_web_view_get_uri(this.webView);
        if (uri == 0) {
            return ABOUT_BLANK;
        }
        int length = OS.strlen(uri);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, uri, length);
        String url = new String(Converter.mbcsToWcs(bytes));
        if (url.equals(URI_FILEROOT)) {
            url = ABOUT_BLANK;
        } else {
            length = URI_FILEROOT.length();
            if (url.startsWith(URI_FILEROOT) && url.charAt(length) == '#') {
                url = ABOUT_BLANK + url.substring(length);
            }
        }
        return url;
    }

    boolean handleDOMEvent(int event, int type) {
        String typeString = null;
        boolean isMouseEvent = false;
        switch (type) {
            case 29: {
                typeString = DOMEVENT_DRAGSTART;
                isMouseEvent = true;
                break;
            }
            case 3: {
                typeString = DOMEVENT_MOUSEDOWN;
                isMouseEvent = true;
                break;
            }
            case 5: {
                typeString = DOMEVENT_MOUSEMOVE;
                isMouseEvent = true;
                break;
            }
            case 4: {
                typeString = DOMEVENT_MOUSEUP;
                isMouseEvent = true;
                break;
            }
            case 37: {
                typeString = DOMEVENT_MOUSEWHEEL;
                isMouseEvent = true;
                break;
            }
            case 1: {
                typeString = DOMEVENT_KEYDOWN;
                break;
            }
            case 2: {
                typeString = DOMEVENT_KEYUP;
                break;
            }
            case -1: {
                typeString = DOMEVENT_KEYPRESS;
            }
        }
        if (isMouseEvent) {
            int screenX = (int)WebKitGTK.webkit_dom_mouse_event_get_screen_x(event);
            int screenY = (int)WebKitGTK.webkit_dom_mouse_event_get_screen_y(event);
            int button = WebKitGTK.webkit_dom_mouse_event_get_button(event) + 1;
            boolean altKey = WebKitGTK.webkit_dom_mouse_event_get_alt_key(event) != 0;
            boolean ctrlKey = WebKitGTK.webkit_dom_mouse_event_get_ctrl_key(event) != 0;
            boolean shiftKey = WebKitGTK.webkit_dom_mouse_event_get_shift_key(event) != 0;
            boolean metaKey = WebKitGTK.webkit_dom_mouse_event_get_meta_key(event) != 0;
            int detail = (int)WebKitGTK.webkit_dom_ui_event_get_detail(event);
            boolean hasRelatedTarget = false;
            return this.handleMouseEvent(typeString, screenX, screenY, detail, button, altKey, ctrlKey, shiftKey, metaKey, hasRelatedTarget);
        }
        int keyEventState = 0;
        int eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, eventPtr, GdkEventKey.sizeof);
            switch (gdkEvent.type) {
                case 8: 
                case 9: {
                    keyEventState = gdkEvent.state;
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        int keyCode = (int)WebKitGTK.webkit_dom_ui_event_get_key_code(event);
        int charCode = (int)WebKitGTK.webkit_dom_ui_event_get_char_code(event);
        boolean altKey = (keyEventState & 8) != 0;
        boolean ctrlKey = (keyEventState & 4) != 0;
        boolean shiftKey = (keyEventState & 1) != 0;
        return this.handleKeyEvent(typeString, keyCode, charCode, altKey, ctrlKey, shiftKey, false);
    }

    boolean handleEventFromFunction(Object[] arguments) {
        String type = (String)arguments[0];
        if (type.equals(DOMEVENT_KEYDOWN) || type.equals(DOMEVENT_KEYPRESS) || type.equals(DOMEVENT_KEYUP)) {
            return this.handleKeyEvent(type, ((Double)arguments[1]).intValue(), ((Double)arguments[2]).intValue(), (Boolean)arguments[3], (Boolean)arguments[4], (Boolean)arguments[5], (Boolean)arguments[6]);
        }
        return this.handleMouseEvent(type, ((Double)arguments[1]).intValue(), ((Double)arguments[2]).intValue(), ((Double)arguments[3]).intValue(), (arguments[4] != null ? ((Double)arguments[4]).intValue() : 0) + 1, (Boolean)arguments[5], (Boolean)arguments[6], (Boolean)arguments[7], (Boolean)arguments[8], (Boolean)arguments[9]);
    }

    boolean handleKeyEvent(String type, int keyCode, int charCode, boolean altKey, boolean ctrlKey, boolean shiftKey, boolean metaKey) {
        if (type.equals(DOMEVENT_KEYDOWN)) {
            this.lastKeyCode = keyCode = this.translateKey(keyCode);
            switch (keyCode) {
                case 8: 
                case 9: 
                case 27: 
                case 127: 
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: 
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000005: 
                case 0x1000006: 
                case 0x1000007: 
                case 0x1000008: 
                case 0x1000009: 
                case 0x100000A: 
                case 0x100000B: 
                case 0x100000C: 
                case 0x100000D: 
                case 0x100000E: 
                case 0x100000F: 
                case 0x1000010: 
                case 0x1000011: 
                case 0x1000012: 
                case 0x1000013: 
                case 0x1000014: 
                case 0x1000015: 
                case 16777298: 
                case 16777299: 
                case 16777300: 
                case 0x1000055: {
                    Event keyEvent = new Event();
                    keyEvent.widget = this.browser;
                    keyEvent.type = type.equals(DOMEVENT_KEYDOWN) ? 1 : 2;
                    keyEvent.keyCode = keyCode;
                    switch (keyCode) {
                        case 8: {
                            keyEvent.character = (char)8;
                            break;
                        }
                        case 127: {
                            keyEvent.character = (char)127;
                            break;
                        }
                        case 27: {
                            keyEvent.character = (char)27;
                            break;
                        }
                        case 9: {
                            keyEvent.character = (char)9;
                        }
                    }
                    this.lastCharCode = keyEvent.character;
                    keyEvent.stateMask = (altKey ? 65536 : 0) | (ctrlKey ? 262144 : 0) | (shiftKey ? 131072 : 0) | (metaKey ? 0x400000 : 0);
                    keyEvent.stateMask &= ~keyCode;
                    int stateMask = keyEvent.stateMask;
                    if (!this.sendKeyEvent(keyEvent) || this.browser.isDisposed()) {
                        return false;
                    }
                    if (!this.browser.isFocusControl() || keyCode != 9 || (stateMask & 0x50000) != 0) break;
                    this.browser.getDisplay().asyncExec(() -> {
                        if (this.browser.isDisposed()) {
                            return;
                        }
                        if (this.browser.getDisplay().getFocusControl() == null) {
                            int traversal = (stateMask & 0x20000) != 0 ? 8 : 16;
                            this.browser.traverse(traversal);
                        }
                    });
                }
            }
            return true;
        }
        if (type.equals(DOMEVENT_KEYPRESS)) {
            if (this.lastKeyCode == 0) {
                return true;
            }
            this.lastCharCode = charCode;
            if (ctrlKey && this.lastCharCode >= 0 && this.lastCharCode <= 127) {
                if (97 <= this.lastCharCode && this.lastCharCode <= 122) {
                    this.lastCharCode -= 32;
                }
                if (64 <= this.lastCharCode && this.lastCharCode <= 95) {
                    this.lastCharCode -= 64;
                }
            }
            Event keyEvent = new Event();
            keyEvent.widget = this.browser;
            keyEvent.type = 1;
            keyEvent.keyCode = this.lastKeyCode;
            keyEvent.character = (char)this.lastCharCode;
            keyEvent.stateMask = (altKey ? 65536 : 0) | (ctrlKey ? 262144 : 0) | (shiftKey ? 131072 : 0) | (metaKey ? 0x400000 : 0);
            return this.sendKeyEvent(keyEvent) && !this.browser.isDisposed();
        }
        if ((keyCode = this.translateKey(keyCode)) == 0) {
            return true;
        }
        if (keyCode != this.lastKeyCode) {
            this.lastKeyCode = keyCode;
            this.lastCharCode = 0;
        }
        Event keyEvent = new Event();
        keyEvent.widget = this.browser;
        keyEvent.type = 2;
        keyEvent.keyCode = this.lastKeyCode;
        keyEvent.character = (char)this.lastCharCode;
        keyEvent.stateMask = (altKey ? 65536 : 0) | (ctrlKey ? 262144 : 0) | (shiftKey ? 131072 : 0) | (metaKey ? 0x400000 : 0);
        switch (this.lastKeyCode) {
            case 65536: 
            case 131072: 
            case 262144: 
            case 0x400000: {
                keyEvent.stateMask |= this.lastKeyCode;
            }
        }
        this.browser.notifyListeners(keyEvent.type, keyEvent);
        this.lastCharCode = 0;
        this.lastKeyCode = 0;
        return keyEvent.doit && !this.browser.isDisposed();
    }

    boolean handleMouseEvent(String type, int screenX, int screenY, int detail, int button, boolean altKey, boolean ctrlKey, boolean shiftKey, boolean metaKey, boolean hasRelatedTarget) {
        int mask;
        Point position = new Point(screenX, screenY);
        position = this.browser.getDisplay().map(null, (Control)this.browser, position);
        Event mouseEvent = new Event();
        mouseEvent.widget = this.browser;
        mouseEvent.x = position.x;
        mouseEvent.y = position.y;
        mouseEvent.stateMask = mask = (altKey ? 65536 : 0) | (ctrlKey ? 262144 : 0) | (shiftKey ? 131072 : 0) | (metaKey ? 0x400000 : 0);
        if (type.equals(DOMEVENT_MOUSEDOWN)) {
            mouseEvent.type = 3;
            mouseEvent.count = detail;
            mouseEvent.button = button;
            this.browser.notifyListeners(mouseEvent.type, mouseEvent);
            if (this.browser.isDisposed()) {
                return true;
            }
            if (detail == 2) {
                mouseEvent = new Event();
                mouseEvent.type = 8;
                mouseEvent.widget = this.browser;
                mouseEvent.x = position.x;
                mouseEvent.y = position.y;
                mouseEvent.stateMask = mask;
                mouseEvent.count = detail;
                mouseEvent.button = button;
                this.browser.notifyListeners(mouseEvent.type, mouseEvent);
            }
            return true;
        }
        if (type.equals(DOMEVENT_MOUSEUP)) {
            mouseEvent.type = 4;
            mouseEvent.count = detail;
            mouseEvent.button = button;
        } else if (type.equals(DOMEVENT_MOUSEMOVE)) {
            mouseEvent.type = 5;
        } else if (type.equals(DOMEVENT_MOUSEWHEEL)) {
            mouseEvent.type = 37;
            mouseEvent.count = detail;
        } else if (type.equals(DOMEVENT_DRAGSTART)) {
            mouseEvent.type = 29;
            mouseEvent.button = button;
            switch (mouseEvent.button) {
                case 1: {
                    mouseEvent.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    mouseEvent.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    mouseEvent.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    mouseEvent.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    mouseEvent.stateMask |= 0x2000000;
                }
            }
            if (!IsWebKit14orNewer) {
                this.browser.notifyListeners(mouseEvent.type, mouseEvent);
                return false;
            }
        }
        this.browser.notifyListeners(mouseEvent.type, mouseEvent);
        return true;
    }

    int handleLoadCommitted(int uri, boolean top) {
        int length = OS.strlen(uri);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, uri, length);
        String url = new String(Converter.mbcsToWcs(bytes));
        if (url.equals(URI_FILEROOT)) {
            url = ABOUT_BLANK;
        } else {
            length = URI_FILEROOT.length();
            if (url.startsWith(URI_FILEROOT) && url.charAt(length) == '#') {
                url = ABOUT_BLANK + url.substring(length);
            }
        }
        if (!WEBKIT2 && top && url.startsWith(ABOUT_BLANK) && this.htmlBytes != null) {
            return 0;
        }
        LocationEvent event = new LocationEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        event.location = url;
        event.top = top;
        Runnable fireLocationChanged = () -> {
            if (this.browser.isDisposed()) {
                return;
            }
            int i = 0;
            while (i < this.locationListeners.length) {
                this.locationListeners[i].changed(event);
                ++i;
            }
        };
        if (WEBKIT2) {
            this.browser.getDisplay().asyncExec(fireLocationChanged);
        } else {
            fireLocationChanged.run();
        }
        return 0;
    }

    private void fireNewTitleEvent(String title) {
        if (!WEBKIT2) {
            TitleEvent newEvent = new TitleEvent(this.browser);
            newEvent.display = this.browser.getDisplay();
            newEvent.widget = this.browser;
            newEvent.title = title;
            int i = 0;
            while (i < this.titleListeners.length) {
                this.titleListeners[i].changed(newEvent);
                ++i;
            }
        }
    }

    private void fireProgressCompletedEvent() {
        Runnable fireProgressEvents = () -> {
            if (this.browser.isDisposed() || this.progressListeners == null) {
                return;
            }
            ProgressEvent progress = new ProgressEvent(this.browser);
            progress.display = this.browser.getDisplay();
            progress.widget = this.browser;
            progress.current = 100;
            progress.total = 100;
            int i = 0;
            while (i < this.progressListeners.length) {
                this.progressListeners[i].completed(progress);
                ++i;
            }
        };
        if (WEBKIT2) {
            this.browser.getDisplay().asyncExec(fireProgressEvents);
        } else {
            fireProgressEvents.run();
        }
    }

    int handleLoadFinished(int uri, boolean top) {
        int length = OS.strlen(uri);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, uri, length);
        String url = new String(Converter.mbcsToWcs(bytes));
        if (url.equals(URI_FILEROOT)) {
            url = ABOUT_BLANK;
        } else {
            length = URI_FILEROOT.length();
            if (url.startsWith(URI_FILEROOT) && url.charAt(length) == '#') {
                url = ABOUT_BLANK + url.substring(length);
            }
        }
        if (top && this.htmlBytes != null && url.startsWith(ABOUT_BLANK)) {
            this.loadingText = true;
            byte[] mimeType = Converter.wcsToMbcs("text/html", true);
            byte[] encoding = Converter.wcsToMbcs(StandardCharsets.UTF_8.displayName(), true);
            byte[] uriBytes = this.untrustedText ? Converter.wcsToMbcs(ABOUT_BLANK, true) : Converter.wcsToMbcs(URI_FILEROOT, true);
            WebKitGTK.webkit_web_view_load_string(this.webView, this.htmlBytes, mimeType, encoding, uriBytes);
            this.htmlBytes = null;
        }
        if (!this.loadingText) {
            int frame;
            int title;
            if (top && (title = WebKitGTK.webkit_web_frame_get_title(frame = WebKitGTK.webkit_web_view_get_main_frame(this.webView))) == 0) {
                this.fireNewTitleEvent(url);
                if (this.browser.isDisposed()) {
                    return 0;
                }
            }
            this.fireProgressCompletedEvent();
        }
        this.loadingText = false;
        return 0;
    }

    @Override
    public boolean isBackEnabled() {
        return WebKitGTK.webkit_web_view_can_go_back(this.webView) != 0;
    }

    @Override
    public boolean isForwardEnabled() {
        return WebKitGTK.webkit_web_view_can_go_forward(this.webView) != 0;
    }

    void onDispose(Event e) {
        if (!this.browser.isDisposed() && !this.browser.isClosing) {
            this.close(false);
        }
        Iterator elements = this.functions.values().iterator();
        while (elements.hasNext()) {
            ((BrowserFunction)elements.next()).dispose(false);
        }
        this.functions = null;
        if (!WEBKIT2) {
            if (this.eventFunction != null) {
                this.eventFunction.dispose(false);
                this.eventFunction = null;
            }
            C.free(this.webViewData);
        }
        this.postData = null;
        this.headers = null;
        this.htmlBytes = null;
    }

    void onResize(Event e) {
        Rectangle rect = DPIUtil.autoScaleUp(this.browser.getClientArea());
        if (WEBKIT2) {
            OS.gtk_widget_set_size_request(this.webView, rect.width, rect.height);
        } else {
            OS.gtk_widget_set_size_request(this.scrolledWindow, rect.width, rect.height);
        }
    }

    void openDownloadWindow(final int webkitDownload) {
        final Shell shell = new Shell();
        String msg = Compatibility.getMessage("SWT_FileDownload");
        shell.setText(msg);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        gridLayout.verticalSpacing = 20;
        shell.setLayout(gridLayout);
        int name = WebKitGTK.webkit_download_get_suggested_filename(webkitDownload);
        int length = OS.strlen(name);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, name, length);
        String nameString = new String(Converter.mbcsToWcs(bytes));
        int url = WebKitGTK.webkit_download_get_uri(webkitDownload);
        length = OS.strlen(url);
        bytes = new byte[length];
        OS.memmove(bytes, url, length);
        String urlString = new String(Converter.mbcsToWcs(bytes));
        msg = Compatibility.getMessage("SWT_Download_Location", new Object[]{nameString, urlString});
        Label nameLabel = new Label(shell, 64);
        nameLabel.setText(msg);
        GridData data = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int maxWidth = monitor.getBounds().width / 2;
        int width = nameLabel.computeSize((int)-1, (int)-1).x;
        data.widthHint = Math.min(width, maxWidth);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        nameLabel.setLayoutData(data);
        final Label statusLabel = new Label(shell, 0);
        statusLabel.setText(Compatibility.getMessage("SWT_Download_Started"));
        data = new GridData(1808);
        statusLabel.setLayoutData(data);
        final Button cancel = new Button(shell, 8);
        cancel.setText(Compatibility.getMessage("SWT_Cancel"));
        data = new GridData();
        data.horizontalAlignment = 2;
        cancel.setLayoutData(data);
        final Listener cancelListener = event -> WebKitGTK.webkit_download_cancel(webkitDownload);
        cancel.addListener(13, cancelListener);
        OS.g_object_ref(webkitDownload);
        final Display display = this.browser.getDisplay();
        display.timerExec(500, new Runnable(){

            @Override
            public void run() {
                int status = WebKitGTK.webkit_download_get_status(webkitDownload);
                if (shell.isDisposed() || status == 3 || status == 2) {
                    shell.dispose();
                    display.timerExec(-1, this);
                    OS.g_object_unref(webkitDownload);
                    return;
                }
                if (status == -1) {
                    statusLabel.setText(Compatibility.getMessage("SWT_Download_Error"));
                    display.timerExec(-1, this);
                    OS.g_object_unref(webkitDownload);
                    cancel.removeListener(13, cancelListener);
                    cancel.addListener(13, event -> shell.dispose());
                    return;
                }
                long current = WebKitGTK.webkit_download_get_current_size(webkitDownload) / 1024L;
                long total = WebKitGTK.webkit_download_get_total_size(webkitDownload) / 1024L;
                String message = Compatibility.getMessage("SWT_Download_Status", new Object[]{new Long(current), new Long(total)});
                statusLabel.setText(message);
                display.timerExec(500, this);
            }
        });
        shell.pack();
        shell.open();
    }

    @Override
    public void refresh() {
        WebKitGTK.webkit_web_view_reload(this.webView);
    }

    @Override
    public boolean setText(String html, boolean trusted) {
        byte[] bytes = (String.valueOf(html) + '\u0000').getBytes(StandardCharsets.UTF_8);
        boolean blankLoading = this.htmlBytes != null;
        this.htmlBytes = bytes;
        boolean bl = this.untrustedText = !trusted;
        if (WEBKIT2) {
            byte[] uriBytes = this.untrustedText ? Converter.wcsToMbcs(ABOUT_BLANK, true) : Converter.wcsToMbcs(URI_FILEROOT, true);
            WebKitGTK.webkit_web_view_load_html(this.webView, this.htmlBytes, uriBytes);
        } else {
            if (blankLoading) {
                return true;
            }
            byte[] uriBytes = Converter.wcsToMbcs(ABOUT_BLANK, true);
            WebKitGTK.webkit_web_view_load_uri(this.webView, uriBytes);
        }
        return true;
    }

    @Override
    public boolean setUrl(String url, String postData, String[] headers) {
        this.postData = postData;
        this.headers = headers;
        try {
            new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            String testUrl = null;
            testUrl = url.charAt(0) == SEPARATOR_FILE ? PROTOCOL_FILE + url : PROTOCOL_HTTP + url;
            try {
                new URL(testUrl);
                url = testUrl;
            }
            catch (MalformedURLException malformedURLException2) {}
        }
        int settings = WebKitGTK.webkit_web_view_get_settings(this.webView);
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                int index;
                String current = headers[i];
                if (current != null && (index = current.indexOf(58)) != -1) {
                    String key = current.substring(0, index).trim();
                    String value = current.substring(index + 1).trim();
                    if (key.length() > 0 && value.length() > 0 && key.equalsIgnoreCase(USER_AGENT)) {
                        byte[] bytes = Converter.wcsToMbcs(value, true);
                        OS.g_object_set(settings, WebKitGTK.user_agent, bytes, 0);
                    }
                }
                ++i;
            }
        }
        byte[] uriBytes = Converter.wcsToMbcs(url, true);
        if (WEBKIT2 && headers != null) {
            int request = WebKitGTK.webkit_uri_request_new(uriBytes);
            int requestHeaders = WebKitGTK.webkit_uri_request_get_http_headers(request);
            if (requestHeaders != 0) {
                this.addRequestHeaders(requestHeaders, headers);
            }
            WebKitGTK.webkit_web_view_load_request(this.webView, request);
            return true;
        }
        WebKitGTK.webkit_web_view_load_uri(this.webView, uriBytes);
        OS.g_object_set(settings, WebKitGTK.user_agent, 0, 0);
        return true;
    }

    @Override
    public void stop() {
        WebKitGTK.webkit_web_view_stop_loading(this.webView);
    }

    int webframe_notify_load_status(int web_frame, int pspec) {
        int status = WebKitGTK.webkit_web_frame_get_load_status(web_frame);
        switch (status) {
            case 1: {
                int uri = WebKitGTK.webkit_web_frame_get_uri(web_frame);
                return this.handleLoadCommitted(uri, false);
            }
            case 2: {
                int parentFrame = WebKitGTK.webkit_web_frame_get_parent(web_frame);
                if (WebKitGTK.webkit_web_frame_get_load_status(parentFrame) != 2) break;
                int uri = WebKitGTK.webkit_web_frame_get_uri(web_frame);
                return this.handleLoadFinished(uri, false);
            }
        }
        return 0;
    }

    int webkit_close_web_view(int web_view) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        Runnable fireCloseWindowListeners = () -> {
            if (this.browser.isDisposed()) {
                return;
            }
            int i = 0;
            while (i < this.closeWindowListeners.length) {
                this.closeWindowListeners[i].close(newEvent);
                ++i;
            }
            this.browser.dispose();
        };
        if (WEBKIT2) {
            this.browser.getDisplay().asyncExec(fireCloseWindowListeners);
        } else {
            fireCloseWindowListeners.run();
        }
        return 0;
    }

    int webkit_console_message(int web_view, int message, int line, int source_id) {
        return 1;
    }

    int webkit_create_web_view(int web_view, int frame) {
        WindowEvent newEvent;
        block8: {
            newEvent = new WindowEvent(this.browser);
            newEvent.display = this.browser.getDisplay();
            newEvent.widget = this.browser;
            newEvent.required = true;
            Runnable fireOpenWindowListeners = () -> {
                if (this.openWindowListeners != null) {
                    int i = 0;
                    while (i < this.openWindowListeners.length) {
                        this.openWindowListeners[i].open(newEvent);
                        ++i;
                    }
                }
            };
            if (WEBKIT2) {
                try {
                    ++nonBlockingEvaluate;
                    fireOpenWindowListeners.run();
                    break block8;
                }
                finally {
                    --nonBlockingEvaluate;
                }
            }
            fireOpenWindowListeners.run();
        }
        Widget browser = null;
        if (newEvent.browser != null && newEvent.browser.webBrowser instanceof WebKit) {
            browser = newEvent.browser;
        }
        if (browser != null && !browser.isDisposed()) {
            return ((WebKit)((Browser)browser).webBrowser).webView;
        }
        return 0;
    }

    int webkit_download_requested(int web_view, int download) {
        int name = WebKitGTK.webkit_download_get_suggested_filename(download);
        int length = OS.strlen(name);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, name, length);
        String nameString = new String(Converter.mbcsToWcs(bytes));
        int request = WebKitGTK.webkit_download_get_network_request(download);
        OS.g_object_ref(request);
        this.browser.getDisplay().asyncExec(() -> {
            if (!this.browser.isDisposed()) {
                FileDialog dialog = new FileDialog(this.browser.getShell(), 8192);
                dialog.setFileName(nameString);
                String title = Compatibility.getMessage("SWT_FileDownload");
                dialog.setText(title);
                String path = dialog.open();
                if (path != null) {
                    path = URI_FILEROOT + path;
                    int newDownload = WebKitGTK.webkit_download_new(request);
                    byte[] uriBytes = Converter.wcsToMbcs(path, true);
                    WebKitGTK.webkit_download_set_destination_uri(newDownload, uriBytes);
                    this.openDownloadWindow(newDownload);
                    WebKitGTK.webkit_download_start(newDownload);
                    OS.g_object_unref(newDownload);
                }
            }
            OS.g_object_unref(request);
        });
        return 1;
    }

    int webkit_mouse_target_changed(int web_view, int hit_test_result, int modifiers) {
        if (WebKitGTK.webkit_hit_test_result_context_is_link(hit_test_result)) {
            int uri = WebKitGTK.webkit_hit_test_result_get_link_uri(hit_test_result);
            int title = WebKitGTK.webkit_hit_test_result_get_link_title(hit_test_result);
            return this.webkit_hovering_over_link(web_view, title, uri);
        }
        return 0;
    }

    int webkit_hovering_over_link(int web_view, int title, int uri) {
        if (uri != 0) {
            int length = OS.strlen(uri);
            byte[] bytes = new byte[length];
            OS.memmove(bytes, uri, length);
            String text = new String(Converter.mbcsToWcs(bytes));
            StatusTextEvent event = new StatusTextEvent(this.browser);
            event.display = this.browser.getDisplay();
            event.widget = this.browser;
            event.text = text;
            Runnable fireStatusTextListener = () -> {
                if (this.browser.isDisposed() || this.statusTextListeners == null) {
                    return;
                }
                int i = 0;
                while (i < this.statusTextListeners.length) {
                    this.statusTextListeners[i].changed(event);
                    ++i;
                }
            };
            if (WEBKIT2) {
                this.browser.getDisplay().asyncExec(fireStatusTextListener);
            } else {
                fireStatusTextListener.run();
            }
        }
        return 0;
    }

    int webkit_mime_type_policy_decision_requested(int web_view, int frame, int request, int mimetype, int policy_decision) {
        boolean canShow;
        boolean bl = canShow = WebKitGTK.webkit_web_view_can_show_mime_type(this.webView, mimetype) != 0;
        if (!canShow) {
            WebKitGTK.webkit_web_policy_decision_download(policy_decision);
            return 1;
        }
        return 0;
    }

    int webkit_navigation_policy_decision_requested(int web_view, int frame, int request, int navigation_action, int policy_decision) {
        assert (!WEBKIT2) : "Webkit1 only code was ran by webkit2";
        if (this.loadingText) {
            return 0;
        }
        int uri = WebKitGTK.webkit_network_request_get_uri(request);
        int length = OS.strlen(uri);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, uri, length);
        String url = new String(Converter.mbcsToWcs(bytes));
        if (url.equals(URI_FILEROOT)) {
            url = ABOUT_BLANK;
        } else {
            length = URI_FILEROOT.length();
            if (url.startsWith(URI_FILEROOT) && url.charAt(length) == '#') {
                url = ABOUT_BLANK + url.substring(length);
            }
        }
        LocationEvent newEvent = new LocationEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.location = url;
        newEvent.doit = true;
        if (this.locationListeners != null) {
            int i = 0;
            while (i < this.locationListeners.length) {
                this.locationListeners[i].changing(newEvent);
                ++i;
            }
        }
        if (newEvent.doit && !this.browser.isDisposed()) {
            int id;
            int mainFrame;
            if (this.jsEnabled != this.jsEnabledOnNextPage) {
                this.jsEnabled = this.jsEnabledOnNextPage;
                DisabledJSCount += !this.jsEnabled ? 1 : -1;
                this.webkit_settings_set(WebKitGTK.enable_scripts, this.jsEnabled ? 1 : 0);
            }
            if (frame != (mainFrame = WebKitGTK.webkit_web_view_get_main_frame(this.webView)) && (id = OS.g_signal_handler_find(frame, 24, 0, 0, 0, Proc3.getAddress(), 9)) == 0) {
                OS.g_signal_connect(frame, WebKitGTK.notify_load_status, Proc3.getAddress(), 9);
            }
        } else {
            WebKitGTK.webkit_web_policy_decision_ignore(policy_decision);
        }
        return 0;
    }

    int webkit_decide_policy(int web_view, int decision, int decision_type, int user_data) {
        assert (WEBKIT2) : "Webkit2 only code was ran by webkit1";
        switch (decision_type) {
            case 0: {
                int request = WebKitGTK.webkit_navigation_policy_decision_get_request(decision);
                if (request == 0) {
                    return 0;
                }
                int uri = WebKitGTK.webkit_uri_request_get_uri(request);
                String url = WebKit.getString(uri);
                if (url.equals(URI_FILEROOT)) {
                    url = ABOUT_BLANK;
                } else {
                    int length = URI_FILEROOT.length();
                    if (url.startsWith(URI_FILEROOT) && url.charAt(length) == '#') {
                        url = ABOUT_BLANK + url.substring(length);
                    }
                }
                LocationEvent newEvent = new LocationEvent(this.browser);
                newEvent.display = this.browser.getDisplay();
                newEvent.widget = this.browser;
                newEvent.location = url;
                newEvent.doit = true;
                try {
                    ++nonBlockingEvaluate;
                    if (this.locationListeners != null) {
                        int i = 0;
                        while (i < this.locationListeners.length) {
                            this.locationListeners[i].changing(newEvent);
                            ++i;
                        }
                    }
                }
                finally {
                    --nonBlockingEvaluate;
                }
                if (newEvent.doit && !this.browser.isDisposed() && this.jsEnabled != this.jsEnabledOnNextPage) {
                    this.jsEnabled = this.jsEnabledOnNextPage;
                    DisabledJSCount += !this.jsEnabled ? 1 : -1;
                    this.webkit_settings_set(WebKitGTK.enable_javascript, this.jsEnabled ? 1 : 0);
                }
                if (newEvent.doit) break;
                WebKitGTK.webkit_policy_decision_ignore(decision);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                boolean canShow;
                int response = WebKitGTK.webkit_response_policy_decision_get_response(decision);
                int mime_type = WebKitGTK.webkit_uri_response_get_mime_type(response);
                boolean bl = canShow = WebKitGTK.webkit_web_view_can_show_mime_type(this.webView, mime_type) != 0;
                if (canShow) break;
                WebKitGTK.webkit_policy_decision_download(decision);
                return 1;
            }
            default: {
                return 0;
            }
        }
        return 0;
    }

    int webkit_notify_load_status(int web_view, int pspec) {
        int status = WebKitGTK.webkit_web_view_get_load_status(this.webView);
        switch (status) {
            case 1: {
                int uri = WebKitGTK.webkit_web_view_get_uri(this.webView);
                return this.handleLoadCommitted(uri, true);
            }
            case 2: {
                int uri = WebKitGTK.webkit_web_view_get_uri(this.webView);
                return this.handleLoadFinished(uri, true);
            }
        }
        return 0;
    }

    int webkit_load_changed(int web_view, int status, long user_data) {
        switch (status) {
            case 2: {
                int uri = WebKitGTK.webkit_web_view_get_uri(this.webView);
                return this.handleLoadCommitted(uri, true);
            }
            case 3: {
                this.registerBrowserFunctions();
                this.addEventHandlers(web_view, true);
                int title = WebKitGTK.webkit_web_view_get_title(this.webView);
                if (title == 0) {
                    int uri = WebKitGTK.webkit_web_view_get_uri(this.webView);
                    this.fireNewTitleEvent(WebKit.getString(uri));
                }
                this.fireProgressCompletedEvent();
                return 0;
            }
        }
        return 0;
    }

    int webkit_notify_progress(int web_view, int pspec) {
        ProgressEvent event = new ProgressEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        double progress = 0.0;
        progress = WEBKIT2 ? WebKitGTK.webkit_web_view_get_estimated_load_progress(this.webView) : WebKitGTK.webkit_web_view_get_progress(this.webView);
        event.current = (int)(progress * 100.0);
        event.total = 100;
        Runnable fireProgressChangedEvents = () -> {
            if (this.browser.isDisposed() || this.progressListeners == null) {
                return;
            }
            int i = 0;
            while (i < this.progressListeners.length) {
                this.progressListeners[i].changed(event);
                ++i;
            }
        };
        if (WEBKIT2) {
            this.browser.getDisplay().asyncExec(fireProgressChangedEvents);
        } else {
            fireProgressChangedEvents.run();
        }
        return 0;
    }

    int webkit_notify_title(int web_view, int pspec) {
        String titleString;
        int title = WebKitGTK.webkit_web_view_get_title(this.webView);
        if (title == 0) {
            titleString = "";
        } else {
            int length = OS.strlen(title);
            byte[] bytes = new byte[length];
            OS.memmove(bytes, title, length);
            titleString = new String(Converter.mbcsToWcs(bytes));
        }
        TitleEvent event = new TitleEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        event.title = titleString;
        Runnable fireTitleListener = () -> {
            int i = 0;
            while (i < this.titleListeners.length) {
                this.titleListeners[i].changed(event);
                ++i;
            }
        };
        if (WEBKIT2) {
            this.browser.getDisplay().asyncExec(fireTitleListener);
        } else {
            fireTitleListener.run();
        }
        return 0;
    }

    int webkit_context_menu(int web_view, int context_menu, int eventXXX, int hit_test_result) {
        Point pt = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = pt.x;
        event.y = pt.y;
        this.browser.notifyListeners(35, event);
        if (!event.doit) {
            return 1;
        }
        Menu menu = this.browser.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (pt.x != event.x || pt.y != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 1;
        }
        return 0;
    }

    int webkit_populate_popup(int web_view, int webkit_menu) {
        Point pt = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = pt.x;
        event.y = pt.y;
        this.browser.notifyListeners(35, event);
        if (!event.doit) {
            int children;
            int current = children = OS.gtk_container_get_children(webkit_menu);
            while (current != 0) {
                int item = OS.g_list_data(current);
                OS.gtk_container_remove(webkit_menu, item);
                current = OS.g_list_next(current);
            }
            OS.g_list_free(children);
            return 0;
        }
        Menu menu = this.browser.getMenu();
        if (menu != null && !menu.isDisposed()) {
            int children;
            if (pt.x != event.x || pt.y != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            int current = children = OS.gtk_container_get_children(webkit_menu);
            while (current != 0) {
                int item = OS.g_list_data(current);
                OS.gtk_container_remove(webkit_menu, item);
                current = OS.g_list_next(current);
            }
            OS.g_list_free(children);
        }
        return 0;
    }

    private void addRequestHeaders(int requestHeaders, String[] headers) {
        int i = 0;
        while (i < headers.length) {
            int index;
            String current = headers[i];
            if (current != null && (index = current.indexOf(58)) != -1) {
                String key = current.substring(0, index).trim();
                String value = current.substring(index + 1).trim();
                if (key.length() > 0 && value.length() > 0) {
                    byte[] nameBytes = Converter.wcsToMbcs(key, true);
                    byte[] valueBytes = Converter.wcsToMbcs(value, true);
                    WebKitGTK.soup_message_headers_append(requestHeaders, nameBytes, valueBytes);
                }
            }
            ++i;
        }
    }

    int webkit_resource_request_starting(int web_view, int web_frame, int web_resource, int request, int response) {
        if (this.postData != null || this.headers != null) {
            int message = WebKitGTK.webkit_network_request_get_message(request);
            if (message == 0) {
                this.headers = null;
                this.postData = null;
            } else {
                if (this.postData != null) {
                    WebKitGTK.SoupMessage_method(message, PostString);
                    int body = WebKitGTK.SoupMessage_request_body(message);
                    byte[] bytes = Converter.wcsToMbcs(this.postData, false);
                    int data = C.malloc(bytes.length);
                    C.memmove(data, bytes, bytes.length);
                    WebKitGTK.soup_message_body_append(body, 1, data, bytes.length);
                    WebKitGTK.soup_message_body_flatten(body);
                    if (this.headers == null) {
                        this.headers = new String[0];
                    }
                    boolean found = false;
                    int i = 0;
                    while (i < this.headers.length) {
                        String name;
                        int index = this.headers[i].indexOf(58);
                        if (index != -1 && (name = this.headers[i].substring(0, index).trim().toLowerCase()).equals(HEADER_CONTENTTYPE)) {
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    if (!found) {
                        String[] temp = new String[this.headers.length + 1];
                        System.arraycopy(this.headers, 0, temp, 0, this.headers.length);
                        temp[this.headers.length] = "content-type:application/x-www-form-urlencoded";
                        this.headers = temp;
                    }
                    this.postData = null;
                }
                int requestHeaders = WebKitGTK.SoupMessage_request_headers(message);
                this.addRequestHeaders(requestHeaders, this.headers);
                this.headers = null;
            }
        }
        return 0;
    }

    int webkit_status_bar_text_changed(int web_view, int text) {
        int length = OS.strlen(text);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, text, length);
        StatusTextEvent statusText = new StatusTextEvent(this.browser);
        statusText.display = this.browser.getDisplay();
        statusText.widget = this.browser;
        statusText.text = new String(Converter.mbcsToWcs(bytes));
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(statusText);
            ++i;
        }
        return 0;
    }

    int webkit_web_view_ready(int web_view) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        if (!WEBKIT2) {
            int webKitWebWindowFeatures = WebKitGTK.webkit_web_view_get_window_features(this.webView);
            newEvent.addressBar = this.webkit_settings_get(webKitWebWindowFeatures, WebKitGTK.locationbar_visible) != 0;
            newEvent.menuBar = this.webkit_settings_get(webKitWebWindowFeatures, WebKitGTK.menubar_visible) != 0;
            newEvent.statusBar = this.webkit_settings_get(webKitWebWindowFeatures, WebKitGTK.statusbar_visible) != 0;
            newEvent.addressBar = this.webkit_settings_get(webKitWebWindowFeatures, WebKitGTK.toolbar_visible) != 0;
            int x = this.webkit_settings_get(webKitWebWindowFeatures, WebKitGTK.x);
            int y = this.webkit_settings_get(webKitWebWindowFeatures, WebKitGTK.y);
            int width = this.webkit_settings_get(webKitWebWindowFeatures, WebKitGTK.width);
            int height = this.webkit_settings_get(webKitWebWindowFeatures, WebKitGTK.height);
            if (x != -1 && y != -1) {
                newEvent.location = new Point(x, y);
            }
            if (width != -1 && height != -1) {
                newEvent.size = new Point(width, height);
            }
        } else {
            int properties = WebKitGTK.webkit_web_view_get_window_properties(this.webView);
            newEvent.addressBar = this.webkit_settings_get(properties, WebKitGTK.locationbar_visible) != 0;
            newEvent.menuBar = this.webkit_settings_get(properties, WebKitGTK.menubar_visible) != 0;
            newEvent.statusBar = this.webkit_settings_get(properties, WebKitGTK.statusbar_visible) != 0;
            newEvent.toolBar = this.webkit_settings_get(properties, WebKitGTK.toolbar_visible) != 0;
            GdkRectangle rect = new GdkRectangle();
            WebKitGTK.webkit_window_properties_get_geometry(properties, rect);
            newEvent.location = new Point(Math.max(0, rect.x), Math.max(0, rect.y));
            int width = rect.width;
            int height = rect.height;
            if (height == 100 && width == 100) {
                Rectangle primaryMonitorBounds = this.browser.getDisplay().getPrimaryMonitor().getBounds();
                height = (int)((double)primaryMonitorBounds.height * 0.66);
                width = (int)((double)primaryMonitorBounds.width * 0.66);
            }
            newEvent.size = new Point(width, height);
        }
        Runnable fireVisibilityListeners = () -> {
            if (this.browser.isDisposed()) {
                return;
            }
            int i = 0;
            while (i < this.visibilityWindowListeners.length) {
                this.visibilityWindowListeners[i].show(newEvent);
                ++i;
            }
        };
        if (WEBKIT2) {
            this.browser.getDisplay().asyncExec(fireVisibilityListeners);
        } else {
            fireVisibilityListeners.run();
        }
        return 0;
    }

    int webkit_window_object_cleared(int web_view, int frame, int context, int window_object) {
        int globalObject = WebKitGTK.JSContextGetGlobalObject(context);
        int externalObject = WebKitGTK.JSObjectMake(context, ExternalClass, this.webViewData);
        byte[] bytes = "external\u0000".getBytes(StandardCharsets.UTF_8);
        int name = WebKitGTK.JSStringCreateWithUTF8CString(bytes);
        WebKitGTK.JSObjectSetProperty(context, globalObject, name, externalObject, 0, null);
        WebKitGTK.JSStringRelease(name);
        this.registerBrowserFunctions();
        int mainFrame = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        boolean top = mainFrame == frame;
        this.addEventHandlers(web_view, top);
        return 0;
    }

    private int webkit_settings_get(byte[] property) {
        int settings = WebKitGTK.webkit_web_view_get_settings(this.webView);
        return this.webkit_settings_get(settings, property);
    }

    private int webkit_settings_get(int settings, byte[] property) {
        int[] result = new int[1];
        OS.g_object_get(settings, property, result, 0);
        return result[0];
    }

    private void webkit_settings_set(byte[] property, int value) {
        int settings = WebKitGTK.webkit_web_view_get_settings(this.webView);
        OS.g_object_set(settings, property, value, 0);
    }

    private void registerBrowserFunctions() {
        for (BrowserFunction current : this.functions.values()) {
            this.execute(current.functionString);
        }
    }

    int callJava(int ctx, int func, int thisObject, int argumentCount, int arguments, int exception) {
        Object returnValue = null;
        if (argumentCount == 3) {
            int[] result = new int[1];
            C.memmove(result, arguments, C.PTR_SIZEOF);
            int type = WebKitGTK.JSValueGetType(ctx, result[0]);
            if (type == 3) {
                int index = ((Double)WebKit.convertToJava(ctx, result[0])).intValue();
                result[0] = 0;
                Integer key = new Integer(index);
                C.memmove(result, arguments + C.PTR_SIZEOF, C.PTR_SIZEOF);
                type = WebKitGTK.JSValueGetType(ctx, result[0]);
                if (type == 4) {
                    String token = (String)WebKit.convertToJava(ctx, result[0]);
                    BrowserFunction function = (BrowserFunction)this.functions.get(key);
                    if (function != null && token.equals(function.token)) {
                        try {
                            C.memmove(result, arguments + 2 * C.PTR_SIZEOF, C.PTR_SIZEOF);
                            Object temp = WebKit.convertToJava(ctx, result[0]);
                            if (temp instanceof Object[]) {
                                Object[] args = (Object[])temp;
                                try {
                                    returnValue = function.function(args);
                                }
                                catch (Exception e) {
                                    returnValue = WebBrowser.CreateErrorString(e.getLocalizedMessage());
                                }
                            }
                        }
                        catch (IllegalArgumentException e) {
                            if (function.isEvaluate) {
                                function.function(new String[]{WebBrowser.CreateErrorString(new SWTException(51).getLocalizedMessage())});
                            }
                            returnValue = WebBrowser.CreateErrorString(e.getLocalizedMessage());
                        }
                    }
                }
            }
        }
        return this.convertToJS(ctx, returnValue);
    }

    int convertToJS(int ctx, Object value) {
        if (value == null) {
            return WebKitGTK.JSValueMakeUndefined(ctx);
        }
        if (value instanceof String) {
            byte[] bytes = (String.valueOf((String)value) + '\u0000').getBytes(StandardCharsets.UTF_8);
            int stringRef = WebKitGTK.JSStringCreateWithUTF8CString(bytes);
            int result = WebKitGTK.JSValueMakeString(ctx, stringRef);
            WebKitGTK.JSStringRelease(stringRef);
            return result;
        }
        if (value instanceof Boolean) {
            return WebKitGTK.JSValueMakeBoolean(ctx, (Boolean)value != false ? 1 : 0);
        }
        if (value instanceof Number) {
            return WebKitGTK.JSValueMakeNumber(ctx, ((Number)value).doubleValue());
        }
        if (value instanceof Object[]) {
            Object[] arrayValue = (Object[])value;
            int length = arrayValue.length;
            int[] arguments = new int[length];
            int i = 0;
            while (i < length) {
                int jsObject;
                Object javaObject = arrayValue[i];
                arguments[i] = jsObject = this.convertToJS(ctx, javaObject);
                ++i;
            }
            return WebKitGTK.JSObjectMakeArray(ctx, length, arguments, null);
        }
        SWT.error(51);
        return 0;
    }

    static Object convertToJava(int ctx, int value) {
        int type = WebKitGTK.JSValueGetType(ctx, value);
        switch (type) {
            case 2: {
                int result = (int)WebKitGTK.JSValueToNumber(ctx, value, null);
                return new Boolean(result != 0);
            }
            case 3: {
                double result = WebKitGTK.JSValueToNumber(ctx, value, null);
                return new Double(result);
            }
            case 4: {
                int string = WebKitGTK.JSValueToStringCopy(ctx, value, null);
                if (string == 0) {
                    return "";
                }
                int length = WebKitGTK.JSStringGetMaximumUTF8CStringSize(string);
                byte[] bytes = new byte[length];
                length = WebKitGTK.JSStringGetUTF8CString(string, bytes, length);
                WebKitGTK.JSStringRelease(string);
                return new String(bytes, 0, length - 1, StandardCharsets.UTF_8);
            }
            case 0: 
            case 1: {
                return null;
            }
            case 5: {
                byte[] bytes = "length\u0000".getBytes(StandardCharsets.UTF_8);
                int propertyName = WebKitGTK.JSStringCreateWithUTF8CString(bytes);
                int valuePtr = WebKitGTK.JSObjectGetProperty(ctx, value, propertyName, null);
                WebKitGTK.JSStringRelease(propertyName);
                type = WebKitGTK.JSValueGetType(ctx, valuePtr);
                if (type != 3) break;
                int length = (int)WebKitGTK.JSValueToNumber(ctx, valuePtr, null);
                Object[] result = new Object[length];
                int i = 0;
                while (i < length) {
                    int current = WebKitGTK.JSObjectGetPropertyAtIndex(ctx, value, i, null);
                    if (current != 0) {
                        result[i] = WebKit.convertToJava(ctx, current);
                    }
                    ++i;
                }
                return result;
            }
        }
        SWT.error(5);
        return null;
    }

    static class Webkit2JavaCallback {
        private static final String JavaScriptFunctionName = "webkit2JavaCallProc";
        private static final String Signal = "script-message-received::webkit2JavaCallProc";
        static final String JavaScriptFunctionDeclaration = "if (!window.callJava) {\n\t\twindow.callJava = function callJava(index, token, args) {\n         window.webkit.messageHandlers.webkit2JavaCallProc.postMessage([index,token, args]);\n\t\t}\n};\n";
        private static Callback callback = new Callback(Webkit2JavaCallback.class, "webkit2JavaCallProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});

        static {
            if (callback.getAddress() == 0) {
                SWT.error(3);
            }
        }

        Webkit2JavaCallback() {
        }

        private static void webkit2JavaCallProc(int WebKitUserContentManagerPtr, int WebKitJavascriptResultPtr, int webViewPtr) {
            try {
                int context = WebKitGTK.webkit_javascript_result_get_global_context(WebKitJavascriptResultPtr);
                int value = WebKitGTK.webkit_javascript_result_get_value(WebKitJavascriptResultPtr);
                Object[] arguments = (Object[])WebKit.convertToJava(context, value);
                if (arguments.length != 3) {
                    throw new IllegalArgumentException("Expected 3 args. Received: " + arguments.length);
                }
                Double index = (Double)arguments[0];
                String token = (String)arguments[1];
                Browser browser = WebKit.FindBrowser(webViewPtr);
                if (browser == null) {
                    throw new NullPointerException("Could not find assosiated browser instance for handle: " + webViewPtr);
                }
                BrowserFunction function = browser.webBrowser.functions.get(index.intValue());
                if (function == null) {
                    throw new NullPointerException("Could not find function with index: " + index);
                }
                if (!token.equals(function.token)) {
                    throw new IllegalStateException("Function token missmatch. Expected:" + function.token + " actual:" + token);
                }
                if (!(arguments[2] instanceof Object[])) {
                    throw new IllegalArgumentException("Javascript did not provide any arguments. An empty callback [like call()] should still provide an empty array");
                }
                try {
                    function.function((Object[])arguments[2]);
                }
                catch (Exception exception) {}
            }
            catch (RuntimeException e) {
                System.err.println("\nSWT Webkit2 internal error: Javascript callback from Webkit to Java encountered an error while processing the callback:");
                System.err.println("Please report this via: https://bugs.eclipse.org/bugs/enter_bug.cgi?alias=&assigned_to=platform-swt-inbox%40eclipse.org&attach_text=&blocked=&bug_file_loc=http%3A%2F%2F&bug_severity=normal&bug_status=NEW&comment=&component=SWT&contenttypeentry=&contenttypemethod=autodetect&contenttypeselection=text%2Fplain&data=&defined_groups=1&dependson=&description=&flag_type-1=X&flag_type-11=X&flag_type-12=X&flag_type-13=X&flag_type-14=X&flag_type-15=X&flag_type-16=X&flag_type-2=X&flag_type-4=X&flag_type-6=X&flag_type-7=X&flag_type-8=X&form_name=enter_bug&keywords=&maketemplate=Remember%20values%20as%20bookmarkable%20template&op_sys=Linux&product=Platform&qa_contact=&rep_platform=PC&requestee_type-1=&requestee_type-2=&short_desc=&version=4.7");
                e.printStackTrace();
            }
        }

        static void connectSignal(int WebKitUserContentManager, int webView) {
            OS.g_signal_connect(WebKitUserContentManager, Converter.wcsToMbcs(Signal, true), callback.getAddress(), webView);
            WebKitGTK.webkit_user_content_manager_register_script_message_handler(WebKitUserContentManager, Converter.wcsToMbcs(JavaScriptFunctionName, true));
        }
    }

    private static class Webkit2JavascriptEvaluator {
        private static Callback callback = new Callback(Webkit2JavascriptEvaluator.class, "javascriptExecutionFinishedProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});

        static {
            if (callback.getAddress() == 0) {
                SWT.error(3);
            }
        }

        private Webkit2JavascriptEvaluator() {
        }

        static Object evaluate(String script, Browser browser, int webView, boolean doNotBlock) {
            String swtUniqueExecFunc = "SWTWebkit2TempFunc" + CallBackMap.getNextId() + "()";
            String wrappedScript = "function " + swtUniqueExecFunc + "{" + script + "}; " + swtUniqueExecFunc;
            if (doNotBlock) {
                WebKitGTK.webkit_web_view_run_javascript(webView, Converter.wcsToMbcs(wrappedScript, true), 0, 0, 0);
                return null;
            }
            Webkit2EvalReturnObj retObj = new Webkit2EvalReturnObj();
            int callbackId = CallBackMap.putObject(retObj);
            WebKitGTK.webkit_web_view_run_javascript(webView, Converter.wcsToMbcs(wrappedScript, true), 0, callback.getAddress(), callbackId);
            Shell shell = browser.getShell();
            Display display = browser.getDisplay();
            while (!shell.isDisposed()) {
                boolean eventsDispatched = OS.g_main_context_iteration(0, false);
                if (retObj.callbackFinished) break;
                if (eventsDispatched) continue;
                display.sleep();
            }
            CallBackMap.removeObject(callbackId);
            if (retObj.errorNum != 0) {
                throw new SWTException(retObj.errorNum, String.valueOf(retObj.errorMsg) + "\nScript that was evaluated:\n" + wrappedScript);
            }
            return retObj.returnValue;
        }

        private static void javascriptExecutionFinishedProc(int GObject_source, int GAsyncResult, int user_data) {
            int callbackId = user_data;
            Webkit2EvalReturnObj retObj = CallBackMap.getObj(callbackId);
            int[] gerror = new int[1];
            int js_result = WebKitGTK.webkit_web_view_run_javascript_finish(GObject_source, GAsyncResult, gerror);
            if (js_result == 0) {
                int errMsg = OS.g_error_get_message(gerror[0]);
                String msg = Converter.cCharPtrToJavaString(errMsg, false);
                OS.g_error_free(gerror[0]);
                retObj.errorNum = 50;
                retObj.errorMsg = msg != null ? msg : "";
            } else {
                int context = WebKitGTK.webkit_javascript_result_get_global_context(js_result);
                int value = WebKitGTK.webkit_javascript_result_get_value(js_result);
                try {
                    retObj.returnValue = WebKit.convertToJava(context, value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    retObj.errorNum = 51;
                    retObj.errorMsg = "Type of return value not is not valid. For supported types see: Browser.evaluate() JavaDoc";
                }
                WebKitGTK.webkit_javascript_result_unref(js_result);
            }
            retObj.callbackFinished = true;
            Display.getCurrent().wake();
        }

        private static class CallBackMap {
            private static HashMap<Integer, Webkit2EvalReturnObj> callbackMap = new HashMap();
            private static int nextCallbackId = 1;
            private static HashSet<Integer> usedCallbackIds = new HashSet();

            private CallBackMap() {
            }

            static int putObject(Webkit2EvalReturnObj obj) {
                int id = CallBackMap.getNextId();
                callbackMap.put(id, obj);
                return id;
            }

            static Webkit2EvalReturnObj getObj(int id) {
                return callbackMap.get(id);
            }

            static void removeObject(int id) {
                callbackMap.remove(id);
                CallBackMap.removeId(id);
            }

            static int getNextId() {
                int value = 0;
                boolean unique = false;
                while (!unique) {
                    value = nextCallbackId;
                    boolean bl = unique = !usedCallbackIds.contains(value);
                    if (nextCallbackId != Integer.MAX_VALUE) {
                        ++nextCallbackId;
                        continue;
                    }
                    nextCallbackId = 1;
                }
                usedCallbackIds.add(value);
                return value;
            }

            private static void removeId(int id) {
                usedCallbackIds.remove(id);
            }
        }

        private static class Webkit2EvalReturnObj {
            boolean callbackFinished = false;
            Object returnValue;
            int errorNum = 0;
            String errorMsg;

            private Webkit2EvalReturnObj() {
            }
        }
    }
}

