/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Trigger implements Enumerator
{
    BOOTSTRAP(0, "BOOTSTRAP", "BOOTSTRAP"),
    STARTUP(1, "STARTUP", "STARTUP"),
    MANUAL(2, "MANUAL", "MANUAL");

    public static final int BOOTSTRAP_VALUE = 0;
    public static final int STARTUP_VALUE = 1;
    public static final int MANUAL_VALUE = 2;
    private static final Trigger[] VALUES_ARRAY;
    public static final List<Trigger> VALUES;
    private final int value;
    private final String name;
    private final String literal;
    private static final Map<Set<Trigger>, Set<Trigger>> CANONICAL_TRIGGER_SETS;
    public static final Map<Set<Trigger>, String> LITERALS;
    public static final Set<Trigger> ALL_TRIGGERS;
    public static final Set<Trigger> IDE_TRIGGERS;

    static {
        VALUES_ARRAY = new Trigger[]{BOOTSTRAP, STARTUP, MANUAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
        CANONICAL_TRIGGER_SETS = new HashMap<Set<Trigger>, Set<Trigger>>();
        LinkedHashMap<Set<Trigger>, String> literals = new LinkedHashMap<Set<Trigger>, String>();
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                int k = 0;
                while (k < 2) {
                    Set<Trigger> value = new LinkedHashSet<Trigger>(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public String toString() {
                            StringBuilder result = new StringBuilder();
                            for (Trigger trigger : this) {
                                if (result.length() != 0) {
                                    result.append(' ');
                                }
                                result.append((Object)trigger);
                            }
                            return result.toString();
                        }
                    };
                    if (i == 1) {
                        value.add(BOOTSTRAP);
                    }
                    if (j == 1) {
                        value.add(STARTUP);
                    }
                    if (k == 1) {
                        value.add(MANUAL);
                    }
                    value = Collections.unmodifiableSet(value);
                    literals.put(value, value.toString());
                    CANONICAL_TRIGGER_SETS.put(value, value);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        LITERALS = Collections.unmodifiableMap(literals);
        ALL_TRIGGERS = Trigger.toSet(Trigger.values());
        IDE_TRIGGERS = Trigger.toSet(STARTUP, MANUAL);
    }

    public static Trigger get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Trigger result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Trigger getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Trigger result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Trigger get(int value) {
        switch (value) {
            case 0: {
                return BOOTSTRAP;
            }
            case 1: {
                return STARTUP;
            }
            case 2: {
                return MANUAL;
            }
        }
        return null;
    }

    private Trigger(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static Set<Trigger> toSet(Trigger ... triggers) {
        return Trigger.intern(new HashSet<Trigger>(Arrays.asList(triggers)));
    }

    public static Set<Trigger> intern(Set<Trigger> triggerSet) {
        return CANONICAL_TRIGGER_SETS.get(triggerSet);
    }
}

