/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFBasePackageImpl.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;


import org.eclipse.eodm.impl.EODMImplPackage;
import org.eclipse.eodm.impl.EODMImplPackageImpl;
import org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl;
import org.eclipse.eodm.owl.owlbase.util.OWLBasePackage;
import org.eclipse.eodm.rdf.rdfbase.BlankNode;
import org.eclipse.eodm.rdf.rdfbase.PlainLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFProperty;
import org.eclipse.eodm.rdf.rdfbase.RDFSLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.RDFStatement;
import org.eclipse.eodm.rdf.rdfbase.RDFXMLLiteral;
import org.eclipse.eodm.rdf.rdfbase.TypedLiteral;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfbase.URIReferenceNode;
import org.eclipse.eodm.rdf.rdfbase.UniformResourceIdentifier;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBaseFactory;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfs.impl.RDFSPackageImpl;
import org.eclipse.eodm.rdf.rdfs.util.RDFSPackage;
import org.eclipse.eodm.rdf.rdfweb.impl.RDFWebPackageImpl;
import org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage;








/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class RDFBasePackageImpl extends EPackageImpl implements RDFBasePackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass blankNodeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rdfsResourceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rdfPropertyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass plainLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rdfsLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass uriReferenceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rdfStatementEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass uniformResourceIdentifierEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass graphEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass uriReferenceNodeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass typedLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rdfxmlLiteralEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private RDFBasePackageImpl() {
		super(eNS_URI, RDFBaseFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static RDFBasePackage init() {
		if (isInited) return (RDFBasePackage)EPackage.Registry.INSTANCE.getEPackage(RDFBasePackage.eNS_URI);

		// Obtain or create and register package
		RDFBasePackageImpl therdfbasePackage = (RDFBasePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(eNS_URI) instanceof RDFBasePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(eNS_URI) : new RDFBasePackageImpl());

		isInited = true;

		// Obtain or create and register interdependencies
		EODMImplPackageImpl theeodm2Package = (EODMImplPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(EODMImplPackage.eNS_URI) instanceof EODMImplPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(EODMImplPackage.eNS_URI) : EODMImplPackage.eINSTANCE);
		RDFWebPackageImpl therdfwebPackage = (RDFWebPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(RDFWebPackage.eNS_URI) instanceof RDFWebPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(RDFWebPackage.eNS_URI) : RDFWebPackage.eINSTANCE);
		RDFSPackageImpl therdfsPackage = (RDFSPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(RDFSPackage.eNS_URI) instanceof RDFSPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(RDFSPackage.eNS_URI) : RDFSPackage.eINSTANCE);
		OWLBasePackageImpl theowlbasePackage = (OWLBasePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(OWLBasePackage.eNS_URI) instanceof OWLBasePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(OWLBasePackage.eNS_URI) : OWLBasePackage.eINSTANCE);

		// Create package meta-data objects
		therdfbasePackage.createPackageContents();
		theeodm2Package.createPackageContents();
		therdfwebPackage.createPackageContents();
		therdfsPackage.createPackageContents();
		theowlbasePackage.createPackageContents();

		// Initialize created meta-data
		therdfbasePackage.initializePackageContents();
		theeodm2Package.initializePackageContents();
		therdfwebPackage.initializePackageContents();
		therdfsPackage.initializePackageContents();
		theowlbasePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		therdfbasePackage.freeze();

		return therdfbasePackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBlankNode() {
		return blankNodeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRDFSResource() {
		return rdfsResourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFSResource_RDFSisDefinedBy() {
		return (EReference)rdfsResourceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFSResource_RDFSseeAlso() {
		return (EReference)rdfsResourceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFSResource_RDFtype() {
		return (EReference)rdfsResourceEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFSResource_RDFSmember() {
		return (EReference)rdfsResourceEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getRDFSResource_NodeID() {
		return (EAttribute)rdfsResourceEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFSResource_RDFScomment() {
		return (EReference)rdfsResourceEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFSResource_RDFSlabel() {
		return (EReference)rdfsResourceEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFSResource_UriRef() {
		return (EReference)rdfsResourceEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFSResource_SubjectStatement() {
		return (EReference)rdfsResourceEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRDFProperty() {
		return rdfPropertyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFProperty_RDFSdomain() {
		return (EReference)rdfPropertyEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFProperty_RDFSrange() {
		return (EReference)rdfPropertyEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFProperty_RDFSsubPropertyOf() {
		return (EReference)rdfPropertyEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFProperty_SubProperty() {
		return (EReference)rdfPropertyEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPlainLiteral() {
		return plainLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getPlainLiteral_Language() {
		return (EAttribute)plainLiteralEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRDFSLiteral() {
		return rdfsLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getRDFSLiteral_LexicalForm() {
		return (EAttribute)rdfsLiteralEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getURIReference() {
		return uriReferenceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getURIReference_FragmentIdentifier() {
		return (EReference)uriReferenceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getURIReference_Namespace() {
		return (EReference)uriReferenceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getURIReference_Resource() {
		return (EReference)uriReferenceEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getURIReference_ReifiedStatement() {
		return (EReference)uriReferenceEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getURIReference_Uri() {
		return (EReference)uriReferenceEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRDFStatement() {
		return rdfStatementEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFStatement_Document() {
		return (EReference)rdfStatementEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getRDFStatement_IsReifiedOnly() {
		return (EAttribute)rdfStatementEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getRDFStatement_IsReified() {
		return (EAttribute)rdfStatementEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFStatement_RDFsubject() {
		return (EReference)rdfStatementEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFStatement_RDFobject() {
		return (EReference)rdfStatementEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFStatement_RDFpredicate() {
		return (EReference)rdfStatementEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFStatement_NameForReification() {
		return (EReference)rdfStatementEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getUniformResourceIdentifier() {
		return uniformResourceIdentifierEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getUniformResourceIdentifier_Name() {
		return (EAttribute)uniformResourceIdentifierEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getGraph() {
		return graphEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getGraph_Graphstatement() {
		return (EReference)graphEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getGraph_GraphName() {
		return (EReference)graphEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getURIReferenceNode() {
		return uriReferenceNodeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTypedLiteral() {
		return typedLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTypedLiteral_DatatypeURI() {
		return (EReference)typedLiteralEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRDFXMLLiteral() {
		return rdfxmlLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFBaseFactory getrdfbaseFactory() {
		return (RDFBaseFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		blankNodeEClass = createEClass(BLANK_NODE);

		rdfsResourceEClass = createEClass(RDFS_RESOURCE);
		createEReference(rdfsResourceEClass, RDFS_RESOURCE__RDF_SIS_DEFINED_BY);
		createEReference(rdfsResourceEClass, RDFS_RESOURCE__RDF_SSEE_ALSO);
		createEReference(rdfsResourceEClass, RDFS_RESOURCE__RD_FTYPE);
		createEReference(rdfsResourceEClass, RDFS_RESOURCE__RDF_SMEMBER);
		createEAttribute(rdfsResourceEClass, RDFS_RESOURCE__NODE_ID);
		createEReference(rdfsResourceEClass, RDFS_RESOURCE__RDF_SCOMMENT);
		createEReference(rdfsResourceEClass, RDFS_RESOURCE__RDF_SLABEL);
		createEReference(rdfsResourceEClass, RDFS_RESOURCE__URI_REF);
		createEReference(rdfsResourceEClass, RDFS_RESOURCE__SUBJECT_STATEMENT);

		rdfPropertyEClass = createEClass(RDF_PROPERTY);
		createEReference(rdfPropertyEClass, RDF_PROPERTY__RDF_SDOMAIN);
		createEReference(rdfPropertyEClass, RDF_PROPERTY__RDF_SRANGE);
		createEReference(rdfPropertyEClass, RDF_PROPERTY__RDF_SSUB_PROPERTY_OF);
		createEReference(rdfPropertyEClass, RDF_PROPERTY__SUB_PROPERTY);

		plainLiteralEClass = createEClass(PLAIN_LITERAL);
		createEAttribute(plainLiteralEClass, PLAIN_LITERAL__LANGUAGE);

		rdfsLiteralEClass = createEClass(RDFS_LITERAL);
		createEAttribute(rdfsLiteralEClass, RDFS_LITERAL__LEXICAL_FORM);

		uriReferenceEClass = createEClass(URI_REFERENCE);
		createEReference(uriReferenceEClass, URI_REFERENCE__FRAGMENT_IDENTIFIER);
		createEReference(uriReferenceEClass, URI_REFERENCE__NAMESPACE);
		createEReference(uriReferenceEClass, URI_REFERENCE__RESOURCE);
		createEReference(uriReferenceEClass, URI_REFERENCE__REIFIED_STATEMENT);
		createEReference(uriReferenceEClass, URI_REFERENCE__URI);

		rdfStatementEClass = createEClass(RDF_STATEMENT);
		createEReference(rdfStatementEClass, RDF_STATEMENT__DOCUMENT);
		createEAttribute(rdfStatementEClass, RDF_STATEMENT__IS_REIFIED_ONLY);
		createEAttribute(rdfStatementEClass, RDF_STATEMENT__IS_REIFIED);
		createEReference(rdfStatementEClass, RDF_STATEMENT__RD_FSUBJECT);
		createEReference(rdfStatementEClass, RDF_STATEMENT__RD_FOBJECT);
		createEReference(rdfStatementEClass, RDF_STATEMENT__RD_FPREDICATE);
		createEReference(rdfStatementEClass, RDF_STATEMENT__NAME_FOR_REIFICATION);

		uniformResourceIdentifierEClass = createEClass(UNIFORM_RESOURCE_IDENTIFIER);
		createEAttribute(uniformResourceIdentifierEClass, UNIFORM_RESOURCE_IDENTIFIER__NAME);

		graphEClass = createEClass(RDF_GRAPH);
		createEReference(graphEClass, RDF_GRAPH__GRAPHSTATEMENT);
		createEReference(graphEClass, RDF_GRAPH__GRAPH_NAME);

		uriReferenceNodeEClass = createEClass(URI_REFERENCE_NODE);

		typedLiteralEClass = createEClass(TYPED_LITERAL);
		createEReference(typedLiteralEClass, TYPED_LITERAL__DATATYPE_URI);

		rdfxmlLiteralEClass = createEClass(RDFXML_LITERAL);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		RDFSPackageImpl therdfsPackage = (RDFSPackageImpl)EPackage.Registry.INSTANCE.getEPackage(RDFSPackage.eNS_URI);
		RDFWebPackageImpl therdfwebPackage = (RDFWebPackageImpl)EPackage.Registry.INSTANCE.getEPackage(RDFWebPackage.eNS_URI);

		// Add supertypes to classes
		blankNodeEClass.getESuperTypes().add(this.getRDFSResource());
		rdfPropertyEClass.getESuperTypes().add(this.getRDFSResource());
		plainLiteralEClass.getESuperTypes().add(this.getRDFSLiteral());
		rdfsLiteralEClass.getESuperTypes().add(this.getRDFSResource());
		rdfStatementEClass.getESuperTypes().add(this.getRDFSResource());
		uniformResourceIdentifierEClass.getESuperTypes().add(this.getURIReference());
		graphEClass.getESuperTypes().add(this.getRDFSResource());
		uriReferenceNodeEClass.getESuperTypes().add(this.getRDFSResource());
		typedLiteralEClass.getESuperTypes().add(this.getRDFSLiteral());
		rdfxmlLiteralEClass.getESuperTypes().add(this.getTypedLiteral());

		// Initialize classes and features; add operations and parameters
		initEClass(blankNodeEClass, BlankNode.class, "BlankNode", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(rdfsResourceEClass, RDFSResource.class, "RDFSResource", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRDFSResource_RDFSisDefinedBy(), this.getRDFSResource(), null, "RDFSisDefinedBy", null, 0, -1, RDFSResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFSResource_RDFSseeAlso(), this.getRDFSResource(), null, "RDFSseeAlso", null, 0, -1, RDFSResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFSResource_RDFtype(), therdfsPackage.getRDFSClass(), therdfsPackage.getRDFSClass_TypedResource(), "RDFtype", null, 0, -1, RDFSResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFSResource_RDFSmember(), this.getRDFSResource(), null, "RDFSmember", null, 0, -1, RDFSResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRDFSResource_NodeID(), ecorePackage.getEString(), "nodeID", "", 1, 1, RDFSResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFSResource_RDFScomment(), this.getPlainLiteral(), null, "RDFScomment", null, 0, -1, RDFSResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFSResource_RDFSlabel(), this.getPlainLiteral(), null, "RDFSlabel", null, 0, -1, RDFSResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFSResource_UriRef(), this.getURIReference(), this.getURIReference_Resource(), "uriRef", null, 0, -1, RDFSResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFSResource_SubjectStatement(), this.getRDFStatement(), this.getRDFStatement_RDFsubject(), "subjectStatement", null, 0, -1, RDFSResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rdfPropertyEClass, RDFProperty.class, "RDFProperty", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRDFProperty_RDFSdomain(), therdfsPackage.getRDFSClass(), therdfsPackage.getRDFSClass_PropertyForDomain(), "RDFSdomain", null, 0, -1, RDFProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFProperty_RDFSrange(), therdfsPackage.getRDFSClass(), therdfsPackage.getRDFSClass_PropertyForRange(), "RDFSrange", null, 0, -1, RDFProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFProperty_RDFSsubPropertyOf(), this.getRDFProperty(), this.getRDFProperty_SubProperty(), "RDFSsubPropertyOf", null, 0, -1, RDFProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFProperty_SubProperty(), this.getRDFProperty(), this.getRDFProperty_RDFSsubPropertyOf(), "subProperty", null, 0, -1, RDFProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(plainLiteralEClass, PlainLiteral.class, "PlainLiteral", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPlainLiteral_Language(), ecorePackage.getEString(), "language", "", 1, 1, PlainLiteral.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rdfsLiteralEClass, RDFSLiteral.class, "RDFSLiteral", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getRDFSLiteral_LexicalForm(), ecorePackage.getEString(), "lexicalForm", "", 1, 1, RDFSLiteral.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(uriReferenceEClass, URIReference.class, "URIReference", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getURIReference_FragmentIdentifier(), therdfwebPackage.getLocalName(), therdfwebPackage.getLocalName_UriRef(), "fragmentIdentifier", null, 0, 1, URIReference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getURIReference_Namespace(), therdfwebPackage.getNamespace(), null, "namespace", null, 0, 1, URIReference.class, !IS_TRANSIENT, !IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getURIReference_Resource(), this.getRDFSResource(), this.getRDFSResource_UriRef(), "resource", null, 0, 1, URIReference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getURIReference_ReifiedStatement(), this.getRDFStatement(), this.getRDFStatement_NameForReification(), "reifiedStatement", null, 0, -1, URIReference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getURIReference_Uri(), this.getUniformResourceIdentifier(), null, "uri", null, 0, 1, URIReference.class, !IS_TRANSIENT, !IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rdfStatementEClass, RDFStatement.class, "RDFStatement", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRDFStatement_Document(), therdfwebPackage.getDocument(), therdfwebPackage.getDocument_Statement(), "document", null, 0, -1, RDFStatement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRDFStatement_IsReifiedOnly(), ecorePackage.getEBoolean(), "isReifiedOnly", null, 1, 1, RDFStatement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRDFStatement_IsReified(), ecorePackage.getEBoolean(), "isReified", null, 1, 1, RDFStatement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFStatement_RDFsubject(), this.getRDFSResource(), this.getRDFSResource_SubjectStatement(), "RDFsubject", null, 0, 1, RDFStatement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFStatement_RDFobject(), this.getRDFSResource(), null, "RDFobject", null, 0, 1, RDFStatement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFStatement_RDFpredicate(), this.getRDFProperty(), null, "RDFpredicate", null, 0, 1, RDFStatement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFStatement_NameForReification(), this.getURIReference(), this.getURIReference_ReifiedStatement(), "nameForReification", null, 0, -1, RDFStatement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(uniformResourceIdentifierEClass, UniformResourceIdentifier.class, "UniformResourceIdentifier", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getUniformResourceIdentifier_Name(), ecorePackage.getEString(), "name", "", 1, 1, UniformResourceIdentifier.class, !IS_TRANSIENT, !IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(graphEClass, RDFGraph.class, "RDFGraph", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getGraph_Graphstatement(), this.getRDFStatement(), null, "graphstatement", null, 1, -1, RDFGraph.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getGraph_GraphName(), this.getURIReference(), null, "graphName", null, 0, 1, RDFGraph.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(uriReferenceNodeEClass, URIReferenceNode.class, "URIReferenceNode", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(typedLiteralEClass, TypedLiteral.class, "TypedLiteral", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getTypedLiteral_DatatypeURI(), this.getURIReference(), null, "datatypeURI", null, 1, 1, TypedLiteral.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rdfxmlLiteralEClass, RDFXMLLiteral.class, "RDFXMLLiteral", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		// Create annotations
		// keywords
		createKeywordsAnnotations();
	}

	/**
	 * Initializes the annotations for <b>keywords</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createKeywordsAnnotations() {
		String source = "keywords";		
		addAnnotation
		  (this, 
		   source, 
		   new String[] {
			 "metamodel", null
		   });
	}

} //RDFBasePackageImpl
