/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 *
 * $Id: RDFSReasonerFactoryImpl.java,v 1.1 2007/03/18 08:39:02 lzhang Exp $
 */
package org.eclipse.eodm.rdf.reasoner.impl;

import org.eclipse.eodm.rdf.reasoner.RDFSReasoner;
import org.eclipse.eodm.rdf.reasoner.RDFSReasonerFactory;


/**
 * The implementation of ReasonerFactory, through which a reasoner (inference
 * engine) can be instantiated.
 *  
 */
public class RDFSReasonerFactoryImpl implements RDFSReasonerFactory {

    /**
     * create a RDFSReasoner instance
     * 
     * @return an instances of a RDFSReasoner
     */
    public RDFSReasoner createRDFSReasoner() {
        return new RDFSReasonerImpl();
    }

}
