/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: ConjunctionLink.java,v 1.2 2007/03/18 09:06:59 lzhang Exp $
 */

package org.eclipse.eodm.owl.reasoner.structural;

public class ConjunctionLink extends NodeLink {

    public ConjunctionLink(TBox tbox) {
        super(tbox);
    }

    public ConjunctionLink(TBox tbox, CTNode source, CTNode target, int targetID) {
        super(tbox, source, target);
        setTargetID(targetID);
    }

    public void setSource(CTNode source) {
        if (this.source != source) {
            if (this.source != null) {
                this.source.conjunctionLinks.remove(this);
            }
            this.source = source;
            if (source != null) {
                source.conjunctionLinks.add(this);
            }
        }
    }

    public void setTarget(CTNode target) {
        this.target = target;
    }

    public int getTargetID() {
        return targetID;
    }

    public void setTargetID(int targetID) {
        this.targetID = targetID;
    }

    int targetID;

}
