/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.util;

import org.eclipse.emf.mint.IJavaTypeReference;
import org.eclipse.jdt.core.IJavaProject;

/**
 * Default implementation of {@link IJavaTypeReference}.
 * 
 * <p>
 * Clients may instantiate or extend this class.
 * </p>
 */
public class JavaTypeReference implements IJavaTypeReference {

	private final IJavaProject context;

	private final String typeName;

	/**
	 * Creates an instance referring to the given Java type in the given project
	 * context.
	 * 
	 * @param context
	 *            project context in which the type should be resolvable
	 * @param typeName
	 *            name of the Java type
	 */
	public JavaTypeReference(IJavaProject context, String typeName) {
		this.context = context;
		this.typeName = typeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.mint.IJavaTypeReference#getContext()
	 */
	public IJavaProject getContext() {
		return context;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.mint.IJavaTypeReference#getTypeName()
	 */
	public String getTypeName() {
		return typeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;

		if (obj == null)
			return false;

		if (getClass() != obj.getClass())
			return false;

		final JavaTypeReference other = (JavaTypeReference) obj;
		if (context == null) {
			if (other.context != null)
				return false;
		} else if (!context.equals(other.context))
			return false;

		if (typeName == null) {
			if (other.typeName != null)
				return false;
		} else if (!typeName.equals(other.typeName))
			return false;

		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((context == null) ? 0 : context.hashCode());
		result = prime * result
				+ ((typeName == null) ? 0 : typeName.hashCode());
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		final StringBuilder buf = new StringBuilder(getClass().getSimpleName())
				.append('[');
		buf.append("context=").append(context).append(';'); //$NON-NLS-1$
		buf.append("typeName=").append(typeName).append(']'); //$NON-NLS-1$
		return buf.toString();
	}
}
