/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.genmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelAdapterFactory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.mint.IItemJavaElementSource;

public class GenModelItemProviderAdapterFactory extends GenModelAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {

	protected ComposedAdapterFactory parentAdapterFactory;

	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	public GenModelItemProviderAdapterFactory() {
		supportedTypes.add(IItemJavaElementSource.class);
	}

	protected DisposableLinkedList genModelItemProviders;

	@Override
	public Adapter createGenModelAdapter() {
		if (genModelItemProviders == null)
			genModelItemProviders = new DisposableLinkedList();

		GenModelItemProvider provider = new GenModelItemProvider(this);
		genModelItemProviders.add(provider);
		return provider;
	}

	protected DisposableLinkedList genPackageItemProviders;

	public Adapter createGenPackageAdapter() {
		if (genPackageItemProviders == null)
			genPackageItemProviders = new DisposableLinkedList();

		GenPackageItemProvider provider = new GenPackageItemProvider(this);
		genPackageItemProviders.add(provider);
		return provider;
	}

	protected DisposableLinkedList genClassItemProviders;

	@Override
	public Adapter createGenClassAdapter() {
		if (genClassItemProviders == null)
			genClassItemProviders = new DisposableLinkedList();

		JavaElementItemProviderAdapter provider = new GenClassItemProvider(this);
		genClassItemProviders.add(provider);
		return provider;
	}

	protected DisposableLinkedList genFeatureItemProviders;

	@Override
	public Adapter createGenFeatureAdapter() {
		if (genFeatureItemProviders == null)
			genFeatureItemProviders = new DisposableLinkedList();

		GenFeatureItemProvider provider = new GenFeatureItemProvider(this);
		genFeatureItemProviders.add(provider);
		return provider;
	}

	protected DisposableLinkedList genEnumItemProviders;

	@Override
	public Adapter createGenEnumAdapter() {
		if (genEnumItemProviders == null)
			genEnumItemProviders = new DisposableLinkedList();

		GenEnumItemProvider provider = new GenEnumItemProvider(this);
		genEnumItemProviders.add(provider);
		return provider;
	}

	protected DisposableLinkedList genEnumLiteralItemProviders;

	@Override
	public Adapter createGenEnumLiteralAdapter() {
		if (genEnumLiteralItemProviders == null)
			genEnumLiteralItemProviders = new DisposableLinkedList();

		GenEnumLiteralItemProvider provider = new GenEnumLiteralItemProvider(
				this);
		genEnumLiteralItemProviders.add(provider);
		return provider;
	}

	protected DisposableLinkedList genDataTypeItemProviders;

	@Override
	public Adapter createGenDataTypeAdapter() {
		if (genDataTypeItemProviders == null)
			genDataTypeItemProviders = new DisposableLinkedList();

		GenDataTypeItemProvider provider = new GenDataTypeItemProvider(this);
		genDataTypeItemProviders.add(provider);
		return provider;
	}

	protected DisposableLinkedList genOperationItemProviders;

	@Override
	public Adapter createGenOperationAdapter() {
		if (genOperationItemProviders == null)
			genOperationItemProviders = new DisposableLinkedList();

		GenOperationItemProvider provider = new GenOperationItemProvider(this);
		genOperationItemProviders.add(provider);
		return provider;
	}

	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory
				.getRootAdapterFactory();
	}

	public void setParentAdapterFactory(
			ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class)
					|| (((Class<?>) type).isInstance(adapter)))
				return adapter;
		}

		return null;
	}

	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null)
			parentAdapterFactory.fireNotifyChanged(notification);
	}

	public void dispose() {
		if (genModelItemProviders != null)
			genModelItemProviders.dispose();

		if (genPackageItemProviders != null)
			genPackageItemProviders.dispose();

		if (genClassItemProviders != null)
			genClassItemProviders.dispose();

		if (genFeatureItemProviders != null)
			genFeatureItemProviders.dispose();

		if (genEnumItemProviders != null)
			genEnumItemProviders.dispose();

		if (genEnumLiteralItemProviders != null)
			genEnumLiteralItemProviders.dispose();

		if (genDataTypeItemProviders != null)
			genDataTypeItemProviders.dispose();

		if (genOperationItemProviders != null)
			genOperationItemProviders.dispose();
	}

	@SuppressWarnings("serial")
	protected static class DisposableLinkedList extends LinkedList<IDisposable>
			implements IDisposable {

		public void dispose() {
			for (IDisposable obj : this)
				obj.dispose();

			clear();
		}
	}
}
