/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.examples.general.listeners;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.examples.general.console.ConsoleUtil;
import org.eclipse.emf.validation.examples.general.internal.l10n.ValidationMessages;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ValidationEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;

public class ValidationListener
implements IValidationListener {
    private static final String PLATFORM_NEWLINE = System.getProperty("line.separator");
    private static final String VALIDATION_PROBLEMS = ValidationMessages.Validation_problems;
    private static final String VALIDATION_ROLLED_BACK = ValidationMessages.Validation_rollback;
    private static final String VALIDATION_ERROR = ValidationMessages.Validation_error;
    private static final String VALIDATION_WARNING = ValidationMessages.Validation_warn;
    private static final String VALIDATION_NOTE = ValidationMessages.Validation_note;
    public static boolean displayEvents = false;
    public static final String consoleName = ValidationMessages.Console_Name;
    private final OutputUtility outputUtility = new OutputUtility();

    public void validationOccurred(ValidationEvent event) {
        if (displayEvents) {
            MessageConsole console = ConsoleUtil.registerConsole(consoleName);
            String messages = this.getMessages(event);
            if (messages.length() > 0) {
                ConsoleUtil.println(consoleName, VALIDATION_PROBLEMS);
                ConsoleUtil.println(consoleName, messages);
            }
            ConsolePlugin.getDefault().getConsoleManager().refresh((IConsole)console);
        }
    }

    private String getMessages(ValidationEvent event) {
        StringBuffer buffer = new StringBuffer();
        this.outputUtility.appendProblems(event, buffer);
        return buffer.toString();
    }

    private static IStatus[] toStatusArray(ValidationEvent event) {
        List results = event.getValidationResults();
        return results.toArray(new IStatus[results.size()]);
    }

    private static class OutputUtility {
        private boolean hasErrors = false;
        private boolean hasProblems = false;

        private OutputUtility() {
        }

        void appendProblems(ValidationEvent event, StringBuffer output) {
            this.hasProblems = false;
            this.hasErrors = false;
            this.appendProblemsRecursive(ValidationListener.toStatusArray(event), output);
            if (this.hasErrors()) {
                output.append(VALIDATION_ROLLED_BACK);
                output.append(PLATFORM_NEWLINE);
            }
        }

        boolean hasErrors() {
            return this.hasErrors;
        }

        boolean hasProblems() {
            return this.hasProblems;
        }

        private void appendProblemsRecursive(IStatus[] statuses, StringBuffer output) {
            IStatus[] iStatusArray = statuses;
            int n = statuses.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus next = iStatusArray[n2];
                if (!next.isOK()) {
                    String messagePattern;
                    switch (next.getSeverity()) {
                        case 4: {
                            this.hasProblems = true;
                            this.hasErrors = true;
                            messagePattern = VALIDATION_ERROR;
                            break;
                        }
                        case 2: {
                            this.hasProblems = true;
                            messagePattern = VALIDATION_WARNING;
                            break;
                        }
                        default: {
                            messagePattern = VALIDATION_NOTE;
                        }
                    }
                    output.append(NLS.bind((String)messagePattern, (Object[])new Object[]{next.getMessage()}));
                    output.append(PLATFORM_NEWLINE);
                }
                if (next.isMultiStatus()) {
                    this.appendProblemsRecursive(next.getChildren(), output);
                }
                ++n2;
            }
        }
    }
}

