/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.apps.petstore.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.apps.petstore.model.Category;
import org.eclipse.microprofile.openapi.apps.petstore.model.Pet;
import org.eclipse.microprofile.openapi.apps.petstore.model.Tag;

public class PetData {
    private static List<Pet> pets = new ArrayList<Pet>();
    private static List<Category> categories = new ArrayList<Category>();

    public Pet getPetById(long petId) {
        for (Pet pet : pets) {
            if (pet.getId() != petId) continue;
            return pet;
        }
        return null;
    }

    public boolean deletePet(long petId) {
        if (pets.size() > 0) {
            for (int i = pets.size() - 1; i >= 0; --i) {
                Pet pet = pets.get(i);
                if (pet.getId() != petId) continue;
                pets.remove(i);
                return true;
            }
        }
        return false;
    }

    public List<Pet> findPetByStatus(String status) {
        ArrayList<Pet> result = new ArrayList<Pet>();
        if (status == null) {
            return result;
        }
        String[] statuses = status.split(",");
        for (Pet pet : pets) {
            for (String s : statuses) {
                if (!s.equals(pet.getStatus())) continue;
                result.add(pet);
            }
        }
        return result;
    }

    public List<Pet> findPetByTags(String tags) {
        String[] tagList = tags.split(",");
        ArrayList<Pet> result = new ArrayList<Pet>();
        for (Pet pet : pets) {
            if (null == pet.getTags()) continue;
            for (Tag tag : pet.getTags()) {
                for (String tagListString : tagList) {
                    if (!tagListString.equals(tag.getName())) continue;
                    result.add(pet);
                }
            }
        }
        return result;
    }

    public Pet addPet(Pet pet) {
        if (pet.getId() == 0L) {
            long maxId = 0L;
            for (int i = pets.size() - 1; i >= 0; --i) {
                if (pets.get(i).getId() <= maxId) continue;
                maxId = pets.get(i).getId();
            }
            pet.setId(maxId + 1L);
        }
        if (pets.size() > 0) {
            for (int i = pets.size() - 1; i >= 0; --i) {
                if (pets.get(i).getId() != pet.getId()) continue;
                pets.remove(i);
            }
        }
        pets.add(pet);
        return pet;
    }

    public Map<String, Integer> getInventoryByStatus() {
        HashMap<String, Integer> output = new HashMap<String, Integer>();
        for (Pet pet : pets) {
            String status = pet.getStatus();
            if (status == null || "".equals(status)) continue;
            Integer count = (Integer)output.get(status);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            output.put(status, count);
        }
        return output;
    }

    static Pet createPet(long id, Category cat, String name, String[] urls, String[] tags, String status) {
        Pet pet = new Pet();
        pet.setId(id);
        pet.setCategory(cat);
        pet.setName(name);
        if (null != urls) {
            ArrayList<String> urlObjs = new ArrayList<String>();
            for (String urlString : urls) {
                urlObjs.add(urlString);
            }
            pet.setPhotoUrls(urlObjs);
        }
        ArrayList<Tag> tagObjs = new ArrayList<Tag>();
        int i = 0;
        if (null != tags) {
            for (String tagString : tags) {
                Tag tag = new Tag();
                tag.setId(++i);
                tag.setName(tagString);
                tagObjs.add(tag);
            }
        }
        pet.setTags(tagObjs);
        pet.setStatus(status);
        return pet;
    }

    static Category createCategory(long id, String name) {
        Category category = new Category();
        category.setId(id);
        category.setName(name);
        return category;
    }

    static {
        categories.add(PetData.createCategory(1L, "Dogs"));
        categories.add(PetData.createCategory(2L, "Cats"));
        categories.add(PetData.createCategory(3L, "Rabbits"));
        categories.add(PetData.createCategory(4L, "Lions"));
        pets.add(PetData.createPet(1L, categories.get(1), "Cat 1", new String[]{"url1", "url2"}, new String[]{"tag1", "tag2"}, "available"));
        pets.add(PetData.createPet(2L, categories.get(1), "Cat 2", new String[]{"url1", "url2"}, new String[]{"tag2", "tag3"}, "available"));
        pets.add(PetData.createPet(3L, categories.get(1), "Cat 3", new String[]{"url1", "url2"}, new String[]{"tag3", "tag4"}, "pending"));
        pets.add(PetData.createPet(4L, categories.get(0), "Dog 1", new String[]{"url1", "url2"}, new String[]{"tag1", "tag2"}, "available"));
        pets.add(PetData.createPet(5L, categories.get(0), "Dog 2", new String[]{"url1", "url2"}, new String[]{"tag2", "tag3"}, "sold"));
        pets.add(PetData.createPet(6L, categories.get(0), "Dog 3", new String[]{"url1", "url2"}, new String[]{"tag3", "tag4"}, "pending"));
        pets.add(PetData.createPet(7L, categories.get(3), "Lion 1", new String[]{"url1", "url2"}, new String[]{"tag1", "tag2"}, "available"));
        pets.add(PetData.createPet(8L, categories.get(3), "Lion 2", new String[]{"url1", "url2"}, new String[]{"tag2", "tag3"}, "available"));
        pets.add(PetData.createPet(9L, categories.get(3), "Lion 3", new String[]{"url1", "url2"}, new String[]{"tag3", "tag4"}, "available"));
        pets.add(PetData.createPet(10L, categories.get(2), "Rabbit 1", new String[]{"url1", "url2"}, new String[]{"tag3", "tag4"}, "available"));
    }
}

