/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.apps.airlines.resources.bookings;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.callbacks.Callback;
import org.eclipse.microprofile.openapi.annotations.callbacks.CallbackOperation;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterIn;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterStyle;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.enums.SecuritySchemeType;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameters;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.annotations.security.SecurityScheme;
import org.eclipse.microprofile.openapi.annotations.servers.Server;
import org.eclipse.microprofile.openapi.annotations.servers.Servers;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.eclipse.microprofile.openapi.annotations.tags.Tags;
import org.eclipse.microprofile.openapi.apps.airlines.model.Booking;

@Path(value="/bookings")
@Tag(ref="Bookings")
@Tags(value={@Tag(name="Reservations", description="All the reservation methods")})
@SecurityScheme(securitySchemeName="bookingSecurityScheme", type=SecuritySchemeType.OPENIDCONNECT, description="Security Scheme for booking resource", openIdConnectUrl="http://openidconnect.com/testurl")
@Servers(value={@Server(description="Secure server", url="https://gigantic-server.com:443"), @Server(description="Unsecure server", url="http://gigantic-server.com:80")})
public class BookingResource {
    private Map<Integer, Booking> bookings = new ConcurrentHashMap<Integer, Booking>();
    private volatile int currentId = 0;

    @GET
    @Tag(ref="bookings")
    @APIResponses(value={@APIResponse(responseCode="200", description="Bookings retrieved", content={@Content(schema=@Schema(type=SchemaType.ARRAY, implementation=Booking.class))}), @APIResponse(responseCode="404", description="No bookings found for the user.")})
    @Operation(summary="Retrieve all bookings for current user", operationId="getAllBookings")
    @Produces(value={"application/json"})
    public Response getBookings() {
        return Response.ok().entity(this.bookings.values()).build();
    }

    @POST
    @SecurityRequirement(name="bookingSecurityScheme", scopes={"write:bookings", "read:bookings"})
    @Callback(name="bookingCallback", callbackUrlExpression="http://localhost:9080/airlines/bookings", operations={@CallbackOperation(method="get", summary="Retrieve all bookings for current user", responses={@APIResponse(responseCode="200", description="Bookings retrieved", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.ARRAY, implementation=Booking.class))}), @APIResponse(responseCode="404", description="No bookings found for the user.")})})
    @APIResponse(responseCode="201", description="Booking created", content={@Content(schema=@Schema(name="id", description="id of the new booking", type=SchemaType.STRING))})
    @Operation(summary="Create a booking", description="Create a new booking record with the booking information provided.", operationId="createBooking")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createBooking(@RequestBody(description="Create a new booking with the provided information.", content={@Content(mediaType="application/json", schema=@Schema(ref="Booking"), examples={@ExampleObject(name="booking", summary="External booking example", externalValue="http://foo.bar/examples/booking-example.json")})}, extensions={@Extension(name="x-request-body", value="test-request-body")}) Booking task) {
        this.bookings.put(this.currentId, task);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)("{\"id\":" + this.currentId++ + "}")).build();
    }

    @GET
    @Path(value="{id}")
    @Parameters(value={@Parameter(name="id", description="ID of the booking", required=true, in=ParameterIn.PATH, style=ParameterStyle.SIMPLE)})
    @Produces(value={"application/json"})
    @Operation(summary="Get a booking with ID", operationId="getBookingById")
    @APIResponses(value={@APIResponse(responseCode="200", description="Booking retrieved", content={@Content(schema=@Schema(implementation=Booking.class))}), @APIResponse(responseCode="404", description="Booking not found")})
    public Response getBooking(@PathParam(value="id") int id) {
        Booking booking = this.bookings.get(id);
        if (booking != null) {
            return Response.ok().entity((Object)booking).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @APIResponses(value={@APIResponse(responseCode="200", description="Booking updated"), @APIResponse(responseCode="404", description="Booking not found")})
    @Operation(summary="Update a booking with ID", operationId="updateBookingId")
    public Response updateBooking(@PathParam(value="id") int id, Booking booking) {
        if (this.bookings.get(id) != null) {
            this.bookings.put(id, booking);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @DELETE
    @Path(value="{id}")
    @Tag
    @APIResponses(value={@APIResponse(responseCode="200", description="Booking deleted successfully."), @APIResponse(responseCode="404", description="Booking not found.")})
    @Operation(summary="Delete a booking with ID", operationId="deleteBookingById")
    @Produces(value={"text/plain"})
    public Response deleteBooking(@PathParam(value="id") int id) {
        if (this.bookings.get(id) != null) {
            this.bookings.remove(id);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

