/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.commands;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.vagrant.ui.commands.BaseBoxesCommandHandler;
import org.eclipse.linuxtools.internal.vagrant.ui.commands.Messages;
import org.eclipse.linuxtools.vagrant.core.IVagrantBox;
import org.eclipse.linuxtools.vagrant.core.IVagrantConnection;
import org.eclipse.linuxtools.vagrant.core.VagrantException;
import org.eclipse.linuxtools.vagrant.core.VagrantService;

public class RemoveBoxesCommandHandler
extends BaseBoxesCommandHandler {
    @Override
    String getJobName(List<IVagrantBox> selectedImages) {
        return Messages.RemoveBoxesCommandHandler_removing_title;
    }

    @Override
    String getTaskName(IVagrantBox image) {
        return Messages.RemoveBoxesCommandHandler_removing_msg + image.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeInJob(IVagrantBox image, IProgressMonitor monitor) {
        IVagrantConnection connection = VagrantService.getInstance();
        try {
            connection.removeBox(image.getName());
        }
        catch (InterruptedException | VagrantException e) {
            String errorMessage = Messages.RemoveBoxesCommandHandler_error + image.getName();
            this.openError(errorMessage, (Exception)e);
        }
        finally {
            connection.getBoxes(true);
        }
    }
}

