/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.views;

import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.BrowserViewAction;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.RefreshHandler;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.handlers.CollapseAllHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public abstract class BrowserView
extends ViewPart {
    protected TreeViewer viewer;
    protected BrowserViewAction doubleClickAction;
    private CollapseAllHandler collapseHandler;
    private RefreshHandler refreshHandler;

    protected abstract Image getEntryImage(TreeNode var1);

    public void createPartControl(Composite parent) {
        PatternFilter filter = new PatternFilter();
        FilteredTree filteredTree = new FilteredTree(parent, 770, filter, true, true);
        this.viewer = filteredTree.getViewer();
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.collapseHandler = new CollapseAllHandler((AbstractTreeViewer)this.getViewer());
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)this.collapseHandler);
        this.refreshHandler = new RefreshHandler();
        handlerService.activateHandler("org.eclipse.linuxtools.systemtap.ui.ide.refreshView", (IHandler)this.refreshHandler);
    }

    abstract void makeActions();

    protected void registerContextMenu(String menuName) {
        Control control = this.viewer.getControl();
        MenuManager manager = new MenuManager(menuName);
        manager.add((IContributionItem)new Separator("additions"));
        Menu menu = manager.createContextMenu(control);
        this.viewer.getControl().setMenu(menu);
        IWorkbenchPartSite partSite = this.getSite();
        partSite.registerContextMenu(manager, (ISelectionProvider)this.viewer);
        partSite.setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.collapseHandler != null) {
            this.collapseHandler.dispose();
            this.collapseHandler = null;
        }
        if (this.refreshHandler != null) {
            this.refreshHandler.dispose();
            this.refreshHandler = null;
        }
        if (this.viewer != null) {
            if (this.doubleClickAction != null) {
                this.viewer.removeDoubleClickListener((IDoubleClickListener)this.doubleClickAction);
            }
            this.viewer = null;
        }
        if (this.doubleClickAction != null) {
            this.doubleClickAction.dispose();
            this.doubleClickAction = null;
        }
    }

    abstract void refresh();

    protected void displayLoadingMessage() {
        this.displayMessage(Localization.getString("BrowserView.Loading"));
    }

    protected void displayMessage(String message) {
        TreeNode tree = new TreeNode(null, false);
        tree.add(new TreeNode((Object)message, false));
        this.setViewerInput(tree);
    }

    protected void setViewerInput(Object input) {
        if (this.viewer != null) {
            this.viewer.getControl().getDisplay().asyncExec(() -> this.viewer.setInput(input));
        }
    }

    protected void setRefreshable(boolean state) {
        if (this.refreshHandler != null) {
            this.refreshHandler.setActive(state);
        }
    }

    static class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getChildren(Object par) {
            TreeNode parent = (TreeNode)par;
            Object[] children = new Object[parent.getChildCount()];
            for (int i = 0; i < children.length; ++i) {
                children[i] = parent.getChildAt(i);
            }
            return children;
        }

        public boolean hasChildren(Object parent) {
            return ((TreeNode)parent).getChildCount() > 0;
        }
    }

    protected class ViewLabelProvider
    extends LabelProvider {
        protected ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            TreeNode treeObj = (TreeNode)obj;
            if (treeObj.toString().equals(Localization.getString("BrowserView.Loading")) || treeObj.toString().equals(Localization.getString("BrowserView.TryRefresh"))) {
                return null;
            }
            return BrowserView.this.getEntryImage(treeObj);
        }
    }
}

