/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.remotese.pluginse;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.eclipse.keyple.plugin.remotese.pluginse.RemoteSePlugin;
import org.eclipse.keyple.plugin.remotese.pluginse.VirtualReader;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethodExecutor;
import org.eclipse.keyple.plugin.remotese.transport.DtoSender;
import org.eclipse.keyple.plugin.remotese.transport.KeypleDtoHelper;
import org.eclipse.keyple.plugin.remotese.transport.model.KeypleDto;
import org.eclipse.keyple.plugin.remotese.transport.model.TransportDto;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmConnectReaderExecutor
implements RemoteMethodExecutor {
    private static final Logger logger = LoggerFactory.getLogger(RmConnectReaderExecutor.class);
    private final RemoteSePlugin plugin;
    private final DtoSender dtoSender;

    public RmConnectReaderExecutor(RemoteSePlugin plugin, DtoSender dtoSender) {
        this.plugin = plugin;
        this.dtoSender = dtoSender;
    }

    @Override
    public TransportDto execute(TransportDto transportDto) {
        KeypleDto keypleDto = transportDto.getKeypleDTO();
        String nativeReaderName = keypleDto.getNativeReaderName();
        String clientNodeId = keypleDto.getNodeId();
        VirtualReader virtualReader = null;
        try {
            virtualReader = (VirtualReader)this.plugin.createVirtualReader(clientNodeId, nativeReaderName, this.dtoSender);
            JsonObject respBody = new JsonObject();
            respBody.add("statusCode", (JsonElement)new JsonPrimitive((Number)0));
            respBody.add("sessionId", (JsonElement)new JsonPrimitive(virtualReader.getSession().getSessionId()));
            return transportDto.nextTransportDTO(new KeypleDto(keypleDto.getAction(), respBody.toString(), false, virtualReader.getSession().getSessionId(), nativeReaderName, virtualReader.getName(), clientNodeId));
        }
        catch (KeypleReaderException e) {
            logger.warn("Virtual reader already exists for reader " + nativeReaderName, (Throwable)e);
            return transportDto.nextTransportDTO(KeypleDtoHelper.ExceptionDTO(keypleDto.getAction(), e, null, nativeReaderName, null, clientNodeId));
        }
    }
}

