/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.remotese.nativese.method;

import com.google.gson.JsonObject;
import org.eclipse.keyple.plugin.remotese.exception.KeypleRemoteException;
import org.eclipse.keyple.plugin.remotese.nativese.NativeReaderService;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethod;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethodTx;
import org.eclipse.keyple.plugin.remotese.transport.KeypleDtoHelper;
import org.eclipse.keyple.plugin.remotese.transport.json.JsonParser;
import org.eclipse.keyple.plugin.remotese.transport.model.KeypleDto;
import org.eclipse.keyple.seproxy.event.ObservableReader;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.exception.KeypleReaderNotFoundException;
import org.eclipse.keyple.seproxy.message.ProxyReader;
import org.eclipse.keyple.seproxy.plugin.AbstractSelectionLocalReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmConnectReaderTx
extends RemoteMethodTx<String> {
    private final ProxyReader localReader;
    private final String clientNodeId;
    private final NativeReaderService nativeReaderService;
    private static final Logger logger = LoggerFactory.getLogger(RmConnectReaderTx.class);

    public RmConnectReaderTx(String sessionId, String nativeReaderName, String virtualReaderName, String clientNodeId, ProxyReader localReader, String clientNodeId1, NativeReaderService nativeReaderService) {
        super(sessionId, nativeReaderName, virtualReaderName, clientNodeId);
        this.localReader = localReader;
        this.clientNodeId = clientNodeId1;
        this.nativeReaderService = nativeReaderService;
    }

    @Override
    public String parseResponse(KeypleDto keypleDto) throws KeypleRemoteException {
        String nativeReaderName = keypleDto.getNativeReaderName();
        if (KeypleDtoHelper.containsException(keypleDto).booleanValue()) {
            logger.trace("KeypleDto contains an exception: {}", (Object)keypleDto);
            KeypleReaderException ex = (KeypleReaderException)JsonParser.getGson().fromJson(keypleDto.getBody(), KeypleReaderException.class);
            throw new KeypleRemoteException("An exception occurs while calling the remote method connecReader", (Throwable)ex);
        }
        try {
            ProxyReader localReader = (ProxyReader)this.nativeReaderService.findLocalReader(nativeReaderName);
            if (localReader instanceof AbstractSelectionLocalReader) {
                logger.debug("Register NativeReaderService as an observer for native reader {}", (Object)localReader.getName());
                ((AbstractSelectionLocalReader)localReader).addObserver((ObservableReader.ReaderObserver)this.nativeReaderService);
            }
            JsonObject body = (JsonObject)JsonParser.getGson().fromJson(keypleDto.getBody(), JsonObject.class);
            String sessionId = body.get("sessionId").getAsString();
            return sessionId;
        }
        catch (KeypleReaderNotFoundException e) {
            logger.warn("While receiving a confirmation of Rse connection, local reader was not found");
            throw new KeypleRemoteException("While receiving a confirmation of Rse connection, local reader was not found");
        }
    }

    @Override
    public KeypleDto dto() {
        return new KeypleDto(RemoteMethod.READER_CONNECT.getName(), "{}", true, null, this.localReader.getName(), null, this.clientNodeId);
    }
}

