/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.seproxy.message;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.keyple.util.ByteArrayUtils;

public final class ApduRequest
implements Serializable {
    static final long serialVersionUID = 877369841119873812L;
    private byte[] bytes;
    private final boolean case4;
    private final Set<Integer> successfulStatusCodes;
    private String name;

    public ApduRequest(byte[] buffer, boolean case4, Set<Integer> successfulStatusCodes) {
        this.bytes = buffer;
        this.case4 = case4;
        this.successfulStatusCodes = successfulStatusCodes;
    }

    public ApduRequest(String name, byte[] buffer, boolean case4, Set<Integer> successfulStatusCodes) {
        this(buffer, case4, successfulStatusCodes);
        this.name = name;
    }

    public ApduRequest(byte[] buffer, boolean case4) {
        this(buffer, case4, null);
    }

    public ApduRequest(String name, byte[] buffer, boolean case4) {
        this(buffer, case4, null);
        this.name = name;
    }

    public boolean isCase4() {
        return this.case4;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Integer> getSuccessfulStatusCodes() {
        return this.successfulStatusCodes;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toString() {
        StringBuilder string = new StringBuilder("ApduRequest: NAME = \"" + this.getName() + "\", RAWDATA = " + ByteArrayUtils.toHex(this.bytes));
        if (this.isCase4()) {
            string.append(", case4");
        }
        if (this.successfulStatusCodes != null) {
            string.append(", additional successful status codes = ");
            Iterator<Integer> iterator = this.successfulStatusCodes.iterator();
            while (iterator.hasNext()) {
                string.append(String.format("%04X", iterator.next()));
                if (!iterator.hasNext()) continue;
                string.append(", ");
            }
        }
        return string.toString();
    }
}

