/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.util;

import com.google.inject.Injector;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.incquery.patternlanguage.emf.IResourceSetPreparer;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.internal.XtextInjectorProvider;
import org.eclipse.incquery.runtime.util.XmiModelUtilRunningOptionEnum;
import org.eclipse.xtext.common.types.access.ClasspathTypeProviderFactory;

public class XmiModelUtil {
    public static final String XMI_OUTPUT_FOLDER = "queries";
    public static final String GLOBAL_EIQ_FILENAME = "globalEiqModel.xmi";

    public static Resource getGlobalXmiResource(XmiModelUtilRunningOptionEnum optionEnum, String bundleName) throws IncQueryException {
        return XmiModelUtil.getGlobalXmiResource(optionEnum, bundleName, null);
    }

    public static Resource getGlobalXmiResource(XmiModelUtilRunningOptionEnum optionEnum, String bundleName, IResourceSetPreparer preparer) throws IncQueryException {
        try {
            ResourceSet set = XmiModelUtil.prepareXtextResource();
            if (preparer != null) {
                preparer.prepareResourceSet(set);
            }
            URI globalXmiResourceURI = XmiModelUtil.getGlobalXmiResourceURI(optionEnum, bundleName);
            return set.getResource(globalXmiResourceURI, true);
        }
        catch (Exception ex) {
            if (ex instanceof IncQueryException) {
                throw (IncQueryException)((Object)ex);
            }
            throw new IncQueryException("An error occured while trying to load the generated patterns stored in bundle " + bundleName, "Error loading generated patterns", ex);
        }
    }

    public static ResourceSet prepareXtextResource() {
        Injector injector = XtextInjectorProvider.INSTANCE.getInjector();
        return XmiModelUtil.prepareXtextResource(injector);
    }

    public static ResourceSet prepareXtextResource(Injector injector) {
        ResourceSet set = (ResourceSet)injector.getInstance(ResourceSet.class);
        ClasspathTypeProviderFactory cptf = (ClasspathTypeProviderFactory)injector.getInstance(ClasspathTypeProviderFactory.class);
        cptf.createTypeProvider(set);
        return set;
    }

    public static URI getGlobalXmiResourceURI(XmiModelUtilRunningOptionEnum optionEnum, String bundleName) throws IncQueryException {
        URI resourceURI = XmiModelUtil.resolvePlatformURI(optionEnum, String.format("%s/%s/%s", bundleName, XMI_OUTPUT_FOLDER, GLOBAL_EIQ_FILENAME));
        if (resourceURI != null) {
            return resourceURI;
        }
        throw new IncQueryException(String.format("EMF-IncQuery pattern storage %s not found in bundle/project: %s", GLOBAL_EIQ_FILENAME, bundleName), "Missing globalEiqModel.xmi");
    }

    public static String getGlobalXmiFilePath() {
        return String.format("%s/%s", XMI_OUTPUT_FOLDER, GLOBAL_EIQ_FILENAME);
    }

    public static URI resolvePlatformURI(XmiModelUtilRunningOptionEnum optionEnum, String platformURI) {
        URI uri = XmiModelUtil.resolvePlatformResourceURI(optionEnum, platformURI);
        if (uri != null) {
            return uri;
        }
        uri = XmiModelUtil.resolvePlatformPluginURI(optionEnum, platformURI);
        if (uri != null) {
            return uri;
        }
        return null;
    }

    private static URI resolvePlatformResourceURI(XmiModelUtilRunningOptionEnum optionEnum, String platformURI) {
        URI resourceURI;
        if ((XmiModelUtilRunningOptionEnum.BOTH.equals((Object)optionEnum) || XmiModelUtilRunningOptionEnum.JUST_RESOURCE.equals((Object)optionEnum)) && URIConverter.INSTANCE.exists(resourceURI = URI.createPlatformResourceURI((String)platformURI, (boolean)true), null)) {
            return resourceURI;
        }
        return null;
    }

    private static URI resolvePlatformPluginURI(XmiModelUtilRunningOptionEnum optionEnum, String platformURI) {
        URI pluginURI;
        if ((XmiModelUtilRunningOptionEnum.BOTH.equals((Object)optionEnum) || XmiModelUtilRunningOptionEnum.JUST_PLUGIN.equals((Object)optionEnum)) && URIConverter.INSTANCE.exists(pluginURI = URI.createPlatformPluginURI((String)platformURI, (boolean)true), null)) {
            return pluginURI;
        }
        return null;
    }
}

