/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.core;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.base.api.IEStructuralFeatureProcessor;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.incquery.runtime.base.itc.igraph.IGraphObserver;

public class EMFDataSource
implements IGraphDataSource<EObject> {
    private static final long serialVersionUID = 5404152895901306358L;
    private List<IGraphObserver<EObject>> observers;
    private Set<EReference> references;
    private Set<EClass> classes;
    private NavigationHelper navigationHelper;
    private Multiset<EObject> allEObjects;

    public EMFDataSource(NavigationHelper navigationHelper, Set<EReference> references, Set<EClass> classes) {
        this.references = references;
        this.classes = classes;
        this.observers = new ArrayList<IGraphObserver<EObject>>();
        this.navigationHelper = navigationHelper;
    }

    public Set<EObject> getAllNodes() {
        return this.getAllEObjects().elementSet();
    }

    public List<EObject> getTargetNodes(EObject source) {
        ArrayList<EObject> targetNodes = new ArrayList<EObject>();
        for (EReference ref : this.references) {
            Set<EObject> referenceValues = this.navigationHelper.getReferenceValues(source, ref);
            targetNodes.addAll(referenceValues);
        }
        return targetNodes;
    }

    public void attachObserver(IGraphObserver<EObject> go) {
        this.observers.add(go);
    }

    public void detachObserver(IGraphObserver<EObject> go) {
        this.observers.remove(go);
    }

    public void notifyEdgeInserted(EObject source, EObject target) {
        this.nodeAdditionInternal(source);
        this.nodeAdditionInternal(target);
        for (IGraphObserver<EObject> o : this.observers) {
            o.edgeInserted((Object)source, (Object)target);
        }
    }

    public void notifyEdgeDeleted(EObject source, EObject target) {
        for (IGraphObserver<EObject> o : this.observers) {
            o.edgeDeleted((Object)source, (Object)target);
        }
        this.nodeRemovalInternal(source);
        this.nodeRemovalInternal(target);
    }

    public void notifyNodeInserted(EObject node) {
        this.nodeAdditionInternal(node);
    }

    public void notifyNodeDeleted(EObject node) {
        this.nodeRemovalInternal(node);
    }

    private void nodeAdditionInternal(EObject node) {
        boolean news = !this.getAllEObjects().contains((Object)node);
        this.allEObjects.add((Object)node);
        if (news) {
            for (IGraphObserver<EObject> o : this.observers) {
                o.nodeInserted((Object)node);
            }
        }
    }

    private void nodeRemovalInternal(EObject node) {
        boolean news;
        this.getAllEObjects().remove((Object)node);
        boolean bl = news = !this.allEObjects.contains((Object)node);
        if (news) {
            for (IGraphObserver<EObject> o : this.observers) {
                o.nodeDeleted((Object)node);
            }
        }
    }

    protected Multiset<EObject> getAllEObjects() {
        if (this.allEObjects == null) {
            this.allEObjects = HashMultiset.create();
            for (EClass clazz : this.classes) {
                this.allEObjects.addAll(this.navigationHelper.getAllInstances(clazz));
            }
            for (EReference ref : this.references) {
                this.navigationHelper.processAllFeatureInstances((EStructuralFeature)ref, new IEStructuralFeatureProcessor(){

                    @Override
                    public void process(EStructuralFeature feature, EObject source, Object target) {
                        EMFDataSource.this.allEObjects.add((Object)source);
                        EMFDataSource.this.allEObjects.add((Object)((EObject)target));
                    }
                });
            }
        }
        return this.allEObjects;
    }
}

