/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.validation.whitelist;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.incquery.patternlanguage.validation.whitelist.IXBasePureWhitelist;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.lib.Pure;

public class XBasePureCheckerUtil {
    @Inject
    private static Logger logger;

    public static boolean isImpureElement(JvmOperation jvmOperation) {
        IConfigurationElement[] configurationElements;
        if (!jvmOperation.getAnnotations().isEmpty()) {
            for (JvmAnnotationReference jvmAnnotationReference : jvmOperation.getAnnotations()) {
                if (!Pure.class.getSimpleName().equals(jvmAnnotationReference.getAnnotation().getSimpleName())) continue;
                return false;
            }
        }
        String qualifiedName = jvmOperation.getQualifiedName();
        qualifiedName = qualifiedName.replace("." + jvmOperation.getSimpleName(), "");
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.incquery.patternlanguage.purewhitelist");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            Object object = null;
            try {
                object = configurationElement.createExecutableExtension("whitelistClass");
            }
            catch (CoreException coreException) {
                logger.error((Object)"Whitelist extension point initialization failed.", (Throwable)coreException);
            }
            if (object instanceof IXBasePureWhitelist) {
                IXBasePureWhitelist xbasePureWhitelist = (IXBasePureWhitelist)object;
                if (xbasePureWhitelist.getWhitelistedClasses().contains(qualifiedName)) {
                    return false;
                }
                for (String whitelistedPackageName : xbasePureWhitelist.getWhitelistedPackages()) {
                    String refactoredQualifiedName;
                    if (!qualifiedName.startsWith(String.valueOf(whitelistedPackageName) + ".") || (refactoredQualifiedName = qualifiedName.replace(String.valueOf(whitelistedPackageName) + ".", "")).contains(".")) continue;
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }
}

