/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.scoping;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternCall;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.patternlanguage.scoping.MyAbstractDeclarativeScopeProvider;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;

public class PatternLanguageDeclarativeScopeProvider
extends MyAbstractDeclarativeScopeProvider {
    public IScope scope_PatternCall_patternRef(PatternCall ctx, EReference ref) {
        IScope delegateScope = this.delegateGetScope(ctx, ref);
        EObject container = EcoreUtil.getRootContainer((EObject)ctx);
        EList<Pattern> patterns = container instanceof PatternModel ? ((PatternModel)container).getPatterns() : ImmutableList.of();
        return new FilteringScope(Scopes.scopeFor(patterns, (IScope)delegateScope), (Predicate)new PrivateDescFilter());
    }

    public IScope scope_VariableReference_variable(EObject ctx, EReference ref) {
        EList<Variable> variables;
        EObject it = ctx;
        PatternBody body = null;
        while (it != null && !(it instanceof Pattern)) {
            if (it instanceof PatternBody) {
                body = (PatternBody)it;
            }
            it = it.eContainer();
        }
        CreateObjectDescFunction createObjectDescFunction = new CreateObjectDescFunction();
        if (body != null) {
            variables = body.getVariables();
        } else if (it != null) {
            Pattern pattern = (Pattern)it;
            variables = pattern.getParameters();
        } else {
            return IScope.NULLSCOPE;
        }
        UndefinedVariable variableFilter = new UndefinedVariable();
        SimpleScope localScope = new SimpleScope(IScope.NULLSCOPE, Iterables.transform((Iterable)Iterables.filter(variables, (Predicate)variableFilter), (Function)createObjectDescFunction));
        return localScope;
    }

    private static final class CreateObjectDescFunction
    implements Function<Variable, IEObjectDescription> {
        private CreateObjectDescFunction() {
        }

        public IEObjectDescription apply(Variable from) {
            return EObjectDescription.create((String)from.getName(), (EObject)from);
        }
    }

    private static final class PrivateDescFilter
    implements Predicate<IEObjectDescription> {
        private PrivateDescFilter() {
        }

        public boolean apply(IEObjectDescription input) {
            return !"true".equals(input.getUserData("private"));
        }
    }

    private static final class UndefinedVariable
    implements Predicate<Variable> {
        private UndefinedVariable() {
        }

        public boolean apply(Variable input) {
            return input.getName() != null && !input.getName().isEmpty();
        }
    }
}

