/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.context;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.base.api.IEClassifierProcessor;
import org.eclipse.incquery.runtime.base.api.IEStructuralFeatureProcessor;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.context.EMFPatternMatcherContext;
import org.eclipse.incquery.runtime.internal.BaseIndexListener;
import org.eclipse.incquery.runtime.internal.apiimpl.IncQueryEngineImpl;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.boundary.IManipulationListener;
import org.eclipse.incquery.runtime.rete.boundary.IPredicateTraceListener;
import org.eclipse.incquery.runtime.rete.eval.PredicateEvaluatorNode;
import org.eclipse.incquery.runtime.rete.matcher.IPatternMatcherRuntimeContext;
import org.eclipse.incquery.runtime.rete.matcher.ReteEngine;

public class EMFPatternMatcherRuntimeContext
extends EMFPatternMatcherContext
implements IPatternMatcherRuntimeContext {
    private final NavigationHelper baseIndex;
    private BaseIndexListener listener;
    private IncQueryEngineImpl iqEngine;

    public EMFPatternMatcherRuntimeContext(IncQueryEngineImpl iqEngine, NavigationHelper baseIndex) {
        super(iqEngine.getLogger());
        this.iqEngine = iqEngine;
        this.baseIndex = baseIndex;
    }

    public <V> V coalesceTraversals(Callable<V> callable) throws InvocationTargetException {
        return (V)this.baseIndex.coalesceTraversals(callable);
    }

    public void enumerateAllBinaryEdges(IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateAllGeneralizations(IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateAllInstantiations(IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateAllTernaryEdges(IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateAllUnaries(IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateAllUnaryContainments(IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateDirectBinaryEdgeInstances(Object typeObject, final IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        EStructuralFeature structural = (EStructuralFeature)typeObject;
        this.listener.ensure(structural);
        this.baseIndex.processAllFeatureInstances(structural, new IEStructuralFeatureProcessor(){

            public void process(EStructuralFeature feature, EObject source, Object target) {
                crawler.crawl((Object)source, target);
            }
        });
    }

    public void enumerateAllBinaryEdgeInstances(Object typeObject, IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        this.enumerateDirectBinaryEdgeInstances(typeObject, crawler);
    }

    public void enumerateDirectTernaryEdgeInstances(Object typeObject, IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateAllTernaryEdgeInstances(Object typeObject, IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateDirectUnaryInstances(Object typeObject, IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        if (typeObject instanceof EClass) {
            EClass eClass = (EClass)typeObject;
            this.listener.ensure(eClass);
            this.baseIndex.processDirectInstances(eClass, (IEClassifierProcessor.IEClassProcessor)new ClassCrawler(crawler));
        } else if (typeObject instanceof EDataType) {
            EDataType eDataType = (EDataType)typeObject;
            this.listener.ensure(eDataType);
            this.baseIndex.processDataTypeInstances(eDataType, (IEClassifierProcessor.IEDataTypeProcessor)new DataTypeCrawler(crawler));
        } else {
            throw new IllegalArgumentException("typeObject has invalid type " + typeObject.getClass().getName());
        }
    }

    public void enumerateAllUnaryInstances(Object typeObject, IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        if (typeObject instanceof EClass) {
            EClass eClass = (EClass)typeObject;
            this.listener.ensure(eClass);
            this.baseIndex.processAllInstances(eClass, (IEClassifierProcessor.IEClassProcessor)new ClassCrawler(crawler));
        } else if (typeObject instanceof EDataType) {
            EDataType eDataType = (EDataType)typeObject;
            this.listener.ensure(eDataType);
            this.baseIndex.processDataTypeInstances(eDataType, (IEClassifierProcessor.IEDataTypeProcessor)new DataTypeCrawler(crawler));
        } else {
            throw new IllegalArgumentException("typeObject has invalid type " + typeObject.getClass().getName());
        }
    }

    public void modelReadLock() {
    }

    public void modelReadUnLock() {
    }

    public IManipulationListener subscribePatternMatcherForUpdates(ReteEngine engine) {
        if (this.listener == null) {
            this.listener = new BaseIndexListener(this.iqEngine, engine, this.baseIndex);
        }
        return this.listener;
    }

    public Object ternaryEdgeSource(Object relation) {
        throw new UnsupportedOperationException();
    }

    public Object ternaryEdgeTarget(Object relation) {
        throw new UnsupportedOperationException();
    }

    public IPredicateTraceListener subscribePatternMatcherForTraceInfluences(ReteEngine engine) {
        return new IPredicateTraceListener(){

            public void registerSensitiveTrace(Tuple trace, PredicateEvaluatorNode node) {
            }

            public void unregisterSensitiveTrace(Tuple trace, PredicateEvaluatorNode node) {
            }

            public void disconnect() {
            }
        };
    }

    private final class ClassCrawler
    implements IEClassifierProcessor.IEClassProcessor {
        private final IPatternMatcherRuntimeContext.ModelElementCrawler crawler;

        private ClassCrawler(IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
            this.crawler = crawler;
        }

        public void process(EClass type, EObject instance) {
            this.crawler.crawl((Object)instance);
        }
    }

    private final class DataTypeCrawler
    implements IEClassifierProcessor.IEDataTypeProcessor {
        private final IPatternMatcherRuntimeContext.ModelElementCrawler crawler;

        private DataTypeCrawler(IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
            this.crawler = crawler;
        }

        public void process(EDataType type, Object instance) {
            this.crawler.crawl(instance);
        }
    }
}

