/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.runtime.configuration.ProfileManager;

public enum LaunchMode {
    NORMAL("prod", "quarkus.profile"),
    DEVELOPMENT("dev", "quarkus.profile"),
    TEST("test", "quarkus.test.profile");

    private final String defaultProfile;
    private final String profileKey;

    public boolean isDevOrTest() {
        return this != NORMAL;
    }

    public static boolean isRemoteDev() {
        return LaunchMode.current() == DEVELOPMENT && "true".equals(System.getenv("QUARKUS_LAUNCH_DEVMODE"));
    }

    private LaunchMode(String defaultProfile, String profileKey) {
        this.defaultProfile = defaultProfile;
        this.profileKey = profileKey;
    }

    public String getDefaultProfile() {
        return this.defaultProfile;
    }

    public String getProfileKey() {
        return this.profileKey;
    }

    public static LaunchMode current() {
        return ProfileManager.getLaunchMode();
    }
}

