/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.httpcomponents.hc5;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientContext;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationConvention;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationDocumentation;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.DefaultApacheHttpClientObservationConvention;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicMarkableReference;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.util.Args;

public class ObservationExecChainHandler
implements ExecChainHandler,
AsyncExecChainHandler {
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final ApacheHttpClientObservationConvention observationConvention;

    public ObservationExecChainHandler(ObservationRegistry observationRegistry, @Nullable ApacheHttpClientObservationConvention observationConvention) {
        this.observationRegistry = observationRegistry;
        this.observationConvention = observationConvention;
    }

    public ObservationExecChainHandler(ObservationRegistry observationRegistry) {
        this(observationRegistry, null);
    }

    public void execute(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        final ApacheHttpClientContext observationContext = new ApacheHttpClientContext(request, scope.clientContext);
        final Observation observation = ApacheHttpClientObservationDocumentation.DEFAULT.observation(this.observationConvention, DefaultApacheHttpClientObservationConvention.INSTANCE, () -> observationContext, this.observationRegistry).start();
        ObervableCancellableDependency cancellable = new ObervableCancellableDependency(observation);
        chain.proceed(request, entityProducer, cancellable.wrapScope(scope), new AsyncExecCallback(){

            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                observationContext.setResponse(response);
                observation.stop();
                return asyncExecCallback.handleResponse(response, entityDetails);
            }

            public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                asyncExecCallback.handleInformationResponse(response);
            }

            public void completed() {
                asyncExecCallback.completed();
            }

            public void failed(Exception cause) {
                observation.error(cause);
                observation.stop();
                asyncExecCallback.failed(cause);
            }
        });
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        ClassicHttpResponse response;
        ApacheHttpClientContext observationContext = new ApacheHttpClientContext((HttpRequest)request, scope.clientContext);
        Observation observation = ApacheHttpClientObservationDocumentation.DEFAULT.observation(this.observationConvention, DefaultApacheHttpClientObservationConvention.INSTANCE, () -> observationContext, this.observationRegistry).start();
        try {
            response = chain.proceed(request, scope);
            observationContext.setResponse(response);
        }
        catch (Throwable exc) {
            observation.error(exc);
            throw exc;
        }
        finally {
            observation.stop();
        }
        return response;
    }

    private static class ObervableCancellableDependency
    implements CancellableDependency {
        private final Observation observation;
        private final AtomicMarkableReference<Cancellable> dependencyRef;

        public ObervableCancellableDependency(Observation observation) {
            this.observation = observation;
            this.dependencyRef = new AtomicMarkableReference<Object>(null, false);
        }

        public boolean isCancelled() {
            return this.dependencyRef.isMarked();
        }

        public void setDependency(Cancellable dependency) {
            Args.notNull((Object)dependency, (String)"dependency");
            Cancellable actualDependency = this.dependencyRef.getReference();
            if (!this.dependencyRef.compareAndSet(actualDependency, dependency, false, false)) {
                dependency.cancel();
            }
        }

        public boolean cancel() {
            while (!this.dependencyRef.isMarked()) {
                Cancellable actualDependency = this.dependencyRef.getReference();
                if (!this.dependencyRef.compareAndSet(actualDependency, actualDependency, false, true)) continue;
                if (actualDependency != null) {
                    actualDependency.cancel();
                }
                this.observation.stop();
                return true;
            }
            this.observation.stop();
            return false;
        }

        AsyncExecChain.Scope wrapScope(AsyncExecChain.Scope scope) {
            scope.cancellableDependency.setDependency((Cancellable)this);
            return new AsyncExecChain.Scope(scope.exchangeId, scope.route, scope.originalRequest, (CancellableDependency)this, scope.clientContext, scope.execRuntime, scope.scheduler, scope.execCount);
        }
    }
}

