/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.networking.v1.IngressClassParametersReference;
import io.fabric8.kubernetes.api.model.networking.v1.IngressClassParametersReferenceBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressClassParametersReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.networking.v1.IngressClassSpec;
import io.fabric8.kubernetes.api.model.networking.v1.IngressClassSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class IngressClassSpecFluentImpl<A extends IngressClassSpecFluent<A>>
extends BaseFluent<A>
implements IngressClassSpecFluent<A> {
    private String controller;
    private IngressClassParametersReferenceBuilder parameters;
    private Map<String, Object> additionalProperties;

    public IngressClassSpecFluentImpl() {
    }

    public IngressClassSpecFluentImpl(IngressClassSpec instance) {
        this.withController(instance.getController());
        this.withParameters(instance.getParameters());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getController() {
        return this.controller;
    }

    @Override
    public A withController(String controller) {
        this.controller = controller;
        return (A)this;
    }

    @Override
    public Boolean hasController() {
        return this.controller != null;
    }

    @Override
    @Deprecated
    public IngressClassParametersReference getParameters() {
        return this.parameters != null ? this.parameters.build() : null;
    }

    @Override
    public IngressClassParametersReference buildParameters() {
        return this.parameters != null ? this.parameters.build() : null;
    }

    @Override
    public A withParameters(IngressClassParametersReference parameters) {
        this._visitables.get("parameters").remove(this.parameters);
        if (parameters != null) {
            this.parameters = new IngressClassParametersReferenceBuilder(parameters);
            this._visitables.get("parameters").add(this.parameters);
        } else {
            this.parameters = null;
            this._visitables.get("parameters").remove(this.parameters);
        }
        return (A)this;
    }

    @Override
    public Boolean hasParameters() {
        return this.parameters != null;
    }

    @Override
    public A withNewParameters(String apiGroup, String kind, String name, String namespace, String scope) {
        return this.withParameters(new IngressClassParametersReference(apiGroup, kind, name, namespace, scope));
    }

    @Override
    public IngressClassSpecFluent.ParametersNested<A> withNewParameters() {
        return new ParametersNestedImpl();
    }

    @Override
    public IngressClassSpecFluent.ParametersNested<A> withNewParametersLike(IngressClassParametersReference item) {
        return new ParametersNestedImpl(item);
    }

    @Override
    public IngressClassSpecFluent.ParametersNested<A> editParameters() {
        return this.withNewParametersLike(this.getParameters());
    }

    @Override
    public IngressClassSpecFluent.ParametersNested<A> editOrNewParameters() {
        return this.withNewParametersLike(this.getParameters() != null ? this.getParameters() : new IngressClassParametersReferenceBuilder().build());
    }

    @Override
    public IngressClassSpecFluent.ParametersNested<A> editOrNewParametersLike(IngressClassParametersReference item) {
        return this.withNewParametersLike(this.getParameters() != null ? this.getParameters() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressClassSpecFluentImpl that = (IngressClassSpecFluentImpl)o;
        if (this.controller != null ? !this.controller.equals(that.controller) : that.controller != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.controller, this.parameters, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.controller != null) {
            sb.append("controller:");
            sb.append(this.controller + ",");
        }
        if (this.parameters != null) {
            sb.append("parameters:");
            sb.append(this.parameters + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ParametersNestedImpl<N>
    extends IngressClassParametersReferenceFluentImpl<IngressClassSpecFluent.ParametersNested<N>>
    implements IngressClassSpecFluent.ParametersNested<N>,
    Nested<N> {
        IngressClassParametersReferenceBuilder builder;

        ParametersNestedImpl(IngressClassParametersReference item) {
            this.builder = new IngressClassParametersReferenceBuilder(this, item);
        }

        ParametersNestedImpl() {
            this.builder = new IngressClassParametersReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressClassSpecFluentImpl.this.withParameters(this.builder.build());
        }

        @Override
        public N endParameters() {
            return this.and();
        }
    }
}

