/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.MultiItemCombineIterable;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.tuples.Functions;
import io.smallrye.mutiny.tuples.Tuple4;
import org.reactivestreams.Publisher;

public class MultiItemCombine4<T1, T2, T3, T4>
extends MultiItemCombineIterable {
    public MultiItemCombine4(Iterable<Publisher<?>> iterable) {
        super(iterable);
    }

    @Override
    @CheckReturnValue
    public MultiItemCombine4<T1, T2, T3, T4> collectFailures() {
        super.collectFailures();
        return this;
    }

    @Override
    @CheckReturnValue
    public MultiItemCombine4<T1, T2, T3, T4> latestItems() {
        super.latestItems();
        return this;
    }

    @CheckReturnValue
    public Multi<Tuple4<T1, T2, T3, T4>> asTuple() {
        return this.using(Tuple4::of);
    }

    @CheckReturnValue
    public <O> Multi<O> using(Functions.Function4<T1, T2, T3, T4, O> combinator) {
        ParameterValidation.nonNull(combinator, "combinator");
        return super.combine(args -> {
            ParameterValidation.size(args, 4, "args");
            return combinator.apply(args.get(0), args.get(1), args.get(2), args.get(3));
        });
    }
}

