/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp.config;

import org.eclipse.hono.client.amqp.config.ClientConfigProperties;
import org.eclipse.hono.client.amqp.config.RequestResponseClientOptions;

public class RequestResponseClientConfigProperties
extends ClientConfigProperties {
    public static final int DEFAULT_RESPONSE_CACHE_MIN_SIZE = 20;
    public static final long DEFAULT_RESPONSE_CACHE_MAX_SIZE = 1000L;
    public static final long DEFAULT_RESPONSE_CACHE_TIMEOUT = 600L;
    public static final long MAX_RESPONSE_CACHE_TIMEOUT = 86400L;
    private int responseCacheMinSize = 20;
    private long responseCacheMaxSize = 1000L;
    private long responseCacheDefaultTimeout = 600L;

    public RequestResponseClientConfigProperties() {
    }

    public RequestResponseClientConfigProperties(RequestResponseClientOptions options) {
        super(options.clientOptions());
        this.setResponseCacheDefaultTimeout(options.responseCacheDefaultTimeout());
        this.setResponseCacheMaxSize(options.responseCacheMaxSize());
        this.setResponseCacheMinSize(options.responseCacheMinSize());
    }

    public final int getResponseCacheMinSize() {
        return this.responseCacheMinSize;
    }

    public final void setResponseCacheMinSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("minimum cache size must not be negative");
        }
        this.responseCacheMinSize = size;
    }

    public final long getResponseCacheMaxSize() {
        return this.responseCacheMaxSize;
    }

    public final void setResponseCacheMaxSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("maximum cache size must not be negative");
        }
        this.responseCacheMaxSize = size;
    }

    public final long getResponseCacheDefaultTimeout() {
        return this.responseCacheDefaultTimeout;
    }

    public final void setResponseCacheDefaultTimeout(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("default cache timeout must be greater than zero");
        }
        this.responseCacheDefaultTimeout = Math.min(timeout, 86400L);
    }

    public String toString() {
        return this.getClass().getName() + "[" + "host: " + this.getHost() + ", linkEstablishmentTimeout: " + this.getLinkEstablishmentTimeout() + "]";
    }
}

