/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite.timeaware;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNodeIndex;
import org.eclipse.hawk.sqlite.AbstractSQLiteDatabase;
import org.eclipse.hawk.sqlite.iteration.StatementGraphNodeIterable;
import org.eclipse.hawk.sqlite.iteration.StatementSupplier;
import org.eclipse.hawk.sqlite.timeaware.TimeAwareSQLiteDatabase;
import org.eclipse.hawk.sqlite.timeaware.TimeAwareSQLiteNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeAwareSQLiteNodeIndex
implements ITimeAwareGraphNodeIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeAwareSQLiteNodeIndex.class);
    private final TimeAwareSQLiteDatabase db;
    private final String name;
    private final long time;

    public TimeAwareSQLiteNodeIndex(TimeAwareSQLiteDatabase db, String name, long time) {
        this.db = db;
        this.name = name;
        this.time = time;
    }

    public String getName() {
        return this.name;
    }

    public IGraphIterable<? extends IGraphNode> query(String key, Object valueOrPattern) {
        if (valueOrPattern instanceof String && ((String)valueOrPattern).contains("*")) {
            String pattern = (String)valueOrPattern;
            if ("*".equals(key) && "*".equals(pattern)) {
                return new StatementGraphNodeIterable<ITimeAwareGraphNode>(() -> this.db.getQueries().getQueryIndexValueAllPairsStatement(this.name, this.time), () -> this.db.getQueries().getQueryIndexValueAllPairsCountStatement(this.name, this.time), () -> this.db.getQueries().getQueryIndexValueAllPairsSingleStatement(this.name, this.time), this::getNodeById);
            }
            if ("*".equals(pattern)) {
                return new StatementGraphNodeIterable<ITimeAwareGraphNode>(() -> this.db.getQueries().getQueryIndexValueAllValuesStatement(this.name, key, this.time), () -> this.db.getQueries().getQueryIndexValueAllValuesCountStatement(this.name, key, this.time), () -> this.db.getQueries().getQueryIndexValueAllValuesSingleStatement(this.name, key, this.time), this::getNodeById);
            }
            return new StatementGraphNodeIterable<ITimeAwareGraphNode>(() -> this.db.getQueries().getQueryIndexValuePatternStatement(this.name, key, pattern, this.time), () -> this.db.getQueries().getQueryIndexValuePatternCountStatement(this.name, key, pattern, this.time), () -> this.db.getQueries().getQueryIndexValuePatternSingleStatement(this.name, key, pattern, this.time), this::getNodeById);
        }
        return this.get(key, valueOrPattern);
    }

    public IGraphIterable<? extends IGraphNode> query(String key, Number from, Number to, boolean fromInclusive, boolean toInclusive) {
        return new StatementGraphNodeIterable<ITimeAwareGraphNode>(() -> this.db.getQueries().getQueryIndexNumberRangeStatement(this.name, key, fromInclusive, from, toInclusive, to, this.time), () -> this.db.getQueries().getQueryIndexNumberRangeCountStatement(this.name, key, fromInclusive, from, toInclusive, to, this.time), () -> this.db.getQueries().getQueryIndexNumberRangeSingleStatement(this.name, key, fromInclusive, from, toInclusive, to, this.time), this::getNodeById);
    }

    public IGraphIterable<? extends IGraphNode> get(String key, Object exactValue) {
        return new StatementGraphNodeIterable<ITimeAwareGraphNode>(() -> this.db.getQueries().getQueryIndexValueExactStatement(this.name, key, exactValue, this.time), () -> this.db.getQueries().getQueryIndexValueExactCountStatement(this.name, key, exactValue, this.time), () -> this.db.getQueries().getQueryIndexValueExactSingleStatement(this.name, key, exactValue, this.time), this::getNodeById);
    }

    public void add(IGraphNode n, String key, Object value) {
        int rowCount = this.executeUpdate(() -> this.db.getQueries().getAddNodeIndexEntryStatement(this.name, key, (Integer)n.getId(), value, this.time));
        assert (rowCount == 1) : "One row should be inserted when adding an index entry";
    }

    public void remove(IGraphNode n) {
        this.executeUpdate(() -> this.db.getQueries().getRemoveNodeFromIndexStatement(this.name, (Integer)n.getId(), this.time));
    }

    public void remove(IGraphNode n, String key, Object value) {
        if (key == null) {
            if (value == null) {
                this.remove(n);
            } else {
                this.executeUpdate(() -> this.db.getQueries().getRemoveNodeValueFromIndexStatement(this.name, (Integer)n.getId(), value, this.time));
            }
        } else if (value == null) {
            this.executeUpdate(() -> this.db.getQueries().getRemoveNodeFieldFromIndexStatement(this.name, (Integer)n.getId(), key, this.time));
        }
        this.executeUpdate(() -> this.db.getQueries().getRemoveNodeIndexEntryStatement(this.name, key, (Integer)n.getId(), value, this.time));
    }

    public void flush() {
    }

    public void delete() {
        try {
            AbstractSQLiteDatabase.SQLiteConnection conn = this.db.getConnection();
            PreparedStatement stmt = this.db.getQueries().getDeleteNodeIndexStatement(this.name);
            int rowCount = stmt.executeUpdate();
            assert (rowCount == 1) : "A row should have been deleted when deleting a node index";
            conn.getSchema().clearNodeIndexTable(this.name);
            conn.dropIndexTableOnCommit(this.name);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private int executeUpdate(StatementSupplier stmt) {
        try {
            return stmt.get().executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public ITimeAwareGraphNodeIndex travelInTime(long timepoint) {
        return new TimeAwareSQLiteNodeIndex(this.db, this.getName(), timepoint);
    }

    public List<Long> getVersions(ITimeAwareGraphNode n, String key, Object exactValue, long startTimepointIncluded) {
        ITimeAwareGraphNode sqliteNode = n;
        TimeAwareSQLiteDatabase taDB = this.db;
        try {
            PreparedStatement stmt = taDB.getQueries().getIndexVersionsStatement(this.getName(), (Integer)sqliteNode.getId(), key, exactValue, startTimepointIncluded);
            Throwable throwable = null;
            Object var10_11 = null;
            try (ResultSet rs = stmt.executeQuery();){
                ArrayList<Long> results = new ArrayList<Long>();
                while (rs.next()) {
                    long validFrom = rs.getLong(1);
                    long validTo = rs.getObject(2) == null ? Long.MAX_VALUE : rs.getLong(2) - 1L;
                    List lInstants = n.getInstantsBetween(validFrom, validTo);
                    results.addAll(lInstants);
                }
                return results;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long getEarliestVersionSince(ITimeAwareGraphNode taNode, String key, Object exactValue) {
        ITimeAwareGraphNode sqliteNode = taNode;
        TimeAwareSQLiteDatabase taDB = this.db;
        try {
            PreparedStatement stmt = taDB.getQueries().getIndexEarliestVersionSinceStatement(this.getName(), (Integer)sqliteNode.getId(), key, exactValue, sqliteNode.getTime());
            Throwable throwable = null;
            Object var8_10 = null;
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return -1L;
                long validFrom = rs.getLong(1);
                long validTo = rs.getObject(2) == null ? Long.MAX_VALUE : rs.getLong(2) - 1L;
                List lInstants = taNode.getInstantsBetween(validFrom, validTo);
                if (!lInstants.isEmpty()) return (Long)lInstants.get(lInstants.size() - 1);
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return -1L;
    }

    public void annotate(ITimeAwareGraphNode elementNode, String key) {
        this.executeUpdate(() -> this.db.getQueries().getAnnotateNodeIndexEntryStatement(this.name, key, (Integer)elementNode.getId(), true, elementNode.getTime() + 1L, elementNode.getTime()));
    }

    private ITimeAwareGraphNode getNodeById(Object id) {
        return new TimeAwareSQLiteNode(this.db, (Integer)id, this.time);
    }
}

