/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite.queries;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.hawk.sqlite.queries.IQueries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardQueries
implements IQueries {
    public static final String TYPE_BLOB_BASE64 = "blobBase64";
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardQueries.class);
    private final Connection connection;
    private PreparedStatement stmtInsertNode;
    private PreparedStatement stmtNodeIDsByLabel;
    private PreparedStatement stmtNodeCountByLabel;
    private PreparedStatement stmtFirstNodeIDByLabel;
    private PreparedStatement stmtNodePropKeys;
    private PreparedStatement stmtNodePropValue;
    private PreparedStatement stmtUpsertNodeProp;
    private PreparedStatement stmtDeleteNodeProp;
    private PreparedStatement stmtDeleteNode;
    private PreparedStatement stmtDeleteNodeProps;
    private PreparedStatement stmtInsertEdge;
    private PreparedStatement stmtDeleteEdge;
    private PreparedStatement stmtOutgoingEdgesWithType;
    private PreparedStatement stmtOutgoingEdgesWithTypeAndNode;
    private PreparedStatement stmtOutgoingEdges;
    private PreparedStatement stmtIncomingEdgesWithType;
    private PreparedStatement stmtIncomingEdges;
    private PreparedStatement stmtEdges;
    private PreparedStatement stmtEdgesWithType;
    private PreparedStatement stmtEdgePropKeys;
    private PreparedStatement stmtEdgePropValue;
    private PreparedStatement stmtUpsertEdgeProp;
    private PreparedStatement stmtDeleteEdgeProp;
    private PreparedStatement stmtDeleteEdgeProps;
    private PreparedStatement stmtDeleteEdgePropsForNode;
    private PreparedStatement stmtDeleteEdgesForNode;
    private PreparedStatement stmtUpsertNodeIndex;
    private PreparedStatement stmtDeleteNodeIndex;
    private PreparedStatement stmtAllNodeIndices;
    private Map<String, PreparedStatement> stmtAddNodeIndexEntry = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtRemoveNodeIndexEntry = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtRemoveNodeFromIndex = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtRemoveNodeFieldFromIndex = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtRemoveNodeValueFromIndex = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValuePattern = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValuePatternCount = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValuePatternSingle = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueExact = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueExactCount = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueExactSingle = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueAllValues = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueAllValuesCount = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueAllValuesSingle = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueAllPairs = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueAllPairsCount = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueAllPairsSingle = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexNumberRange = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexNumberRangeCount = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexNumberRangeSingle = new HashMap<String, PreparedStatement>();

    public StandardQueries(Connection connection) {
        this.connection = connection;
    }

    @Override
    public PreparedStatement getInsertNodeStatement(String label) throws SQLException {
        if (this.stmtInsertNode == null) {
            this.stmtInsertNode = this.connection.prepareStatement("INSERT INTO nodes (label) VALUES (?);");
        }
        this.stmtInsertNode.setString(1, label);
        return this.stmtInsertNode;
    }

    @Override
    public PreparedStatement getNodeIDsByLabelStatement(String label) throws SQLException {
        if (this.stmtNodeIDsByLabel == null) {
            this.stmtNodeIDsByLabel = this.connection.prepareStatement("SELECT rowid FROM nodes WHERE label = ?;");
        }
        this.stmtNodeIDsByLabel.setString(1, label);
        return this.stmtNodeIDsByLabel;
    }

    @Override
    public PreparedStatement getNodeCountByLabelStatement(String label) throws SQLException {
        if (this.stmtNodeCountByLabel == null) {
            this.stmtNodeCountByLabel = this.connection.prepareStatement("SELECT COUNT(1) FROM nodes WHERE label = ?;");
        }
        this.stmtNodeCountByLabel.setString(1, label);
        return this.stmtNodeCountByLabel;
    }

    @Override
    public PreparedStatement getFirstNodeIDByLabelStatement(String label) throws SQLException {
        if (this.stmtFirstNodeIDByLabel == null) {
            this.stmtFirstNodeIDByLabel = this.connection.prepareStatement("SELECT rowid FROM nodes WHERE label = ? LIMIT 1;");
        }
        this.stmtFirstNodeIDByLabel.setString(1, label);
        return this.stmtFirstNodeIDByLabel;
    }

    @Override
    public PreparedStatement getNodePropKeysStatement(int nodeID) throws SQLException {
        if (this.stmtNodePropKeys == null) {
            this.stmtNodePropKeys = this.connection.prepareStatement("SELECT key FROM nodeprops WHERE nodeid = ?;");
        }
        this.stmtNodePropKeys.setInt(1, nodeID);
        return this.stmtNodePropKeys;
    }

    @Override
    public PreparedStatement getNodePropValueStatement(int nodeID, String name) throws SQLException {
        if (this.stmtNodePropValue == null) {
            this.stmtNodePropValue = this.connection.prepareStatement("SELECT type, value FROM nodeprops WHERE nodeid = ? AND key = ? LIMIT 1;");
        }
        this.stmtNodePropValue.setInt(1, nodeID);
        this.stmtNodePropValue.setString(2, name);
        return this.stmtNodePropValue;
    }

    @Override
    public PreparedStatement getUpsertNodePropStatement(int nodeID, String key, Object value) throws SQLException, IOException {
        if (this.stmtUpsertNodeProp == null) {
            this.stmtUpsertNodeProp = this.connection.prepareStatement("INSERT INTO nodeprops (nodeid, key, type, value) VALUES (?, ?, ?, ?) ON CONFLICT (nodeid, key) DO UPDATE SET value = ?;");
        }
        this.stmtUpsertNodeProp.setInt(1, nodeID);
        this.stmtUpsertNodeProp.setString(2, key);
        this.stmtUpsertNodeProp.setString(3, this.getPropertyType(value));
        if (value instanceof Blob) {
            String value_base64 = this.base64(value);
            this.stmtUpsertNodeProp.setString(4, value_base64);
            this.stmtUpsertNodeProp.setString(5, value_base64);
        } else {
            this.stmtUpsertNodeProp.setObject(4, value);
            this.stmtUpsertNodeProp.setObject(5, value);
        }
        return this.stmtUpsertNodeProp;
    }

    @Override
    public PreparedStatement getDeleteNodePropStatement(int nodeID, String name) throws SQLException {
        if (this.stmtDeleteNodeProp == null) {
            this.stmtDeleteNodeProp = this.connection.prepareStatement("DELETE FROM nodeprops WHERE nodeid = ? AND key = ?;");
        }
        this.stmtDeleteNodeProp.setInt(1, nodeID);
        this.stmtDeleteNodeProp.setString(2, name);
        return this.stmtDeleteNodeProp;
    }

    @Override
    public PreparedStatement getDeleteNodeStatement(int nodeID) throws SQLException {
        if (this.stmtDeleteNode == null) {
            this.stmtDeleteNode = this.connection.prepareStatement("DELETE FROM nodes WHERE rowid = ?;");
        }
        this.stmtDeleteNode.setInt(1, nodeID);
        return this.stmtDeleteNode;
    }

    @Override
    public PreparedStatement getDeleteNodePropsStatement(int nodeID) throws SQLException {
        if (this.stmtDeleteNodeProps == null) {
            this.stmtDeleteNodeProps = this.connection.prepareStatement("DELETE FROM nodeprops WHERE nodeid = ?;");
        }
        this.stmtDeleteNodeProps.setInt(1, nodeID);
        return this.stmtDeleteNodeProps;
    }

    @Override
    public PreparedStatement getInsertEdgeStatement(int startID, int endID, String label) throws SQLException {
        if (this.stmtInsertEdge == null) {
            this.stmtInsertEdge = this.connection.prepareStatement("INSERT INTO edges (startId, endId, label) VALUES (?, ?, ?) ON CONFLICT DO NOTHING;");
        }
        this.stmtInsertEdge.setInt(1, startID);
        this.stmtInsertEdge.setInt(2, endID);
        this.stmtInsertEdge.setString(3, label);
        return this.stmtInsertEdge;
    }

    @Override
    public PreparedStatement getDeleteEdgeStatement(int edgeID) throws SQLException {
        if (this.stmtDeleteEdge == null) {
            this.stmtDeleteEdge = this.connection.prepareStatement("DELETE FROM edges WHERE rowid = ?;");
        }
        this.stmtDeleteEdge.setInt(1, edgeID);
        return this.stmtDeleteEdge;
    }

    @Override
    public PreparedStatement getOutgoingEdgesWithTypeStatement(String type, int fromID) throws SQLException {
        if (this.stmtOutgoingEdgesWithType == null) {
            this.stmtOutgoingEdgesWithType = this.connection.prepareStatement("SELECT rowid, endId FROM edges WHERE label = ? AND startId = ?;");
        }
        this.stmtOutgoingEdgesWithType.setString(1, type);
        this.stmtOutgoingEdgesWithType.setInt(2, fromID);
        return this.stmtOutgoingEdgesWithType;
    }

    @Override
    public PreparedStatement getOutgoingEdgesWithTypeAndNodeStatement(String type, int fromID, int toID) throws SQLException {
        if (this.stmtOutgoingEdgesWithTypeAndNode == null) {
            this.stmtOutgoingEdgesWithTypeAndNode = this.connection.prepareStatement("SELECT rowid, endId FROM edges WHERE label = ? AND startId = ? AND endId = ?;");
        }
        this.stmtOutgoingEdgesWithTypeAndNode.setString(1, type);
        this.stmtOutgoingEdgesWithTypeAndNode.setInt(2, fromID);
        this.stmtOutgoingEdgesWithTypeAndNode.setInt(3, toID);
        return this.stmtOutgoingEdgesWithTypeAndNode;
    }

    @Override
    public PreparedStatement getOutgoingEdgesStatement(int fromID) throws SQLException {
        if (this.stmtOutgoingEdges == null) {
            this.stmtOutgoingEdges = this.connection.prepareStatement("SELECT rowid, endId, label FROM edges WHERE startId = ?;");
        }
        this.stmtOutgoingEdges.setInt(1, fromID);
        return this.stmtOutgoingEdges;
    }

    @Override
    public PreparedStatement getIncomingEdgesWithTypeStatement(String type, int toID) throws SQLException {
        if (this.stmtIncomingEdgesWithType == null) {
            this.stmtIncomingEdgesWithType = this.connection.prepareStatement("SELECT rowid, startId FROM edges WHERE label = ? AND endId = ?;");
        }
        this.stmtIncomingEdgesWithType.setString(1, type);
        this.stmtIncomingEdgesWithType.setInt(2, toID);
        return this.stmtIncomingEdgesWithType;
    }

    @Override
    public PreparedStatement getIncomingEdgesStatement(int toID) throws SQLException {
        if (this.stmtIncomingEdges == null) {
            this.stmtIncomingEdges = this.connection.prepareStatement("SELECT rowid, startId, label FROM edges WHERE endId = ?;");
        }
        this.stmtIncomingEdges.setInt(1, toID);
        return this.stmtIncomingEdges;
    }

    @Override
    public PreparedStatement getEdgesStatement(int startOrEndID) throws SQLException {
        if (this.stmtEdges == null) {
            this.stmtEdges = this.connection.prepareStatement("SELECT rowid, startId, endId, label FROM edges WHERE startId = ? OR endId = ?;");
        }
        this.stmtEdges.setInt(1, startOrEndID);
        this.stmtEdges.setInt(2, startOrEndID);
        return this.stmtEdges;
    }

    @Override
    public PreparedStatement getEdgesWithTypeStatement(String type, int startOrEndID) throws SQLException {
        if (this.stmtEdgesWithType == null) {
            this.stmtEdgesWithType = this.connection.prepareStatement("SELECT rowid, startId, endid FROM edges WHERE label = ? AND (startId = ? OR endId = ?);");
        }
        this.stmtEdgesWithType.setString(1, type);
        this.stmtEdgesWithType.setInt(2, startOrEndID);
        this.stmtEdgesWithType.setInt(3, startOrEndID);
        return this.stmtEdgesWithType;
    }

    @Override
    public PreparedStatement getEdgePropKeysStatement(int edgeID) throws SQLException {
        if (this.stmtEdgePropKeys == null) {
            this.stmtEdgePropKeys = this.connection.prepareStatement("SELECT key FROM edgeprops WHERE edgeid = ?;");
        }
        this.stmtEdgePropKeys.setInt(1, edgeID);
        return this.stmtEdgePropKeys;
    }

    @Override
    public PreparedStatement getEdgePropValueStatement(int edgeID, String name) throws SQLException {
        if (this.stmtEdgePropValue == null) {
            this.stmtEdgePropValue = this.connection.prepareStatement("SELECT type, value FROM edgeprops WHERE edgeid = ? AND key = ? LIMIT 1;");
        }
        this.stmtEdgePropValue.setInt(1, edgeID);
        this.stmtEdgePropValue.setString(2, name);
        return this.stmtEdgePropValue;
    }

    @Override
    public PreparedStatement getUpsertEdgePropStatement(int edgeID, String key, Object value) throws SQLException, IOException {
        if (this.stmtUpsertEdgeProp == null) {
            this.stmtUpsertEdgeProp = this.connection.prepareStatement("INSERT INTO edgeprops (edgeid, key, type, value) VALUES (?, ?, ?, ?) ON CONFLICT (edgeid, key) DO UPDATE SET value = ?;");
        }
        this.stmtUpsertEdgeProp.setInt(1, edgeID);
        this.stmtUpsertEdgeProp.setString(2, key);
        this.stmtUpsertEdgeProp.setString(3, this.getPropertyType(value));
        if (value instanceof Blob) {
            String value_base64 = this.base64(value);
            this.stmtUpsertEdgeProp.setString(4, value_base64);
            this.stmtUpsertEdgeProp.setString(5, value_base64);
        } else {
            this.stmtUpsertEdgeProp.setObject(4, value);
            this.stmtUpsertEdgeProp.setObject(5, value);
        }
        return this.stmtUpsertEdgeProp;
    }

    @Override
    public PreparedStatement getDeleteEdgePropStatement(int edgeID, String name) throws SQLException {
        if (this.stmtDeleteEdgeProp == null) {
            this.stmtDeleteEdgeProp = this.connection.prepareStatement("DELETE FROM edgeprops WHERE edgeId = ? AND key = ?;");
        }
        this.stmtDeleteEdgeProp.setInt(1, edgeID);
        this.stmtDeleteEdgeProp.setString(2, name);
        return this.stmtDeleteEdgeProp;
    }

    @Override
    public PreparedStatement getDeleteEdgePropsStatement(int edgeID) throws SQLException {
        if (this.stmtDeleteEdgeProps == null) {
            this.stmtDeleteEdgeProps = this.connection.prepareStatement("DELETE FROM edgeprops WHERE edgeId = ?;");
        }
        this.stmtDeleteEdgeProps.setInt(1, edgeID);
        return this.stmtDeleteEdgeProps;
    }

    @Override
    public PreparedStatement getDeleteEdgePropsForNodeStatement(int nodeID) throws SQLException {
        if (this.stmtDeleteEdgePropsForNode == null) {
            this.stmtDeleteEdgePropsForNode = this.connection.prepareStatement("DELETE FROM edgeprops WHERE edgeid IN ( SELECT rowid FROM edges WHERE startId = ? OR endId = ? );");
        }
        this.stmtDeleteEdgePropsForNode.setInt(1, nodeID);
        this.stmtDeleteEdgePropsForNode.setInt(2, nodeID);
        return this.stmtDeleteEdgePropsForNode;
    }

    @Override
    public PreparedStatement getDeleteEdgesForNodeStatement(int nodeID) throws SQLException {
        if (this.stmtDeleteEdgesForNode == null) {
            this.stmtDeleteEdgesForNode = this.connection.prepareStatement("DELETE FROM edges WHERE startId = ? OR endId = ?;");
        }
        this.stmtDeleteEdgesForNode.setInt(1, nodeID);
        this.stmtDeleteEdgesForNode.setInt(2, nodeID);
        return this.stmtDeleteEdgesForNode;
    }

    @Override
    public PreparedStatement getUpsertNodeIndexStatement(String name) throws SQLException {
        if (this.stmtUpsertNodeIndex == null) {
            this.stmtUpsertNodeIndex = this.connection.prepareStatement("INSERT INTO nodeindices (name) VALUES (?) ON CONFLICT (name) DO NOTHING;");
        }
        this.stmtUpsertNodeIndex.setString(1, name);
        return this.stmtUpsertNodeIndex;
    }

    @Override
    public PreparedStatement getDeleteNodeIndexStatement(String name) throws SQLException {
        if (this.stmtDeleteNodeIndex == null) {
            this.stmtDeleteNodeIndex = this.connection.prepareStatement("DELETE FROM nodeindices WHERE name = ?;");
        }
        this.stmtDeleteNodeIndex.setString(1, name);
        return this.stmtDeleteNodeIndex;
    }

    @Override
    public PreparedStatement getAllNodeIndicesStatement() throws SQLException {
        if (this.stmtAllNodeIndices == null) {
            this.stmtAllNodeIndices = this.connection.prepareStatement("SELECT name FROM nodeindices;");
        }
        return this.stmtAllNodeIndices;
    }

    @Override
    public PreparedStatement getAddNodeIndexEntryStatement(String indexName, String key, int nodeId, Object value) throws SQLException {
        PreparedStatement stmt = this.stmtAddNodeIndexEntry.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("INSERT INTO `idx_%s` (key, nodeId, value) VALUES (?, ?, ?);", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setInt(2, nodeId);
        stmt.setObject(3, value);
        return stmt;
    }

    @Override
    public PreparedStatement getRemoveNodeIndexEntryStatement(String indexName, String key, int nodeId, Object value) throws SQLException {
        PreparedStatement stmt = this.stmtRemoveNodeIndexEntry.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("DELETE FROM `idx_%s` WHERE key = ? AND nodeId = ? AND value = ?;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setInt(2, nodeId);
        stmt.setObject(3, value);
        return stmt;
    }

    @Override
    public PreparedStatement getRemoveNodeFromIndexStatement(String indexName, int nodeId) throws SQLException {
        PreparedStatement stmt = this.stmtRemoveNodeFromIndex.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("DELETE FROM `idx_%s` WHERE nodeId = ?;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setInt(1, nodeId);
        return stmt;
    }

    @Override
    public PreparedStatement getRemoveNodeFieldFromIndexStatement(String indexName, int nodeId, String key) throws SQLException {
        PreparedStatement stmt = this.stmtRemoveNodeFieldFromIndex.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("DELETE FROM `idx_%s` WHERE nodeId = ? AND key = ?;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setInt(1, nodeId);
        stmt.setString(2, key);
        return stmt;
    }

    @Override
    public PreparedStatement getRemoveNodeValueFromIndexStatement(String indexName, int nodeId, Object value) throws SQLException {
        PreparedStatement stmt = this.stmtRemoveNodeValueFromIndex.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("DELETE FROM `idx_%s` WHERE nodeId = ? AND value = ?;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setInt(1, nodeId);
        stmt.setObject(2, value);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValuePatternStatement(String indexName, String key, String value) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValuePattern.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s` WHERE key = ? AND value GLOB ?;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setString(2, value);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValuePatternCountStatement(String indexName, String key, String value) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValuePatternCount.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT DISTINCT COUNT(1) FROM `idx_%s` WHERE key = ? AND value GLOB ?;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setString(2, value);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValuePatternSingleStatement(String indexName, String key, String value) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValuePatternSingle.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT nodeId FROM `idx_%s` WHERE key = ? AND value GLOB ? LIMIT 1;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setString(2, value);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueExactStatement(String indexName, String key, Object value) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueExact.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s` WHERE key = ? AND value = ?;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setObject(2, value);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueExactCountStatement(String indexName, String key, Object value) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueExactCount.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT COUNT(DISTINCT nodeId) FROM `idx_%s` WHERE key = ? AND value = ?;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setObject(2, value);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueExactSingleStatement(String indexName, String key, Object value) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueExactSingle.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT nodeId FROM `idx_%s` WHERE key = ? AND value = ? LIMIT 1;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setObject(2, value);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueAllValuesStatement(String indexName, String key) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueAllValues.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s` WHERE key = ?;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueAllValuesCountStatement(String indexName, String key) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueAllValuesCount.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT COUNT(DISTINCT nodeId) FROM `idx_%s` WHERE key = ?;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueAllValuesSingleStatement(String indexName, String key) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueAllValuesSingle.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT nodeId FROM `idx_%s` WHERE key = ? LIMIT 1;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueAllPairsStatement(String indexName) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueAllPairs.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s`;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueAllPairsCountStatement(String indexName) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueAllPairsCount.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT COUNT(DISTINCT nodeId) FROM `idx_%s`;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueAllPairsSingleStatement(String indexName) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueAllPairsSingle.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT nodeId FROM `idx_%s` LIMIT 1;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexNumberRangeStatement(String indexName, String key, boolean fromInclusive, Number from, boolean toInclusive, Number to) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexNumberRange.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s` WHERE key = ? AND (? AND value >= ? OR value > ?) AND (? AND value <= ? OR value < ?);", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setBoolean(2, fromInclusive);
        stmt.setObject(3, from);
        stmt.setObject(4, from);
        stmt.setBoolean(5, toInclusive);
        stmt.setObject(6, to);
        stmt.setObject(7, to);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexNumberRangeCountStatement(String indexName, String key, boolean fromInclusive, Number from, boolean toInclusive, Number to) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexNumberRangeCount.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT COUNT(DISTINCT nodeId) FROM `idx_%s` WHERE key = ? AND (? AND value >= ? OR value > ?) AND (? AND value <= ? OR value < ?);", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setBoolean(2, fromInclusive);
        stmt.setObject(3, from);
        stmt.setObject(4, from);
        stmt.setBoolean(5, toInclusive);
        stmt.setObject(6, to);
        stmt.setObject(7, to);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexNumberRangeSingleStatement(String indexName, String key, boolean fromInclusive, Number from, boolean toInclusive, Number to) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexNumberRangeSingle.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s` WHERE key = ? AND (? AND value >= ? OR value > ?) AND (? AND value <= ? OR value < ?) LIMIT 1;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setBoolean(2, fromInclusive);
        stmt.setObject(3, from);
        stmt.setObject(4, from);
        stmt.setBoolean(5, toInclusive);
        stmt.setObject(6, to);
        stmt.setObject(7, to);
        return stmt;
    }

    protected String getPropertyType(Object value) {
        if (value instanceof Blob) {
            return TYPE_BLOB_BASE64;
        }
        return value == null ? "unknown" : value.getClass().getSimpleName();
    }

    protected void copy(InputStream source, OutputStream target) throws IOException {
        int length;
        byte[] buf = new byte[8192];
        while ((length = source.read(buf)) > 0) {
            target.write(buf, 0, length);
        }
    }

    protected String base64(Object value) throws IOException, SQLException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.copy(((Blob)value).getBinaryStream(), bos);
        return Base64.encodeBase64String((byte[])bos.toByteArray());
    }
}

