/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite.timeaware;

import java.sql.Connection;
import java.util.Map;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphDatabase;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNodeIndex;
import org.eclipse.hawk.sqlite.AbstractSQLiteDatabase;
import org.eclipse.hawk.sqlite.iteration.StatementGraphNodeIterable;
import org.eclipse.hawk.sqlite.queries.IQueries;
import org.eclipse.hawk.sqlite.queries.TimeAwareQueries;
import org.eclipse.hawk.sqlite.schema.ISchema;
import org.eclipse.hawk.sqlite.schema.TimeAwareSchema;
import org.eclipse.hawk.sqlite.timeaware.TimeAwareSQLiteEdge;
import org.eclipse.hawk.sqlite.timeaware.TimeAwareSQLiteNode;
import org.eclipse.hawk.sqlite.timeaware.TimeAwareSQLiteNodeIndex;

public class TimeAwareSQLiteDatabase
extends AbstractSQLiteDatabase
implements ITimeAwareGraphDatabase {
    private long timepoint = 0L;

    @Override
    protected IGraphNodeIndex createNodeIndex(String name) {
        return new TimeAwareSQLiteNodeIndex(this, name, this.timepoint);
    }

    @Override
    protected IQueries createQueries(Connection db) {
        return new TimeAwareQueries(db, this::getTime);
    }

    @Override
    protected ISchema createSchema(Connection db) {
        return new TimeAwareSchema(db);
    }

    protected TimeAwareSQLiteNode createNode(int nodeId) {
        return new TimeAwareSQLiteNode(this, nodeId, this.timepoint);
    }

    @Override
    protected IGraphEdge createEdge(String type, int startId, int endId, int edgeId) {
        return new TimeAwareSQLiteEdge(this, edgeId, startId, endId, type, this.timepoint);
    }

    public IGraphIterable<? extends ITimeAwareGraphNode> allNodes(String label, long time) {
        return new StatementGraphNodeIterable<TimeAwareSQLiteNode>(() -> this.getQueries().getNodeIDsByLabelStatement(label, time), () -> this.getQueries().getNodeCountByLabelStatement(label, time), () -> this.getQueries().getFirstNodeIDByLabelStatement(label, time), o -> this.createNode((Integer)o));
    }

    public long getTime() {
        return this.timepoint;
    }

    public void setTime(long time) {
        this.timepoint = time;
    }

    public ITimeAwareGraphNodeIndex getOrCreateNodeIndex(String name) {
        return (ITimeAwareGraphNodeIndex)super.getOrCreateNodeIndex(name);
    }

    public ITimeAwareGraphNode createNode(Map<String, Object> props, String label) {
        return (ITimeAwareGraphNode)super.createNode(props, label);
    }

    public ITimeAwareGraphNode getNodeById(Object id) {
        return (ITimeAwareGraphNode)super.getNodeById(id);
    }

    public IGraphIterable<? extends ITimeAwareGraphNode> allNodes(String label) {
        return super.allNodes(label);
    }

    public ITimeAwareGraphNodeIndex getFileIndex() {
        return (ITimeAwareGraphNodeIndex)super.getFileIndex();
    }

    protected TimeAwareQueries getQueries() {
        return (TimeAwareQueries)this.getConnection().getQueries();
    }

    public String getHumanReadableName() {
        return "Time-Aware SQLite Database";
    }
}

