/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loading;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.osgi.framework.Bundle;

public final class BundleEntry {
    private static final String PATH_SEPARATOR = "/";
    private static final String DOT = ".";
    private final String path;
    private final Bundle bundle;

    public BundleEntry(Bundle bundle) {
        this(bundle, "");
    }

    private BundleEntry(Bundle bundle, String path) {
        this.path = path;
        this.bundle = bundle;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public List<BundleEntry> list() {
        ArrayList<BundleEntry> entries = new ArrayList<BundleEntry>();
        Enumeration<?> paths = this.getEntryPathsFromBundle();
        if (paths != null) {
            while (paths.hasMoreElements()) {
                String subPath = (String)paths.nextElement();
                entries.add(this.createBundleEntry(subPath));
            }
        }
        return entries;
    }

    private BundleEntry createBundleEntry(String path) {
        return new BundleEntry(this.bundle, path);
    }

    private Enumeration<?> getEntryPathsFromBundle() {
        Enumeration ep = this.bundle.getEntryPaths(this.path);
        HashSet<String> paths = new HashSet<String>();
        if (ep != null) {
            while (ep.hasMoreElements()) {
                paths.add((String)ep.nextElement());
            }
        }
        if ("WEB-INF".equals(this.path) && this.getEntry("web.xml") != null) {
            paths.add("WEB-INF/web.xml");
        }
        if (paths.isEmpty()) {
            return null;
        }
        final String[] pathArray = paths.toArray(new String[0]);
        return new Enumeration<String>(){
            private int pos = 0;

            @Override
            public boolean hasMoreElements() {
                return this.pos < pathArray.length;
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    return pathArray[this.pos++];
                }
                return null;
            }
        };
    }

    public BundleEntry getEntry(String subPath) {
        String finalPath = String.valueOf(this.path) + subPath;
        if (this.getEntryFromBundle(finalPath) != null) {
            return this.createBundleEntry(finalPath);
        }
        return null;
    }

    private URL getEntryFromBundle(String path) {
        String searchFile;
        String searchPath;
        if (path.endsWith(PATH_SEPARATOR) || path.length() == 0) {
            return this.bundle.getEntry(path);
        }
        int lastSlashIndex = path.lastIndexOf(PATH_SEPARATOR);
        if (lastSlashIndex == -1) {
            searchPath = PATH_SEPARATOR;
            searchFile = path;
        } else {
            searchPath = path.substring(0, lastSlashIndex);
            searchFile = path.substring(lastSlashIndex + 1);
        }
        if (searchFile.equals(DOT)) {
            return this.bundle.getEntry(path.substring(0, path.length() - 1));
        }
        Enumeration entries = this.bundle.findEntries(searchPath, searchFile, false);
        if (entries != null && entries.hasMoreElements()) {
            return (URL)entries.nextElement();
        }
        return null;
    }

    public String getName() {
        int index;
        String name = this.path;
        if (name.endsWith(PATH_SEPARATOR)) {
            name = name.substring(0, this.path.length() - 1);
        }
        if ((index = name.lastIndexOf(PATH_SEPARATOR)) > -1) {
            name = name.substring(index + 1);
        }
        if (name.length() == 0) {
            return PATH_SEPARATOR;
        }
        return name;
    }

    public URL getURL() {
        return this.getEntryFromBundle(this.path);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isDirectory() {
        URL entryFromBundle = this.getEntryFromBundle(this.path);
        return entryFromBundle.getFile().endsWith(PATH_SEPARATOR);
    }

    public String toString() {
        return String.format("BundleEntry [bundle=%s,path=%s]", this.bundle, this.path);
    }
}

