/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.generator.fsm.generic.ILanguageExtensionBase;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.etrice.generator.java.Main;
import org.eclipse.etrice.generator.java.setup.GeneratorOptionsHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class JavaExtensions
implements ILanguageExtension {
    @Inject
    private TypeHelpers typeHelpers;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;

    public String getTypedDataDefinition(EObject msg) {
        String string = null;
        string = msg instanceof Message ? this.generateArglistAndTypedData((EObject)((Message)msg).getData())[ILanguageExtensionBase.TypedDataKind.DECLARATION_AND_INITIALIZATION.ordinal()] : "";
        return string;
    }

    public String getJavaFileName(RoomClass rc) {
        String string = rc.getName();
        return String.valueOf(string) + ".java";
    }

    public String getJavaFactoryName(ActorClass rc) {
        String string = rc.getName();
        return String.valueOf(string) + "Factory";
    }

    public String getJavaFactoryFileName(ActorClass rc) {
        String string = this.getJavaFactoryName(rc);
        return String.valueOf(string) + ".java";
    }

    public String getJavaScalarInterfaceName(ActorClass rc) {
        String string = rc.getName();
        return String.valueOf(string) + "Interface";
    }

    public String getJavaScalarInterfaceFileName(ActorClass rc) {
        String string = this.getJavaScalarInterfaceName(rc);
        return String.valueOf(string) + ".java";
    }

    public String getJavaReplicatedInterfaceName(ActorClass rc) {
        String string = rc.getName();
        return String.valueOf(string) + "ReplicatedInterface";
    }

    public String getJavaReplicatedInterfaceFileName(ActorClass rc) {
        String string = this.getJavaReplicatedInterfaceName(rc);
        return String.valueOf(string) + ".java";
    }

    public String getJavaInterfaceName(ActorClass ac, boolean replicated) {
        String string = null;
        string = replicated ? this.getJavaReplicatedInterfaceName(ac) : this.getJavaScalarInterfaceName(ac);
        return string;
    }

    public String getJavaInterfaceFileName(ActorClass ac, boolean replicated) {
        String string = null;
        string = replicated ? this.getJavaReplicatedInterfaceFileName(ac) : this.getJavaScalarInterfaceFileName(ac);
        return string;
    }

    public String getJavaClassName(NodeRef nr, SubSystemInstance ssi) {
        String string = nr.getName();
        String string2 = "Node_" + string;
        String string3 = String.valueOf(string2) + "_";
        String string4 = ssi.getName();
        return String.valueOf(string3) + string4;
    }

    public String getJavaFileName(NodeRef nr, SubSystemInstance ssi) {
        String string = this.getJavaClassName(nr, ssi);
        return String.valueOf(string) + ".java";
    }

    public String toWrapper(String type) {
        String string = null;
        boolean bl = false;
        if (Objects.equal((Object)type, (Object)"int")) {
            bl = true;
            string = "Integer";
        }
        if (!bl && Objects.equal((Object)type, (Object)"char")) {
            bl = true;
            string = "Character";
        }
        if (!bl) {
            string = StringExtensions.toFirstUpper((String)type);
        }
        return string;
    }

    public boolean needsInitialization(Attribute a) {
        return a.getSize() > 0 || !this.typeHelpers.isEnumerationOrPrimitive(a.getType().getType()) || this.typeHelpers.typeName(a.getType().getType()).equals("String");
    }

    public String accessLevelPrivate() {
        return "private ";
    }

    public String accessLevelProtected() {
        return "protected ";
    }

    public String accessLevelPublic() {
        return "public ";
    }

    public String memberAccess() {
        return "this.";
    }

    public String selfPointer(String classname, boolean hasArgs) {
        return "";
    }

    public String selfPointer(boolean hasArgs) {
        return "";
    }

    public String operationScope(String classname, boolean isDeclaration) {
        return "";
    }

    public String scopeSeparator() {
        return ".";
    }

    public String memberInDeclaration(String namespace, String member) {
        return member;
    }

    public String memberInUse(String namespace, String member) {
        return String.valueOf(namespace) + "." + member;
    }

    public boolean usesInheritance() {
        return true;
    }

    public boolean usesPointers() {
        return false;
    }

    public String genEnumeration(String name, List<Pair<String, String>> entries) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        for (Pair<String, String> entry : entries) {
            stringConcatenation.append("public static final int ");
            String string = (String)entry.getFirst();
            stringConcatenation.append(string);
            stringConcatenation.append(" = ");
            String string2 = (String)entry.getSecond();
            stringConcatenation.append(string2);
            stringConcatenation.append(";");
            stringConcatenation.newLineIfNotEmpty();
        }
        return stringConcatenation.toString();
    }

    public String booleanConstant(boolean b) {
        return Boolean.valueOf(b).toString();
    }

    public String pointerLiteral() {
        return "";
    }

    public String nullPointer() {
        return "null";
    }

    public String voidPointer() {
        return "Object";
    }

    public String arrayType(String type, int size, boolean isRef) {
        return String.valueOf(type) + "[]";
    }

    public String arrayDeclaration(String type, int size, boolean isRef, String name) {
        return String.valueOf(type) + " " + name + "[]";
    }

    public String superCall(String baseClassName, String method, String args) {
        return "super." + method + "(" + args + ");";
    }

    public String toValueLiteral(PrimitiveType type, String value) {
        String string = null;
        if (!this.typeHelpers.isCharacterType(type) && (value.contains(",") || value.contains("{"))) {
            String string2 = null;
            String[] singleValues = value.replace("{", "").replace("}", "").trim().split(",");
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("{ ");
            boolean bl = false;
            String[] stringArray = singleValues;
            int n = singleValues.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!bl) {
                    bl = true;
                } else {
                    stringConcatenation.appendImmediate((Object)", ", "");
                }
                String string3 = this.castValue(type, v.trim());
                stringConcatenation.append(string3);
                ++n2;
            }
            stringConcatenation.append(" }");
            string = string2 = stringConcatenation.toString();
        } else {
            string = this.castValue(type, value);
        }
        return string;
    }

    public String toEnumLiteral(EnumerationType type, String value) {
        String string = null;
        if (value.contains(",") || value.contains("{")) {
            String string2 = null;
            String[] singleValues = value.replace("{", "").replace("}", "").trim().split(",");
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("{ ");
            boolean bl = false;
            String[] stringArray = singleValues;
            int n = singleValues.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!bl) {
                    bl = true;
                } else {
                    stringConcatenation.appendImmediate((Object)", ", "");
                }
                String string3 = this.convertStringEnumLiteral(type, v.trim());
                stringConcatenation.append(string3);
                ++n2;
            }
            stringConcatenation.append(" }");
            string = string2 = stringConcatenation.toString();
        } else {
            string = this.convertStringEnumLiteral(type, value);
        }
        return string;
    }

    private String convertStringEnumLiteral(EnumerationType type, String value) {
        String v = value;
        boolean bl = v.startsWith(type.getName());
        if (bl) {
            int n = type.getName().length();
            int n2 = n + 1;
            v = v.substring(n2);
        }
        EList eList = type.getLiterals();
        for (EnumLiteral l : eList) {
            boolean bl2 = l.getName().equals(v);
            if (!bl2) continue;
            String string = type.getName();
            String string2 = String.valueOf(string) + ".";
            String string3 = l.getName();
            return String.valueOf(string2) + string3;
        }
        return null;
    }

    private String castValue(PrimitiveType type, String value) {
        String string;
        String string2 = null;
        String string3 = type.getTargetName();
        boolean bl = false;
        if (Objects.equal((Object)string3, (Object)"boolean")) {
            bl = true;
            string2 = value.toLowerCase();
        }
        if (!bl && Objects.equal((Object)string3, (Object)"byte")) {
            bl = true;
            string2 = "(byte)" + value;
        }
        if (!bl && Objects.equal((Object)string3, (Object)"short")) {
            bl = true;
            string2 = "(short)" + value;
        }
        if (!bl && Objects.equal((Object)string3, (Object)"int")) {
            bl = true;
            string2 = value;
        }
        if (!bl && Objects.equal((Object)string3, (Object)"long")) {
            bl = true;
            string2 = String.valueOf(value) + "L";
        }
        if (!bl && Objects.equal((Object)string3, (Object)"float")) {
            bl = true;
            string2 = String.valueOf(value) + "f";
        }
        if (!bl && Objects.equal((Object)string3, (Object)"double")) {
            bl = true;
            string2 = String.valueOf(value) + "d";
        }
        if (!bl && Objects.equal((Object)string3, (Object)"char")) {
            bl = true;
            string = null;
            boolean bl2 = value.isEmpty();
            if (bl2) {
                string = "(char) 0";
            } else {
                boolean bl3;
                String string4 = null;
                int n = value.length();
                boolean bl4 = bl3 = n == 1;
                if (bl3) {
                    char c = value.charAt(0);
                    String string5 = "'" + Character.valueOf(c);
                    string4 = String.valueOf(string5) + "'";
                } else {
                    String string6 = value.replace("\\", "\\\\").replace("\"", "\\\"");
                    String string7 = "\"" + string6;
                    string4 = String.valueOf(string7) + "\".toCharArray()";
                }
                string = string4;
            }
            string2 = string;
        }
        if (!bl && Objects.equal((Object)string3, (Object)"String")) {
            bl = true;
            string = value.replace("\\", "\\\\").replace("\"", "\\\"");
            String string8 = "\"" + string;
            string2 = String.valueOf(string8) + "\"";
        }
        if (!bl) {
            string = type.getTargetName();
            throw new UnsupportedOperationException(string);
        }
        return string2;
    }

    public String defaultValue(DataType dt) {
        String string;
        String string2;
        String string3 = null;
        boolean bl = false;
        if (dt instanceof PrimitiveType) {
            bl = true;
            string3 = this.toValueLiteral((PrimitiveType)dt, ((PrimitiveType)dt).getDefaultValueLiteral());
        }
        if (!bl && dt instanceof EnumerationType) {
            bl = true;
            string3 = this.getDefaultValue((EnumerationType)dt);
        }
        if (!bl && dt instanceof ExternalType) {
            bl = true;
            string2 = ((ExternalType)dt).getTargetName();
            string = "new " + string2;
            string3 = String.valueOf(string) + "()";
        }
        if (!bl) {
            string2 = dt.getName();
            string = "new " + string2;
            string3 = String.valueOf(string) + "()";
        }
        return string3;
    }

    public String getDefaultValue(EnumerationType type) {
        String string = null;
        boolean bl = type.getLiterals().isEmpty();
        string = bl ? "" : this.getCastedValue((EnumLiteral)type.getLiterals().get(0));
        return string;
    }

    public String initializationWithDefaultValues(DataType dt, int size) {
        String string = null;
        String dv = this.defaultValue(dt);
        String string2 = null;
        if (size > 1) {
            String string3 = null;
            String res = "{";
            int i = 0;
            while (i < size) {
                res = String.valueOf(res) + dv;
                if (++i >= size) continue;
                res = String.valueOf(res) + ",";
            }
            string2 = string3 = String.valueOf(res) + "}";
        } else {
            string2 = dv;
        }
        string = string2;
        return string;
    }

    public String[] generateArglistAndTypedData(EObject d) {
        String ct;
        DataType dataType;
        Object object;
        String typeName;
        if (d == null || !(d instanceof MessageData)) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        MessageData data = (MessageData)d;
        String castTypeName = typeName = data.getRefType().getType().getName();
        DataType dataType2 = data.getRefType().getType();
        if (dataType2 instanceof PrimitiveType) {
            object = data.getRefType().getType();
            typeName = ((PrimitiveType)object).getTargetName();
            dataType = data.getRefType().getType();
            ct = ((PrimitiveType)dataType).getCastName();
            if (ct != null && !ct.isEmpty()) {
                castTypeName = ct;
            }
        } else {
            object = data.getRefType().getType();
            if (object instanceof EnumerationType) {
                dataType = data.getRefType().getType();
                typeName = this.getTargetType((EnumerationType)dataType);
                ct = data.getRefType().getType();
                castTypeName = this.getCastType((EnumerationType)ct);
            }
        }
        object = null;
        object = this._generatorOptionsHelper.isOldStyleTransitionData(Main.getSettings()) && data.getDeprecatedName() != null && !data.getDeprecatedName().trim().isEmpty() ? data.getDeprecatedName() : "transitionData";
        Object dataName = object;
        String dataArg = ", " + (String)dataName;
        String typedData = String.valueOf(typeName) + " " + (String)dataName + " = (" + castTypeName + ") generic_data__et;\n";
        String typedArgList = ", " + typeName + " " + (String)dataName;
        return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{dataArg, typedData, typedArgList}), String.class);
    }

    public String getTargetType(EnumerationType type) {
        String string = null;
        PrimitiveType primitiveType = type.getPrimitiveType();
        boolean bl = primitiveType != null;
        string = bl ? type.getPrimitiveType().getTargetName() : "int";
        return string;
    }

    public String getCastedValue(EnumLiteral literal) {
        boolean bl;
        String string = null;
        EObject eObject = literal.eContainer();
        EnumerationType type = (EnumerationType)eObject;
        String cast = this.getTargetType(type);
        String string2 = null;
        PrimitiveType primitiveType = type.getPrimitiveType();
        boolean bl2 = bl = primitiveType == null;
        if (bl) {
            string2 = Long.toString(literal.getLiteralValue());
        } else {
            String string3 = Long.toString(literal.getLiteralValue());
            String string4 = "((" + cast + ")" + string3;
            string2 = String.valueOf(string4) + ")";
        }
        string = string2;
        return string;
    }

    public String getCastType(EnumerationType type) {
        String string = null;
        PrimitiveType primitiveType = type.getPrimitiveType();
        boolean bl = primitiveType != null;
        string = bl ? type.getPrimitiveType().getCastName() : "int";
        return string;
    }

    public String makeOverridable() {
        return "";
    }

    public String getTypeSignature(RefableType type) {
        boolean bl;
        String string = null;
        RefableType it = type;
        boolean bl2 = false;
        if (Objects.equal((Object)it, null)) {
            bl2 = true;
            string = "void";
        }
        if (!bl2 && (bl = it.isRef())) {
            bl2 = true;
            String string2 = this.getDataTypeName(type.getType());
            String string3 = this.pointerLiteral();
            string = String.valueOf(string2) + string3;
        }
        if (!bl2) {
            string = this.getDataTypeName(type.getType());
        }
        return string;
    }

    public String getDataTypeName(DataType it) {
        String string = null;
        boolean bl = false;
        if (it instanceof PrimitiveType) {
            bl = true;
            string = ((PrimitiveType)it).getTargetName();
        }
        if (!bl && it instanceof EnumerationType) {
            bl = true;
            string = this.getTargetType((EnumerationType)it);
        }
        if (!bl && it instanceof ExternalType) {
            bl = true;
            string = ((ExternalType)it).getTargetName();
        }
        if (!bl) {
            string = it.getName();
        }
        return string;
    }

    public String toParameterDecl(VarDecl it) {
        String string;
        String string2;
        String string3;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = it.isVarargs();
        if (bl2) {
            bl = true;
            string3 = this.getTypeSignature(it.getRefType());
            string2 = String.valueOf(string3) + "... ";
            string = it.getName();
            string4 = String.valueOf(string2) + string;
        }
        if (!bl) {
            string3 = this.getTypeSignature(it.getRefType());
            string2 = String.valueOf(string3) + " ";
            string = it.getName();
            string4 = String.valueOf(string2) + string;
        }
        return string4;
    }
}

