/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.rrobot.impl;

import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.fx.ide.rrobot.impl.DefaultProjectHandler;
import org.eclipse.fx.ide.rrobot.model.task.CompilationUnit;
import org.eclipse.fx.ide.rrobot.model.task.Folder;
import org.eclipse.fx.ide.rrobot.model.task.JDTProject;
import org.eclipse.fx.ide.rrobot.model.task.SourceFragment;
import org.eclipse.fx.ide.rrobot.model.task.TaskPackage;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class JDTProjectHandler<P extends JDTProject>
extends DefaultProjectHandler<P> {
    @Override
    public boolean isHandled(EClass eClass) {
        return eClass == TaskPackage.Literals.JDT_PROJECT;
    }

    @Override
    protected IStatus customizeProject(IProgressMonitor monitor, IProject project, P model) {
        try {
            JDTProjectHandler.addNatureToProject(project, "org.eclipse.jdt.core.javanature", monitor);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            javaProject.setOutputLocation(project.getFullPath().append("bin"), monitor);
            IClasspathEntry[] tmpEntries = this.createClasspathEntries(model);
            IClasspathEntry[] entries = new IClasspathEntry[tmpEntries.length + model.getSourceFragments().size()];
            int i = 0;
            for (SourceFragment f : model.getSourceFragments()) {
                StringBuilder b = new StringBuilder();
                Folder folder = f.getFolder();
                while (folder != null) {
                    if (b.length() > 0) {
                        b.insert(0, "/");
                    }
                    b.insert(0, folder.getName());
                    if (!(folder.eContainer() instanceof Folder)) break;
                    folder = (Folder)folder.eContainer();
                }
                entries[i] = JavaCore.newSourceEntry((IPath)project.getProject().getFullPath().append(b.toString()));
            }
            System.arraycopy(tmpEntries, 0, entries, model.getSourceFragments().size(), tmpEntries.length);
            javaProject.setRawClasspath(entries, monitor);
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.fx.ide.rrobot", "Unable to add nature", (Throwable)e);
        }
        return super.customizeProject(monitor, project, model);
    }

    @Override
    protected IStatus createResources(IProgressMonitor monitor, IProject p, P model, Map<String, Object> additionalData) {
        IStatus s = super.createResources(monitor, p, model, additionalData);
        if (!s.isOK()) {
            return s;
        }
        for (CompilationUnit c : model.getCompilationUnits()) {
            String[] packs;
            if (c.getExcludeExpression() != null && c.getExcludeExpression().execute(additionalData)) continue;
            Folder mFolder = c.getSourcefragment().getFolder();
            IFolder folder = JDTProjectHandler.getProjectFolder(p, mFolder);
            if (c.getPackagename().trim().length() == 0) {
                this.createFile(monitor, folder.getFile(c.getFile().getName()), c.getFile(), additionalData);
                continue;
            }
            String[] stringArray = packs = c.getPackagename().split("\\.");
            int n = packs.length;
            int n2 = 0;
            while (n2 < n) {
                String pack = stringArray[n2];
                folder = folder.getFolder(pack);
                try {
                    if (!folder.exists()) {
                        folder.create(true, true, monitor);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            this.createFile(monitor, folder.getFile(c.getFile().getName()), c.getFile(), additionalData);
        }
        if (!p.getFolder("bin").exists()) {
            try {
                p.getFolder("bin").create(true, true, monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return s;
    }

    protected IClasspathEntry[] createClasspathEntries(P model) {
        return new IClasspathEntry[0];
    }
}

