/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.core.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.ide.jdt.core.FXVersion;
import org.eclipse.fx.ide.jdt.core.FXVersionUtil;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;

public class BuildPathSupport {
    public static final String WEB_JAVADOC_LOCATION = "http://docs.oracle.com/javase/8/javafx/api/";
    private static final Logger LOGGER = LoggerCreator.createLogger(BuildPathSupport.class);

    public static List<IClasspathEntry> getJavaFXLibraryEntry(IJavaProject project) {
        FXVersion version = BuildPathSupport.getFXVersion(project);
        if (version == FXVersion.FX2 || version == FXVersion.FX8) {
            IPath[] paths = BuildPathSupport.getFxJarPath(project);
            ArrayList<IClasspathEntry> rv = new ArrayList<IClasspathEntry>();
            if (paths != null) {
                IPath jarLocationPath = paths[0];
                IPath javadocLocation = paths[1];
                IPath fxSource = paths[3];
                IAccessRule[] accessRules = new IAccessRule[]{};
                IClasspathAttribute[] attributes = javadocLocation == null || !javadocLocation.toFile().exists() ? new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)WEB_JAVADOC_LOCATION)} : new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadocLocation.toFile().toURI().toString())};
                if (jarLocationPath.toFile().exists()) {
                    rv.add(JavaCore.newLibraryEntry((IPath)jarLocationPath, (IPath)fxSource, null, (IAccessRule[])accessRules, (IClasspathAttribute[])attributes, (boolean)false));
                }
            }
            return rv;
        }
        if (version == FXVersion.FX11 || version == FXVersion.FX11PLUS) {
            java.nio.file.Path path;
            String sdkPath = InstanceScope.INSTANCE.getNode("org.eclipse.fx.ide.ui").get("javafx-sdk", null);
            ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
            if (sdkPath != null && Files.exists(path = Paths.get(sdkPath, new String[0]), new LinkOption[0])) {
                try {
                    entries.addAll(Files.list(path).filter(p -> p.getFileName().toString().endsWith(".jar")).map(p -> {
                        IClasspathAttribute moduleAttr = JavaCore.newClasspathAttribute((String)"module", (String)"true");
                        return JavaCore.newLibraryEntry((IPath)new Path(p.toAbsolutePath().toString()), (IPath)new Path(p.getParent().resolve("src.zip").toAbsolutePath().toString()), (IPath)new Path("."), (IAccessRule[])new IAccessRule[]{JavaCore.newAccessRule((IPath)new Path("javafx/*"), (int)0), JavaCore.newAccessRule((IPath)new Path("com/sun/*"), (int)2), JavaCore.newAccessRule((IPath)new Path("netscape/javascript/*"), (int)2)}, (IClasspathAttribute[])new IClasspathAttribute[]{moduleAttr}, (boolean)false);
                    }).collect(Collectors.toList()));
                }
                catch (IOException e) {
                    throw new IllegalStateException();
                }
            }
            return entries;
        }
        return Collections.emptyList();
    }

    public static FXVersion getFXVersion(IJavaProject project) {
        try {
            IVMInstall i = JavaRuntime.getVMInstall((IJavaProject)project);
            if (i == null) {
                i = JavaRuntime.getDefaultVMInstall();
            }
            return FXVersionUtil.getFxVersion(i);
        }
        catch (CoreException e) {
            throw new IllegalStateException(e);
        }
    }

    public static IPath[] getFxJarPath(IJavaProject project) {
        Object jarLocationPath = null;
        Object javadocLocation = null;
        Object antJarLocationPath = null;
        Object sourceLocationPath = null;
        try {
            IVMInstall i = JavaRuntime.getVMInstall((IJavaProject)project);
            if (i == null) {
                i = JavaRuntime.getDefaultVMInstall();
            }
            if (FXVersionUtil.getFxVersion(i) != FXVersion.FX9) {
                return BuildPathSupport.getFxJarPath(i);
            }
            return null;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new IPath[]{jarLocationPath, javadocLocation, antJarLocationPath, sourceLocationPath};
        }
    }

    public static IPath[] getSwtFxJarPath(IVMInstall i) {
        File installDir = i.getInstallLocation();
        IPath[] checkPaths = new IPath[]{new Path(installDir.getAbsolutePath()).append("jre").append("lib").append("jfxswt.jar"), new Path(installDir.getAbsolutePath()).append("lib").append("jfxswt.jar"), new Path(installDir.getAbsolutePath()).append("lib").append("javafx-swt.jar")};
        IPath jarLocationPath = null;
        Object javadocLocation = null;
        IPath sourceLocationPath = null;
        jarLocationPath = checkPaths[0];
        if (!jarLocationPath.toFile().exists()) {
            IPath[] iPathArray = checkPaths;
            int n = checkPaths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath p = iPathArray[n2];
                if (p.toFile().exists()) {
                    jarLocationPath = p;
                    break;
                }
                ++n2;
            }
        }
        if (jarLocationPath.toFile().exists()) {
            sourceLocationPath = new Path(installDir.getAbsolutePath()).append("javafx-src.zip");
            return new IPath[]{jarLocationPath, javadocLocation, sourceLocationPath};
        }
        return null;
    }

    public static IPath[] getFxJarPath(IVMInstall i) {
        IPath p;
        int n;
        int n2;
        IPath[] iPathArray;
        LibraryLocation[] libraryLocationArray = JavaRuntime.getLibraryLocations((IVMInstall)i);
        int n3 = libraryLocationArray.length;
        int n4 = 0;
        while (n4 < n3) {
            LibraryLocation l = libraryLocationArray[n4];
            if ("jfxrt.jar".equals(l.getSystemLibraryPath().lastSegment())) {
                return null;
            }
            ++n4;
        }
        IPath jarLocationPath = null;
        IPath javadocLocation = null;
        IPath antJarLocationPath = null;
        IPath sourceLocationPath = null;
        File installDir = i.getInstallLocation();
        IPath[] checkPaths = new IPath[]{new Path(installDir.getAbsolutePath()).append("jre").append("lib").append("jfxrt.jar"), new Path(installDir.getAbsolutePath()).append("lib").append("jfxrt.jar")};
        jarLocationPath = checkPaths[0];
        if (!jarLocationPath.toFile().exists()) {
            iPathArray = checkPaths;
            n2 = checkPaths.length;
            n = 0;
            while (n < n2) {
                p = iPathArray[n];
                if (p.toFile().exists()) {
                    jarLocationPath = p;
                    break;
                }
                ++n;
            }
        }
        if (!jarLocationPath.toFile().exists()) {
            LOGGER.error("Unable to detect JavaFX jar for JRE " + i.getName());
            LOGGER.error("\tJRE: " + installDir.getAbsolutePath());
            LOGGER.error("\tChecked paths:");
            iPathArray = checkPaths;
            n2 = checkPaths.length;
            n = 0;
            while (n < n2) {
                p = iPathArray[n];
                LOGGER.error("\t\t" + p.toFile().getAbsolutePath());
                ++n;
            }
            return null;
        }
        javadocLocation = new Path(installDir.getParentFile().getAbsolutePath()).append("docs").append("api");
        if (!javadocLocation.toFile().exists() && (p = new Path(System.getProperty("user.home")).append("javafx-api-" + i.getName()).append("docs").append("api")).toFile().exists()) {
            javadocLocation = p;
        }
        antJarLocationPath = new Path(installDir.getParent()).append("lib").append("ant-javafx.jar");
        sourceLocationPath = new Path(installDir.getAbsolutePath()).append("javafx-src.zip");
        if (!sourceLocationPath.toFile().exists()) {
            sourceLocationPath = null;
        }
        return new IPath[]{jarLocationPath, javadocLocation, antJarLocationPath, sourceLocationPath};
    }
}

