/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.rrobot.model.bundle;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Cardinality implements Enumerator
{
    SINGLE_OPTIONAL(0, "SINGLE_OPTIONAL", "SINGLE_OPTIONAL"),
    SINGLE_REQUIRED(1, "SINGLE_REQUIRED", "SINGLE_REQUIRED"),
    MULTI_OPTIONAL(2, "MULTI_OPTIONAL", "MULTI_OPTIONAL"),
    MULTI_REQUIRED(3, "MULTI_REQUIRED", "MULTI_REQUIRED");

    public static final int SINGLE_OPTIONAL_VALUE = 0;
    public static final int SINGLE_REQUIRED_VALUE = 1;
    public static final int MULTI_OPTIONAL_VALUE = 2;
    public static final int MULTI_REQUIRED_VALUE = 3;
    private static final Cardinality[] VALUES_ARRAY;
    public static final List<Cardinality> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Cardinality[]{SINGLE_OPTIONAL, SINGLE_REQUIRED, MULTI_OPTIONAL, MULTI_REQUIRED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Cardinality get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Cardinality result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Cardinality getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Cardinality result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Cardinality get(int value) {
        switch (value) {
            case 0: {
                return SINGLE_OPTIONAL;
            }
            case 1: {
                return SINGLE_REQUIRED;
            }
            case 2: {
                return MULTI_OPTIONAL;
            }
            case 3: {
                return MULTI_REQUIRED;
            }
        }
        return null;
    }

    private Cardinality(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

