/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.rrobot.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.fx.ide.rrobot.ProjectHandler;
import org.eclipse.fx.ide.rrobot.model.task.File;
import org.eclipse.fx.ide.rrobot.model.task.Folder;
import org.eclipse.fx.ide.rrobot.model.task.Project;
import org.eclipse.fx.ide.rrobot.model.task.Resource;
import org.eclipse.fx.ide.rrobot.model.task.TaskPackage;

public class DefaultProjectHandler<P extends Project>
implements ProjectHandler<P> {
    static final String PLUGIN_ID = "org.eclipse.fx.ide.rrobot";

    @Override
    public boolean isHandled(EClass eClass) {
        return eClass == TaskPackage.Literals.PROJECT;
    }

    @Override
    public IStatus createProject(IProgressMonitor monitor, P project, Map<String, Object> additionalData) {
        IProject p;
        block5: {
            if (project.getExcludeExpression() != null && project.getExcludeExpression().execute(additionalData)) {
                return new Status(0, PLUGIN_ID, "Resource '" + project.getName() + "' is excluded");
            }
            IWorkspaceRoot r = ResourcesPlugin.getWorkspace().getRoot();
            p = r.getProject(project.getName());
            if (!p.exists()) {
                try {
                    p.create(monitor);
                    p.open(monitor);
                    IStatus s = this.createResources(monitor, p, project, additionalData);
                    if (!s.isOK()) {
                        return s;
                    }
                    break block5;
                }
                catch (CoreException e) {
                    return new Status(4, PLUGIN_ID, "Unable to create project '" + project.getName() + "'", (Throwable)e);
                }
            }
            return new Status(4, PLUGIN_ID, "Project '" + project.getName() + "' already exists.");
        }
        return this.customizeProject(monitor, p, project);
    }

    protected IStatus customizeProject(IProgressMonitor monitor, IProject project, P model) {
        return Status.OK_STATUS;
    }

    protected IStatus createResources(IProgressMonitor monitor, IProject p, P model, Map<String, Object> additionalData) {
        ArrayList<Object> l = new ArrayList<Object>();
        for (Resource r : model.getResources()) {
            IFolder f;
            if (DefaultProjectHandler.exclude(r, additionalData)) {
                l.add(new Status(0, PLUGIN_ID, "Resource '" + r.getName() + "' exluded from generation"));
                continue;
            }
            if (r instanceof Folder) {
                f = p.getFolder(r.getName());
                if (!f.exists()) {
                    try {
                        f.create(true, true, monitor);
                        l.add(new Status(0, PLUGIN_ID, "Folder '" + f.getFullPath() + "' created"));
                    }
                    catch (CoreException e) {
                        l.add(new Status(4, PLUGIN_ID, "Unable to create folder '" + r.getName() + "'", (Throwable)e));
                    }
                }
                if (!f.exists()) continue;
                l.add(this.createResources(monitor, f, (Folder)r, additionalData));
                continue;
            }
            f = p.getFile(r.getName());
            l.add(this.createFile(monitor, (IFile)f, (File)r, additionalData));
        }
        return new MultiStatus(PLUGIN_ID, 0, l.toArray(new IStatus[0]), "Failed to create files", null);
    }

    protected IStatus createResources(IProgressMonitor monitor, IFolder folder, Folder model, Map<String, Object> additionalData) {
        ArrayList<Object> l = new ArrayList<Object>();
        for (Resource r : model.getChildren()) {
            IFolder f;
            if (DefaultProjectHandler.exclude(r, additionalData)) {
                l.add(new Status(0, PLUGIN_ID, "Resource '" + r.getName() + "' exluded from generation"));
                continue;
            }
            if (r instanceof Folder) {
                f = folder.getFolder(r.getName());
                if (!f.exists()) {
                    try {
                        f.create(true, true, monitor);
                        l.add(new Status(0, PLUGIN_ID, "Folder '" + f.getFullPath() + "' created"));
                    }
                    catch (CoreException e) {
                        l.add(new Status(4, PLUGIN_ID, "Unable to create folder '" + r.getName() + "'", (Throwable)e));
                    }
                }
                if (!f.exists()) continue;
                l.add(this.createResources(monitor, f, (Folder)r, additionalData));
                continue;
            }
            f = folder.getFile(r.getName());
            l.add(this.createFile(monitor, (IFile)f, (File)r, additionalData));
        }
        return new MultiStatus(PLUGIN_ID, 0, l.toArray(new IStatus[0]), "Failed to create files", null);
    }

    protected IStatus createFile(IProgressMonitor monitor, IFile f, File file, Map<String, Object> additionalData) {
        if (DefaultProjectHandler.exclude((Resource)file, additionalData)) {
            return new Status(0, PLUGIN_ID, "Resource '" + file.getName() + "' exluded from generation");
        }
        InputStream source = null;
        try {
            source = file.getContent(monitor, additionalData);
            f.create(source, 2, monitor);
        }
        catch (CoreException e) {
            Status status = new Status(4, PLUGIN_ID, "Unable to create file '" + f.getFullPath() + "'", (Throwable)e);
            try {
                if (source != null) {
                    source.close();
                }
            }
            catch (IOException iOException) {}
            return status;
        }
        catch (IOException e) {
            Status status;
            try {
                status = new Status(4, PLUGIN_ID, "Unable to create file '" + f.getFullPath() + "'", (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        source.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (source != null) {
                    source.close();
                }
            }
            catch (IOException iOException) {}
            return status;
        }
        try {
            if (source != null) {
                source.close();
            }
        }
        catch (IOException iOException) {}
        return Status.OK_STATUS;
    }

    public static void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    protected static IFolder getProjectFolder(IProject proj, Folder folder) {
        ArrayList<Folder> parentHierarchy = new ArrayList<Folder>();
        parentHierarchy.add(folder);
        while (folder.eContainer() instanceof Folder) {
            folder = (Folder)folder.eContainer();
            parentHierarchy.add(folder);
        }
        Collections.reverse(parentHierarchy);
        Path p = new Path(((Folder)parentHierarchy.get(0)).getName());
        int i = 1;
        while (i < parentHierarchy.size()) {
            p.append(((Folder)parentHierarchy.get(i)).getName());
            ++i;
        }
        return proj.getFolder((IPath)p);
    }

    protected static boolean exclude(Resource model, Map<String, Object> additionalData) {
        if (model.getExcludeExpression() != null) {
            return model.getExcludeExpression().execute(additionalData);
        }
        return false;
    }
}

