/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property.list;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.MultiList;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.ListProperty;
import org.eclipse.core.internal.databinding.property.PropertyObservableUtil;

public class MultiListProperty<S, E>
extends ListProperty<S, E> {
    private IListProperty<S, E>[] properties;
    private Object elementType;

    public MultiListProperty(IListProperty<S, E>[] properties) {
        this(properties, null);
    }

    public MultiListProperty(IListProperty<S, E>[] properties, Object elementType) {
        this.properties = properties;
        this.elementType = elementType;
    }

    @Override
    public Object getElementType() {
        return this.elementType;
    }

    @Override
    protected List<E> doGetList(S source) {
        ArrayList<E> list = new ArrayList<E>();
        IListProperty<S, E>[] iListPropertyArray = this.properties;
        int n = this.properties.length;
        int n2 = 0;
        while (n2 < n) {
            IListProperty<S, E> property = iListPropertyArray[n2];
            list.addAll(property.getList(source));
            ++n2;
        }
        return list;
    }

    @Override
    protected void doUpdateList(final S source, ListDiff<E> diff) {
        diff.accept(new ListDiffVisitor<E>(){

            public void handleAdd(int index, E element) {
                throw new UnsupportedOperationException();
            }

            public void handleMove(int oldIndex, int newIndex, E element) {
                throw new UnsupportedOperationException();
            }

            public void handleReplace(int index, E oldElement, E newElement) {
                int offset = 0;
                IListProperty[] iListPropertyArray = MultiListProperty.this.properties;
                int n = iListPropertyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IListProperty property = iListPropertyArray[n2];
                    List subList = property.getList(source);
                    if (index - offset < subList.size()) {
                        int subListIndex = index - offset;
                        ArrayList<ListDiffEntry> entries = new ArrayList<ListDiffEntry>(2);
                        entries.add(Diffs.createListDiffEntry((int)subListIndex, (boolean)false, oldElement));
                        entries.add(Diffs.createListDiffEntry((int)subListIndex, (boolean)true, newElement));
                        ListDiff diff = Diffs.createListDiff(entries);
                        property.updateList(source, diff);
                        return;
                    }
                    offset += subList.size();
                    ++n2;
                }
                throw new IndexOutOfBoundsException("index: " + index + ", size: " + offset);
            }

            public void handleRemove(int index, E element) {
                int offset = 0;
                IListProperty[] iListPropertyArray = MultiListProperty.this.properties;
                int n = iListPropertyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int subListIndex = index - offset;
                    IListProperty property = iListPropertyArray[n2];
                    List subList = property.getList(source);
                    if (subListIndex < subList.size()) {
                        ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)subListIndex, (boolean)false, element));
                        property.updateList(source, diff);
                        return;
                    }
                    offset += subList.size();
                    ++n2;
                }
                throw new IndexOutOfBoundsException("index: " + index + ", size: " + offset);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IObservableList<E> observe(Realm realm, S source) {
        void var5_8;
        ArrayList<IObservableList<E>> lists = new ArrayList<IObservableList<E>>(this.properties.length);
        IListProperty<S, E>[] iListPropertyArray = this.properties;
        int n = this.properties.length;
        boolean n2 = false;
        while (var5_8 < n) {
            IListProperty<S, E> property = iListPropertyArray[var5_8];
            lists.add(property.observe(realm, source));
            ++var5_8;
        }
        MultiList multiList = new MultiList(lists, this.elementType);
        for (IObservableList iObservableList : lists) {
            PropertyObservableUtil.cascadeDispose((IObservable)multiList, (IObservable)iObservableList);
        }
        return multiList;
    }
}

