/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.bindings.internal;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.ListBinding;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class MapListBinding<A, B>
extends ListBinding<B> {
    private ObservableList<A> source;
    private Function<A, B> map;

    public MapListBinding(ObservableList<A> source, Function<A, B> map) {
        this.source = source;
        this.map = map;
        this.bind(new Observable[]{this.source});
    }

    protected ObservableList<B> computeValue() {
        return FXCollections.observableArrayList((Collection)this.source.stream().map(this.map).collect(Collectors.toList()));
    }

    public void dispose() {
        this.unbind(new Observable[]{this.source});
        super.dispose();
    }
}

