/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.preferences;

import org.apache.log4j.Logger;
import org.eclipse.xtext.preferences.TypedPreferenceKey;

public class IntegerKey
extends TypedPreferenceKey<Integer> {
    private static final Logger log = Logger.getLogger(IntegerKey.class);

    public IntegerKey(String id, Integer defaultValue) {
        super(id, defaultValue.toString());
    }

    @Override
    public String toString(Integer value) {
        return value.toString();
    }

    @Override
    public Integer toValue(String string) {
        try {
            if (string != null) {
                return Integer.valueOf(string);
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Couldn't parse value '" + string + "' of formatting preference '" + this.getId() + "'."));
        }
        return Integer.valueOf(this.getDefaultValue());
    }
}

