/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.osgi.service.event.Event;

public class PartOnTopManager {
    @Inject
    private EModelService modelService;

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    public void subscribeTopicWidget(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/widget/*") Event event) {
        Object element = event.getProperty("ChangedElement");
        Object newValue = event.getProperty("NewValue");
        if (element instanceof MPart && newValue != null) {
            this.handlePartSelection(null, element);
        }
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    public void subscribeTopicSelectedElement(@EventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*") Event event) {
        Object element = event.getProperty("ChangedElement");
        Object oldValue = event.getProperty("OldValue");
        Object newValue = event.getProperty("NewValue");
        if (element instanceof MPerspectiveStack) {
            this.handlePerspectiveSwitch(oldValue, newValue);
        } else if (element instanceof MPartStack) {
            this.handlePartSelection(oldValue, newValue);
        }
    }

    private void handlePerspectiveSwitch(Object oldValue, Object newValue) {
        this.handleNewAndOldSelectedElementsOfElementContainer(oldValue, newValue);
    }

    private void handlePartSelection(Object oldValue, Object newValue) {
        MPart contextElement;
        Object newElement;
        MPart contextElement2;
        Object oldElement = oldValue;
        if (oldElement instanceof MPlaceholder) {
            oldElement = ((MPlaceholder)oldElement).getRef();
        }
        if (oldElement instanceof MPart && (contextElement2 = (MPart)oldElement).getContext() != null) {
            contextElement2.getContext().set("elementOnTop", (Object)Boolean.FALSE);
        }
        if ((newElement = newValue) instanceof MPlaceholder) {
            newElement = ((MPlaceholder)newElement).getRef();
        }
        if (newElement instanceof MPart && (contextElement = (MPart)newElement).getContext() != null) {
            contextElement.getContext().set("elementOnTop", (Object)Boolean.TRUE);
        }
        this.handleNewAndOldSelectedElementsOfElementContainer(oldElement, newElement);
    }

    private void handleNewAndOldSelectedElementsOfElementContainer(Object oldValue, Object newValue) {
        if (newValue instanceof MElementContainer) {
            List<MPart> newParts = this.modelService.findElements((MUIElement)((MElementContainer)newValue), null, MPart.class, null);
            if (oldValue instanceof MElementContainer) {
                List<MPart> oldParts = this.modelService.findElements((MUIElement)((MElementContainer)oldValue), null, MPart.class, null);
                oldParts.forEach(part -> {
                    if (part.getContext() != null && !this.isPartOnTop(newParts, (MPart)part)) {
                        part.getContext().set("elementOnTop", (Object)Boolean.FALSE);
                    }
                });
            }
            this.handleNewSelectedElementsOfElementContainer(newParts);
        }
    }

    private boolean isPartOnTop(List<MPart> newParts, MPart part) {
        Optional<MPartStack> partStackContainer;
        if (part.getCurSharedRef() != null && newParts.contains(part) && (partStackContainer = this.getPartStackContainer((MUIElement)part.getCurSharedRef())).isPresent()) {
            return part.getCurSharedRef().equals(partStackContainer.get().getSelectedElement());
        }
        return false;
    }

    private void handleNewSelectedElementsOfElementContainer(List<MPart> parts) {
        parts.stream().filter(part -> {
            Optional<MPartStack> partStackContainer;
            if (part.getContext() == null) {
                return false;
            }
            MPart partRef = part;
            if (part.getCurSharedRef() != null) {
                partRef = part.getCurSharedRef();
            }
            if ((partStackContainer = this.getPartStackContainer((MUIElement)partRef)).isPresent()) {
                return partRef.equals(partStackContainer.get().getSelectedElement());
            }
            return true;
        }).forEach(part -> part.getContext().set("elementOnTop", (Object)Boolean.TRUE));
    }

    private Optional<MPartStack> getPartStackContainer(MUIElement uiElement) {
        MUIElement parent = this.modelService.getContainer(uiElement);
        if (parent instanceof MPartStack) {
            return Optional.of((MPartStack)parent);
        }
        if (parent instanceof MWindow) {
            return Optional.empty();
        }
        return this.getPartStackContainer(parent);
    }
}

