/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeComment;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeHidden;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeModelBasedRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeSemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeWhitespace;
import org.eclipse.xtext.nodemodel.BidiIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;

public class NodeModelBasedRegionAccessBuilder {
    private Map<EObject, NodeEObjectRegion> eObjToTokens;
    private NodeHiddenRegion firstHidden;
    private NodeHiddenRegion lastHidden;
    private XtextResource resource;
    private LinkedList<NodeEObjectRegion> stack = new LinkedList();

    protected void add(NodeModelBasedRegionAccess access, INode node) {
        if (node instanceof ILeafNode && ((ILeafNode)node).isHidden()) {
            ILeafNode leafNode = (ILeafNode)node;
            this.lastHidden.addPart(this.createHidden(this.lastHidden, leafNode));
        } else if (node instanceof ICompositeNode || node.getLength() > 0) {
            NodeEObjectRegion eObjectTokens = this.stack.peek();
            NodeSemanticRegion newSemantic = this.createSemanticRegion(access, node);
            NodeHiddenRegion newHidden = this.createHiddenRegion(access);
            newSemantic.setTrailingHiddenRegion(newHidden);
            newHidden.setPrevious(newSemantic);
            newSemantic.setLeadingHiddenRegion(this.lastHidden);
            this.lastHidden.setNext(newSemantic);
            eObjectTokens.getSemanticRegions().add(newSemantic);
            newSemantic.setEObjectTokens(eObjectTokens);
            this.lastHidden = newHidden;
        }
    }

    public NodeModelBasedRegionAccess create() {
        NodeModelBasedRegionAccess access = new NodeModelBasedRegionAccess(this);
        return access;
    }

    protected NodeHidden createHidden(NodeHiddenRegion hidden, ILeafNode node) {
        if (this.isComment(node)) {
            return new NodeComment(hidden, (INode)node);
        }
        return new NodeWhitespace(hidden, (INode)node);
    }

    protected NodeHiddenRegion createHiddenRegion(ITextRegionAccess access) {
        return new NodeHiddenRegion(access);
    }

    protected NodeSemanticRegion createSemanticRegion(NodeModelBasedRegionAccess access, INode node) {
        return new NodeSemanticRegion(access, node);
    }

    protected NodeEObjectRegion createTokens(NodeModelBasedRegionAccess access, INode node) {
        return new NodeEObjectRegion(access, node);
    }

    protected Map<EObject, AbstractEObjectRegion> getEObjectToTokensMap(ITextRegionAccess regionAccess) {
        this.eObjToTokens = Maps.newHashMap();
        this.lastHidden = this.firstHidden = this.createHiddenRegion(regionAccess);
        NodeModelBasedRegionAccess access = (NodeModelBasedRegionAccess)regionAccess;
        ICompositeNode rootNode = this.resource.getParseResult().getRootNode();
        this.process(rootNode, access);
        return ImmutableMap.copyOf(this.eObjToTokens);
    }

    protected XtextResource getXtextResource() {
        return this.resource;
    }

    protected boolean include(INode node) {
        if (node instanceof ILeafNode) {
            return true;
        }
        if (node instanceof ICompositeNode) {
            EObject element = node.getGrammarElement();
            return GrammarUtil.isDatatypeRuleCall(element) || element instanceof CrossReference || GrammarUtil.isEnumRuleCall(element);
        }
        return false;
    }

    protected boolean isComment(ILeafNode leaf) {
        String text = leaf.getText();
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean isEObjectRoot(INode node) {
        if (node instanceof ICompositeNode) {
            ICompositeNode root;
            ICompositeNode parent;
            for (parent = node.getParent(); parent != null && GrammarUtil.isEObjectFragmentRuleCall(parent.getGrammarElement()); parent = parent.getParent()) {
            }
            if (parent == null) {
                return true;
            }
            for (root = parent; root != null && !root.hasDirectSemanticElement(); root = root.getParent()) {
            }
            if (root == null) {
                return false;
            }
            EObject element = node.getGrammarElement();
            if (GrammarUtil.isEObjectRuleCall(element) && !GrammarUtil.isEObjectFragmentRuleCall(element)) {
                if (!parent.hasDirectSemanticElement()) {
                    return false;
                }
                BidiIterator iterator = node.getAsTreeIterable().iterator();
                iterator.next();
                while (iterator.hasNext()) {
                    INode next = (INode)iterator.next();
                    if (next.hasDirectSemanticElement()) {
                        return true;
                    }
                    EObject ge = next.getGrammarElement();
                    if (ge instanceof Action) {
                        return true;
                    }
                    if (ge instanceof RuleCall && GrammarUtil.isAssigned(ge) && ((RuleCall)ge).getRule().getType().getClassifier() instanceof EDataType) {
                        return true;
                    }
                    if (!(ge instanceof CrossReference)) continue;
                    return true;
                }
            }
            if (element instanceof Action) {
                return parent.hasDirectSemanticElement();
            }
        }
        return false;
    }

    protected EObject findGrammarElement(INode node, EObject obj) {
        String feature = obj.eContainingFeature().getName();
        for (INode current = node; current != null; current = current.getParent()) {
            EObject grammarElement = current.getGrammarElement();
            Assignment assignment = GrammarUtil.containingAssignment(grammarElement);
            if (assignment != null && feature.equals(assignment.getFeature())) {
                return grammarElement;
            }
            if (grammarElement instanceof Action) {
                Action action = (Action)grammarElement;
                if (feature.equals(action.getFeature())) {
                    return grammarElement;
                }
                if (current == node && current instanceof ICompositeNode) {
                    INode child = ((ICompositeNode)current).getFirstChild();
                    while (child instanceof ICompositeNode) {
                        EObject grammarElement2 = child.getGrammarElement();
                        Assignment assignment2 = GrammarUtil.containingAssignment(grammarElement2);
                        if (assignment2 != null && feature.equals(assignment2.getFeature())) {
                            return grammarElement2;
                        }
                        child = ((ICompositeNode)child).getFirstChild();
                    }
                }
            }
            if (!current.hasDirectSemanticElement() || current.getSemanticElement() == obj) continue;
            return null;
        }
        return null;
    }

    protected void process(INode node, NodeModelBasedRegionAccess access) {
        Iterator element;
        NodeEObjectRegion tokens = this.stack.peek();
        boolean creator = this.isEObjectRoot(node);
        if (creator || tokens == null) {
            tokens = new NodeEObjectRegion(access, node);
            tokens.setLeadingHiddenRegion(this.lastHidden);
            this.stack.push(tokens);
        }
        if (tokens.getSemanticElement() == null) {
            if (node.getParent() == null) {
                tokens.setSemanticElement((EObject)this.resource.getContents().get(0));
                element = node.getGrammarElement();
                if (element instanceof Action) {
                    element = ((ICompositeNode)node).getFirstChild().getGrammarElement();
                }
                tokens.setGrammarElement((EObject)element);
            } else if (node.hasDirectSemanticElement()) {
                tokens.setSemanticElement(node.getSemanticElement());
                tokens.setGrammarElement(this.findGrammarElement(node, tokens.getSemanticElement()));
            }
        }
        if (this.include(node)) {
            if (node instanceof ICompositeNode) {
                ILeafNode leaf;
                element = node.getLeafNodes().iterator();
                while (element.hasNext() && (leaf = (ILeafNode)element.next()).isHidden()) {
                    this.add(access, leaf);
                }
            }
            this.add(access, node);
        } else if (node instanceof ICompositeNode) {
            for (INode child : ((ICompositeNode)node).getChildren()) {
                this.process(child, access);
            }
        }
        if (creator) {
            NodeEObjectRegion popped = this.stack.pop();
            popped.setTrailingHiddenRegion(this.lastHidden);
            EObject semanticElement = popped.getSemanticElement();
            if (semanticElement == null) {
                throw new IllegalStateException();
            }
            if (!this.stack.isEmpty() && semanticElement.eContainer() != this.stack.peek().getSemanticElement()) {
                throw new IllegalStateException();
            }
            EObject grammarElement = popped.getGrammarElement();
            if (grammarElement == null) {
                throw new IllegalStateException();
            }
            NodeEObjectRegion old = this.eObjToTokens.put(semanticElement, popped);
            if (old != null) {
                throw new IllegalStateException();
            }
        }
    }

    public NodeModelBasedRegionAccessBuilder withResource(XtextResource resource) {
        this.resource = resource;
        return this;
    }
}

