/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class ImportUriValidator
extends AbstractDeclarativeValidator {
    public static final String UNRESOLVABLE_IMPORT_URI = "unresolvable_import_uri";
    @Inject
    private ImportUriResolver resolver;

    @Check(value=CheckType.FAST)
    public void checkImportUriIsValid(EObject object) {
        String importURI = this.getResolver().resolve(object);
        if (importURI != null && !EcoreUtil2.isValidUri(object, URI.createURI((String)importURI))) {
            this.error("Imported resource could not be found.", this.getResolver().getAttribute(object), UNRESOLVABLE_IMPORT_URI, new String[0]);
        }
    }

    @Override
    public void register(EValidatorRegistrar registrar) {
    }

    public void setResolver(ImportUriResolver resolver) {
        this.resolver = resolver;
    }

    public ImportUriResolver getResolver() {
        return this.resolver;
    }
}

