/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.fx.core.text.TextUtil;
import org.eclipse.fx.ui.controls.styledtext.StyleRange;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.StyledTextContent;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.fx.ui.controls.styledtext.internal.Segment;
import org.eclipse.fx.ui.controls.styledtext.model.Annotation;
import org.eclipse.fx.ui.controls.styledtext.model.AnnotationProvider;
import org.eclipse.fx.ui.controls.styledtext.model.TextAnnotation;
import org.eclipse.jdt.annotation.NonNull;

public class LineHelper {
    private StyledTextArea control;

    public LineHelper(StyledTextArea control) {
        this.control = control;
    }

    private StyledTextContent getContent() {
        return this.control.getContent();
    }

    private Range<Integer> getSelection() {
        @NonNull TextSelection selection = this.control.getSelection();
        return Range.closedOpen((Comparable)Integer.valueOf(selection.offset), (Comparable)Integer.valueOf(selection.offset + selection.length));
    }

    public boolean isValidLineIndex(int index) {
        return this.getContent().getLineCount() > index;
    }

    private int getCaretOffset() {
        return this.control.getCaretOffset();
    }

    private StyleRange[] getStyleRanges(int start, int length, boolean includeRanges) {
        return this.control.getStyleRanges(start, length, includeRanges);
    }

    private Set<AnnotationProvider> getAnnotationProvider() {
        return this.control.getAnnotationProvider();
    }

    public int getOffset(int index) {
        return this.getContent().getOffsetAtLine(index);
    }

    public int getLength(int index) {
        return this.getText(index).length();
    }

    public int getLengthCountTabsAsChars(int index) {
        String t = this.getText(index);
        return t.length() + LineHelper.countTabs(t) * (this.control.getTabAdvance() - 1);
    }

    public String getText(int index) {
        return this.getContent().getLine(index);
    }

    public Range<Integer> getRange(int index) {
        int lower = this.getOffset(index);
        int upper = lower + this.getLength(index);
        return Range.closed((Comparable)Integer.valueOf(lower), (Comparable)Integer.valueOf(upper));
    }

    private int mapToLocal(int index, int globalOffset) {
        return globalOffset - this.getOffset(index);
    }

    private Range<Integer> mapToLocal(int index, Range<Integer> global) {
        return Range.range((Comparable)Integer.valueOf((Integer)global.lowerEndpoint() - this.getOffset(index)), (BoundType)global.lowerBoundType(), (Comparable)Integer.valueOf((Integer)global.upperEndpoint() - this.getOffset(index)), (BoundType)global.upperBoundType());
    }

    public Range<Integer> getSelection(int index) {
        Range<Integer> selection = this.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        Range<Integer> range = this.getRange(index);
        Range<Integer> localSelection = null;
        if (range.isConnected(selection)) {
            Range intersection = selection.intersection(range);
            localSelection = this.mapToLocal(index, (Range<Integer>)intersection);
        }
        return localSelection;
    }

    public int getCaret(int index) {
        int globalCaret = this.getCaretOffset();
        Range<Integer> range = this.getRange(index);
        if (range.contains((Comparable)Integer.valueOf(globalCaret))) {
            return this.mapToLocal(index, globalCaret);
        }
        return -1;
    }

    private static Segment createSegement(String text, StyleRange style) {
        ArrayList<String> styleClasses = new ArrayList<String>();
        if (style.stylename != null) {
            if (style.stylename.contains(".")) {
                ArrayList<String> styles = new ArrayList<String>(Arrays.asList(style.stylename.split("\\.")));
                styles.add(0, "source-segment");
                styleClasses.addAll(styles);
            } else {
                styleClasses.add("source-segment");
                styleClasses.add(style.stylename);
            }
        } else if (style.foreground != null) {
            styleClasses.add("plain-source-segment");
        } else {
            styleClasses.add("source-segment");
        }
        return new Segment(text, styleClasses);
    }

    static String removeLineending(String s) {
        return TextUtil.stripOff((String)s, c -> c == 13 || c == 10);
    }

    public List<Segment> getSegments(int index) {
        int length;
        ArrayList<Segment> segments = new ArrayList<Segment>();
        String line = this.getContent().getLine(index);
        int start = this.getContent().getOffsetAtLine(index);
        StyleRange[] ranges = this.getStyleRanges(start, length = line.length(), true);
        if (ranges == null) {
            return Collections.emptyList();
        }
        if (ranges.length == 0 && line.length() > 0) {
            StyleRange styleRange = new StyleRange(null);
            styleRange.start = start;
            styleRange.length = line.length();
            String text = LineHelper.removeLineending(line.substring(0, line.length()));
            segments.add(LineHelper.createSegement(text, styleRange));
        } else {
            StyleRange styleRange;
            int lastIndex = -1;
            if (ranges.length > 0 && ranges[0].start - start > 0) {
                styleRange = new StyleRange(null);
                styleRange.start = start;
                styleRange.length = ranges[0].start - start;
                String text = LineHelper.removeLineending(line.substring(0, ranges[0].start - start));
                segments.add(LineHelper.createSegement(text, styleRange));
            }
            StyleRange[] styleRangeArray = ranges;
            int n = ranges.length;
            int text = 0;
            while (text < n) {
                StyleRange r = styleRangeArray[text];
                int begin = r.start - start;
                int end = r.start - start + r.length;
                if (lastIndex != -1 && lastIndex != begin) {
                    StyleRange styleRange2 = new StyleRange(null);
                    styleRange2.start = start + lastIndex;
                    styleRange2.length = begin - lastIndex;
                    String text2 = LineHelper.removeLineending(line.substring(lastIndex, begin));
                    segments.add(LineHelper.createSegement(text2, styleRange2));
                }
                String text3 = LineHelper.removeLineending(line.substring(begin, end));
                segments.add(LineHelper.createSegement(text3, r));
                lastIndex = end;
                ++text;
            }
            if (lastIndex > 0 && lastIndex < line.length()) {
                styleRange = new StyleRange(null);
                styleRange.start = start + lastIndex;
                styleRange.length = line.length() - lastIndex;
                String text4 = LineHelper.removeLineending(line.substring(lastIndex, line.length()));
                segments.add(LineHelper.createSegement(text4, styleRange));
            }
        }
        return segments;
    }

    public Set<TextAnnotation> getTextAnnotations(int index) {
        return this.getAnnotations(index).stream().filter(m -> m instanceof TextAnnotation).map(m -> (TextAnnotation)m).collect(Collectors.toSet());
    }

    public Set<Annotation> getAnnotations(int index) {
        Set<Annotation> result = this.getAnnotationProvider().stream().map(p -> p.computeAnnotations(index)).flatMap(Collection::stream).collect(Collectors.toSet());
        return result;
    }

    private static int countTabs(String s) {
        int count = 0;
        char[] cs = s.toCharArray();
        int i = 0;
        while (i < s.length()) {
            if (cs[i] == '\t') {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

