/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.tree;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.TreeItem;
import org.eclipse.fx.core.ReflectionUtil;
import org.eclipse.fx.ui.controls.tree.TreeItemPredicate;

public class FilterableTreeItem<T>
extends TreeItem<T> {
    private final ObservableList<TreeItem<T>> sourceList;
    private final FilteredList<TreeItem<T>> filteredList;
    private ObjectProperty<TreeItemPredicate<T>> predicate = new SimpleObjectProperty();

    public FilterableTreeItem(T value) {
        super(value);
        this.sourceList = FXCollections.observableArrayList();
        this.filteredList = new FilteredList(this.sourceList);
        this.filteredList.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> child -> {
            if (child instanceof FilterableTreeItem) {
                FilterableTreeItem filterableChild = (FilterableTreeItem)((Object)((Object)child));
                filterableChild.setPredicate((TreeItemPredicate)this.predicate.get());
            }
            if (this.predicate.get() == null) {
                return true;
            }
            if (child.getChildren().size() > 0) {
                return true;
            }
            return ((TreeItemPredicate)this.predicate.get()).test(this, child.getValue());
        }, (Observable[])new Observable[]{this.predicate}));
        this.setHiddenFieldChildren((ObservableList<TreeItem<T>>)this.filteredList);
    }

    protected void setHiddenFieldChildren(ObservableList<TreeItem<T>> list) {
        ReflectionUtil.setFieldValue((Object)((Object)this), (String)"children", list);
        Object childrenListener = ReflectionUtil.getFieldValue((Object)((Object)this), (String)"childrenListener");
        list.addListener((ListChangeListener)childrenListener);
    }

    public ObservableList<TreeItem<T>> getInternalChildren() {
        return this.sourceList;
    }

    public final ObjectProperty<TreeItemPredicate<T>> predicateProperty() {
        return this.predicate;
    }

    public final TreeItemPredicate<T> getPredicate() {
        return (TreeItemPredicate)this.predicate.get();
    }

    public final void setPredicate(TreeItemPredicate<T> predicate) {
        this.predicate.set(predicate);
    }
}

