/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.xtext.formatting2.ITextSegment;
import org.eclipse.xtext.formatting2.internal.TextSegment;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.TextRegion;

public abstract class AbstractTextSegment
implements ITextSegment {
    @Override
    public int compareTo(ITextSegment o) {
        int cmp1 = this.getOffset() - o.getOffset();
        if (cmp1 != 0) {
            return cmp1;
        }
        int cmp2 = this.getLength() - o.getLength();
        if (cmp2 != 0) {
            return cmp2;
        }
        return 0;
    }

    public boolean contains(int offset) {
        int thisOffset = this.getOffset();
        return offset >= thisOffset && offset < thisOffset + this.getLength();
    }

    public boolean contains(ITextRegion other) {
        int offset = this.getOffset();
        int length = this.getLength();
        return other.getOffset() + other.getLength() <= offset + length && other.getOffset() >= offset;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractTextSegment other = (AbstractTextSegment)obj;
        return this.getOffset() == other.getOffset() && this.getLength() == other.getLength();
    }

    @Override
    public int getEndOffset() {
        return this.getOffset() + this.getLength();
    }

    @Override
    public ITextSegment getIndentation() {
        return this.getTextRegionAccess().indentationRegion(this.getOffset());
    }

    @Override
    public int getLineCount() {
        return Strings.countLines((String)this.getText());
    }

    @Override
    public String getText() {
        ITextRegionAccess tokenAccess = this.getTextRegionAccess();
        if (tokenAccess != null) {
            return tokenAccess.getText(this.getOffset(), this.getLength());
        }
        return null;
    }

    public int hashCode() {
        return this.getOffset() + 31 * this.getLength();
    }

    @Override
    public boolean isMultiline() {
        return this.getText().contains("\n");
    }

    public ITextRegion merge(ITextRegion other) {
        if (this.contains(other)) {
            return this;
        }
        if (other.contains((ITextRegion)this)) {
            return other;
        }
        int offset = this.getOffset();
        int length = this.getLength();
        int newOffset = Math.min(offset, other.getOffset());
        int newLength = Math.max(offset + length, other.getOffset() + other.getLength()) - newOffset;
        return new TextRegion(newOffset, newLength);
    }

    @Override
    public List<ITextSegment> splitIntoLines() {
        int index;
        ITextRegionAccess access = this.getTextRegionAccess();
        ArrayList result = Lists.newArrayList();
        String text = this.getText();
        int lastIndex = 0;
        int offset = this.getOffset();
        while ((index = text.indexOf(10, lastIndex)) >= 0) {
            int end = index > 0 && text.charAt(index - 1) == '\r' ? index - 1 : index;
            result.add(new TextSegment(access, offset + lastIndex, end - lastIndex));
            lastIndex = index + 1;
        }
        result.add(new TextSegment(access, offset + lastIndex, text.length() - lastIndex));
        return ImmutableList.copyOf((Collection)result);
    }
}

