/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.debug;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.xtext.formatting2.ITextReplacement;
import org.eclipse.xtext.formatting2.ITextSegment;
import org.eclipse.xtext.formatting2.TextReplacements;
import org.eclipse.xtext.formatting2.internal.TextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;

public class TextRegionsWithTitleToString {
    private ITextSegment frame;
    private List<Item> items = Lists.newArrayList();
    private int leadingLines = 4;
    private ITextRegionAccess textRegionAccess;
    private int trailingLines = 4;
    private final String[] BRACKETS_OPEN = new String[]{"{{{", "[[[", "(((", "<<<"};
    private final String[] BRACKETS_CLOSE = new String[]{"}}}", "]]]", ")))", ">>>"};

    public TextRegionsWithTitleToString add(String title, ITextSegment region) {
        this.items.add(new Item(title, region));
        return this;
    }

    protected String box(String title, String content) {
        int width = 80;
        int min = 3;
        int titleLength = title.length() + 2;
        int left = Math.max((80 - titleLength) / 2, 3);
        StringBuilder result = new StringBuilder();
        result.append(Strings.repeat((String)"-", (int)left));
        result.append(" ");
        result.append(title);
        result.append(" ");
        if (left > 3) {
            result.append(Strings.repeat((String)"-", (int)(80 - left - titleLength)));
        }
        result.append("\n");
        result.append(org.eclipse.xtext.util.Strings.trimTrailingLineBreak((CharSequence)content));
        result.append("\n");
        result.append(Strings.repeat((String)"-", (int)80));
        return result.toString();
    }

    public ITextSegment getFrame() {
        if (this.frame != null) {
            return this.frame;
        }
        ArrayList segments = Lists.newArrayList();
        for (Item item : this.items) {
            segments.add(item.getRegion());
        }
        ITextSegment[] array = segments.toArray(new ITextSegment[segments.size()]);
        ITextRegionAccess regionAccess = this.getTextRegionAccess();
        if (regionAccess != null) {
            return regionAccess.expandRegionsByLines(this.getLeadingLines(), this.getTrailingLines(), array);
        }
        return null;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public int getLeadingLines() {
        return this.leadingLines;
    }

    public ITextRegionAccess getTextRegionAccess() {
        if (this.textRegionAccess != null) {
            return this.textRegionAccess;
        }
        Iterator<Item> iterator = this.items.iterator();
        if (iterator.hasNext()) {
            Item item = iterator.next();
            return item.region.getTextRegionAccess();
        }
        return null;
    }

    public int getTrailingLines() {
        return this.trailingLines;
    }

    public TextRegionsWithTitleToString setFrame(ITextSegment frame) {
        this.frame = frame;
        return this;
    }

    public TextRegionsWithTitleToString setLeadingLines(int leadingLines) {
        this.leadingLines = leadingLines;
        return this;
    }

    public TextRegionsWithTitleToString setTextRegionAccess(ITextRegionAccess textRegionAccess) {
        this.textRegionAccess = textRegionAccess;
        return this;
    }

    public TextRegionsWithTitleToString setTrailingLines(int trailingLines) {
        this.trailingLines = trailingLines;
        return this;
    }

    public String toString() {
        ITextRegionAccess access = this.getTextRegionAccess();
        ITextSegment frame = this.getFrame();
        if (access == null || frame == null) {
            return "(null)";
        }
        StringBuilder builder = new StringBuilder();
        ArrayList replacements = Lists.newArrayList();
        int i = 0;
        while (i < this.items.size()) {
            Item item = this.items.get(i);
            ITextSegment region = item.getRegion();
            String regionStr = "offset=" + region.getOffset() + " length=" + region.getLength();
            String open = i < this.BRACKETS_OPEN.length ? this.BRACKETS_OPEN[i] : "[" + i + "[";
            String close = i < this.BRACKETS_CLOSE.length ? this.BRACKETS_CLOSE[i] : "]" + i + "]";
            builder.append(String.valueOf(open) + close + ": " + item.getTitle() + " at " + regionStr + "\n");
            replacements.add(new TextReplacement(access, region.getOffset(), 0, open));
            replacements.add(new TextReplacement(access, region.getEndOffset(), 0, close));
            ++i;
        }
        String vizualized = TextReplacements.apply(frame, (Iterable<? extends ITextReplacement>)replacements);
        builder.append(this.box("document snippet", vizualized));
        return builder.toString();
    }

    public static class Item {
        private final ITextSegment region;
        private final String title;

        public Item(String title, ITextSegment region) {
            this.title = title;
            this.region = region;
        }

        public ITextSegment getRegion() {
            return this.region;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

