/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.di.context.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.internal.di.Requestor;
import org.eclipse.fx.core.di.context.internal.PreferenceValue;
import org.eclipse.fx.core.preferences.Preference;
import org.eclipse.fx.core.preferences.Value;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;

@Component(service={ExtendedObjectSupplier.class}, property={"dependency.injection.annotation=org.eclipse.fx.core.preferences.Preference"})
public class PreferenceValueSupplier
extends ExtendedObjectSupplier {
    private Map<String, HashMap<String, List<PrefInjectionListener>>> listenerCache = new HashMap<String, HashMap<String, List<PrefInjectionListener>>>();

    public Object get(IObjectDescriptor descriptor, IRequestor requestor, boolean track, boolean group) {
        if (descriptor == null) {
            return null;
        }
        Class<?> descriptorsClass = PreferenceValueSupplier.getDesiredClass(descriptor.getDesiredType());
        String nodePath = PreferenceValueSupplier.getNodePath(descriptor, requestor.getRequestingObjectClass());
        if (nodePath == null || nodePath.length() == 0) {
            return IInjector.NOT_A_VALUE;
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(nodePath);
        if (preferences == null) {
            return IInjector.NOT_A_VALUE;
        }
        String key = PreferenceValueSupplier.getKey(descriptor);
        if (key == null || key.length() == 0) {
            return IInjector.NOT_A_VALUE;
        }
        if (descriptorsClass.equals(Boolean.TYPE) || descriptorsClass.equals(Boolean.class) || descriptorsClass.equals(Integer.TYPE) || descriptorsClass.equals(Integer.class) || descriptorsClass.equals(Double.TYPE) || descriptorsClass.equals(Double.class) || descriptorsClass.equals(Float.TYPE) || descriptorsClass.equals(Float.class) || descriptorsClass.equals(Long.TYPE) || descriptorsClass.equals(Long.class) || descriptorsClass.equals(String.class)) {
            if (track) {
                this.addListener(nodePath, key, requestor);
            }
            return PreferenceValueSupplier.getValue(preferences, key, descriptorsClass);
        }
        Class type = ((Preference)descriptor.getQualifier(Preference.class)).type();
        if (type == Object.class && descriptor.getDesiredType() instanceof ParameterizedType) {
            Type t = ((ParameterizedType)descriptor.getDesiredType()).getActualTypeArguments()[0];
            Class clazz = type = t instanceof ParameterizedType ? (Class)((ParameterizedType)t).getRawType() : (Class)t;
        }
        if (type == Object.class) {
            return IInjector.NOT_A_VALUE;
        }
        Requestor r = (Requestor)requestor;
        PreferenceValue v = (PreferenceValue)r.getInjector().make(PreferenceValue.class, r.getPrimarySupplier());
        v.init(key, preferences, type);
        if (descriptorsClass != Value.class) {
            return v.adaptTo(descriptorsClass);
        }
        return v;
    }

    public static <T> T getValue(IEclipsePreferences preference, String key, Class<T> descriptorsClass) {
        if (descriptorsClass.isPrimitive()) {
            if (descriptorsClass.equals(Boolean.TYPE)) {
                return (T)Boolean.valueOf(preference.getBoolean(key, false));
            }
            if (descriptorsClass.equals(Integer.TYPE)) {
                return (T)Integer.valueOf(preference.getInt(key, 0));
            }
            if (descriptorsClass.equals(Double.TYPE)) {
                return (T)Double.valueOf(preference.getDouble(key, 0.0));
            }
            if (descriptorsClass.equals(Float.TYPE)) {
                return (T)Float.valueOf(preference.getFloat(key, 0.0f));
            }
            if (descriptorsClass.equals(Long.TYPE)) {
                return (T)Long.valueOf(preference.getLong(key, 0L));
            }
        }
        if (String.class.equals(descriptorsClass)) {
            return (T)preference.get(key, null);
        }
        if (Boolean.class.equals(descriptorsClass)) {
            return (T)Boolean.valueOf(preference.getBoolean(key, false));
        }
        if (Integer.class.equals(descriptorsClass)) {
            return (T)Integer.valueOf(preference.getInt(key, 0));
        }
        if (Double.class.equals(descriptorsClass)) {
            return (T)Double.valueOf(preference.getDouble(key, 0.0));
        }
        if (Float.class.equals(descriptorsClass)) {
            return (T)Float.valueOf(preference.getFloat(key, 0.0f));
        }
        if (Long.class.equals(descriptorsClass)) {
            return (T)Long.valueOf(preference.getLong(key, 0L));
        }
        return (T)preference.get(key, null);
    }

    private static Class<?> getDesiredClass(Type desiredType) {
        Type rawType;
        if (desiredType instanceof Class) {
            return (Class)desiredType;
        }
        if (desiredType instanceof ParameterizedType && (rawType = ((ParameterizedType)desiredType).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    private static String getKey(IObjectDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Preference qualifier = (Preference)descriptor.getQualifier(Preference.class);
        return qualifier.key();
    }

    private static String getNodePath(IObjectDescriptor descriptor, Class<?> requestingObject) {
        if (descriptor == null) {
            return null;
        }
        Preference qualifier = (Preference)descriptor.getQualifier(Preference.class);
        String nodePath = qualifier.nodePath();
        if (nodePath == null || nodePath.length() == 0) {
            if (requestingObject == null) {
                return null;
            }
            nodePath = FrameworkUtil.getBundle(requestingObject).getSymbolicName();
        }
        return nodePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(String nodePath, String key, IRequestor requestor) {
        if (requestor == null) {
            return;
        }
        Map<String, HashMap<String, List<PrefInjectionListener>>> map = this.listenerCache;
        synchronized (map) {
            HashMap<String, List<PrefInjectionListener>> map2;
            if (this.listenerCache.containsKey(nodePath) && (map2 = this.listenerCache.get(nodePath)).containsKey(key)) {
                for (PrefInjectionListener listener : map2.get(key)) {
                    IRequestor previousRequestor = listener.getRequestor();
                    if (!previousRequestor.equals(requestor)) continue;
                    return;
                }
            }
        }
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(nodePath);
        PrefInjectionListener listener = new PrefInjectionListener(node, key, requestor);
        node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
        Map<String, HashMap<String, List<PrefInjectionListener>>> map3 = this.listenerCache;
        synchronized (map3) {
            List<PrefInjectionListener> listeningRequestors;
            HashMap<String, List<PrefInjectionListener>> map4 = this.listenerCache.get(nodePath);
            if (map4 == null) {
                map4 = new HashMap();
                this.listenerCache.put(nodePath, map4);
            }
            if ((listeningRequestors = map4.get(key)) == null) {
                listeningRequestors = new ArrayList<PrefInjectionListener>();
                map4.put(key, listeningRequestors);
            }
            listeningRequestors.add(listener);
        }
    }

    private static class PrefInjectionListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final IRequestor requestor;
        private final IEclipsePreferences node;
        private final String key;

        public PrefInjectionListener(IEclipsePreferences node, String key, IRequestor requestor) {
            this.node = node;
            this.key = key;
            this.requestor = requestor;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!this.requestor.isValid()) {
                this.node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                return;
            }
            if (!event.getKey().equals(this.key)) {
                return;
            }
            this.requestor.resolveArguments(false);
            this.requestor.execute();
        }

        public IRequestor getRequestor() {
            return this.requestor;
        }
    }
}

