/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.databinding.internal;

import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jdt.annotation.NonNull;

public final class TemplateComputedValue
extends ComputedValue {
    private @NonNull List<@NonNull IObservableValue> values;
    private @NonNull String template;

    public TemplateComputedValue(@NonNull Object o, @NonNull String template, @NonNull IValueProperty[] properties) {
        this.template = template;
        this.values = Stream.of(properties).map(p -> p.observe(o)).collect(Collectors.toList());
    }

    protected Object calculate() {
        Object[] v = this.values.stream().map(o -> o.getValue()).toArray();
        return MessageFormat.format(this.template, v);
    }

    public synchronized void dispose() {
        super.dispose();
        this.values.forEach(v -> v.dispose());
    }
}

